/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.asset.management.client.editors.repository.structure.release;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.Widget;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.guvnor.asset.management.client.i18n.Constants;
import org.gwtbootstrap3.client.ui.CheckBox;
import org.gwtbootstrap3.client.ui.FormGroup;
import org.gwtbootstrap3.client.ui.HelpBlock;
import org.gwtbootstrap3.client.ui.Input;
import org.gwtbootstrap3.client.ui.TextBox;
import org.gwtbootstrap3.client.ui.constants.ModalBackdrop;
import org.gwtbootstrap3.client.ui.constants.ValidationState;
import org.jboss.errai.security.shared.api.identity.User;
import org.uberfire.ext.widgets.common.client.common.popups.BaseModal;
import org.uberfire.ext.widgets.common.client.common.popups.footers.ModalFooterOKCancelButtons;

@Dependent
public class ReleaseScreenPopupViewImpl
extends BaseModal {
    private ReleaseScreenPopupWidgetBinder uiBinder = (ReleaseScreenPopupWidgetBinder)GWT.create(ReleaseScreenPopupWidgetBinder.class);
    @Inject
    private User identity;
    @UiField
    FormGroup repositoryTextGroup;
    @UiField
    TextBox repositoryText;
    @UiField
    HelpBlock repositoryTextHelpBlock;
    @UiField
    FormGroup sourceBranchTextGroup;
    @UiField
    TextBox sourceBranchText;
    @UiField
    HelpBlock sourceBranchTextHelpBlock;
    @UiField
    FormGroup userNameTextGroup;
    @UiField
    TextBox userNameText;
    @UiField
    HelpBlock userNameTextHelpBlock;
    @UiField
    FormGroup passwordTextGroup;
    @UiField
    Input passwordText;
    @UiField
    HelpBlock passwordTextHelpBlock;
    @UiField
    FormGroup serverURLTextGroup;
    @UiField
    TextBox serverURLText;
    @UiField
    HelpBlock serverURLTextHelpBlock;
    @UiField
    HelpBlock deployToRuntimeHelpBlock;
    @UiField
    FormGroup deployToRuntimeTextGroup;
    @UiField
    CheckBox deployToRuntimeCheck;
    @UiField
    HelpBlock versionTextHelpBlock;
    @UiField
    FormGroup versionTextGroup;
    @UiField
    TextBox versionText;
    private Command callbackCommand;
    private final Command okCommand = new Command(){

        public void execute() {
            if (this.isEmpty(ReleaseScreenPopupViewImpl.this.versionText.getText())) {
                ReleaseScreenPopupViewImpl.this.versionTextGroup.setValidationState(ValidationState.ERROR);
                ReleaseScreenPopupViewImpl.this.versionTextHelpBlock.setText(Constants.INSTANCE.FieldMandatory0("Version"));
                return;
            }
            if (this.isSnapshot(ReleaseScreenPopupViewImpl.this.versionText.getText())) {
                ReleaseScreenPopupViewImpl.this.versionTextGroup.setValidationState(ValidationState.ERROR);
                ReleaseScreenPopupViewImpl.this.versionTextHelpBlock.setText(Constants.INSTANCE.SnapshotNotAvailableForRelease("-SNAPSHOT"));
                return;
            }
            if (ReleaseScreenPopupViewImpl.this.deployToRuntimeCheck.getValue().booleanValue()) {
                if (this.isEmpty(ReleaseScreenPopupViewImpl.this.userNameText.getText())) {
                    ReleaseScreenPopupViewImpl.this.userNameTextGroup.setValidationState(ValidationState.ERROR);
                    ReleaseScreenPopupViewImpl.this.userNameTextHelpBlock.setText(Constants.INSTANCE.FieldMandatory0("Username"));
                    return;
                }
                if (this.isEmpty(ReleaseScreenPopupViewImpl.this.passwordText.getText())) {
                    ReleaseScreenPopupViewImpl.this.passwordTextGroup.setValidationState(ValidationState.ERROR);
                    ReleaseScreenPopupViewImpl.this.passwordTextHelpBlock.setText(Constants.INSTANCE.FieldMandatory0("Password"));
                    return;
                }
                if (this.isEmpty(ReleaseScreenPopupViewImpl.this.serverURLText.getText())) {
                    ReleaseScreenPopupViewImpl.this.serverURLTextGroup.setValidationState(ValidationState.ERROR);
                    ReleaseScreenPopupViewImpl.this.serverURLTextHelpBlock.setText(Constants.INSTANCE.FieldMandatory0("ServerURL"));
                    return;
                }
            }
            if (ReleaseScreenPopupViewImpl.this.callbackCommand != null) {
                ReleaseScreenPopupViewImpl.this.callbackCommand.execute();
            }
            ReleaseScreenPopupViewImpl.this.hide();
        }

        private boolean isEmpty(String value) {
            return value == null || value.isEmpty() || value.trim().isEmpty();
        }

        private boolean isSnapshot(String value) {
            return value != null && ReleaseScreenPopupViewImpl.this.trim(value).endsWith("-SNAPSHOT");
        }
    };
    private final Command cancelCommand = new Command(){

        public void execute() {
            ReleaseScreenPopupViewImpl.this.hide();
        }
    };
    private final ModalFooterOKCancelButtons footer = new ModalFooterOKCancelButtons(this.okCommand, this.cancelCommand);

    public ReleaseScreenPopupViewImpl() {
        this.setTitle(Constants.INSTANCE.Release_Configuration());
        this.setDataBackdrop(ModalBackdrop.STATIC);
        this.setDataKeyboard(true);
        this.setFade(true);
        this.setRemoveOnHide(true);
        this.setBody((Widget)this.uiBinder.createAndBindUi((Object)this));
        this.add((Widget)this.footer);
    }

    public void configure(String repositoryAlias, String branch, String suggestedVersion, String repositoryVersion, Command command) {
        this.callbackCommand = command;
        this.sourceBranchText.setText(branch);
        this.repositoryText.setText(repositoryAlias);
        this.sourceBranchText.setReadOnly(true);
        this.repositoryText.setReadOnly(true);
        this.userNameText.setText(this.identity.getIdentifier());
        this.serverURLText.setText(GWT.getModuleBaseURL().replaceFirst("/" + GWT.getModuleName() + "/", ""));
        this.versionTextHelpBlock.setText("The current repository version is: " + repositoryVersion);
        this.versionText.setText(suggestedVersion);
        this.userNameText.setEnabled(false);
        this.passwordText.setEnabled(false);
        this.serverURLText.setEnabled(false);
        this.deployToRuntimeCheck.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

            public void onValueChange(ValueChangeEvent<Boolean> event) {
                if (((Boolean)event.getValue()).booleanValue()) {
                    ReleaseScreenPopupViewImpl.this.userNameText.setEnabled(true);
                    ReleaseScreenPopupViewImpl.this.passwordText.setEnabled(true);
                    ReleaseScreenPopupViewImpl.this.serverURLText.setEnabled(true);
                } else {
                    ReleaseScreenPopupViewImpl.this.userNameText.setEnabled(false);
                    ReleaseScreenPopupViewImpl.this.passwordText.setEnabled(false);
                    ReleaseScreenPopupViewImpl.this.serverURLText.setEnabled(false);
                }
            }
        });
    }

    public String getUsername() {
        return this.trim(this.userNameText.getText());
    }

    public String getPassword() {
        return this.trim(this.passwordText.getText());
    }

    public String getServerURL() {
        return this.trim(this.serverURLText.getText());
    }

    public String getVersion() {
        return this.trim(this.versionText.getText());
    }

    public Boolean getDeployToRuntime() {
        return this.deployToRuntimeCheck.getValue();
    }

    private String trim(String value) {
        return value != null ? value.trim() : value;
    }

    static interface ReleaseScreenPopupWidgetBinder
    extends UiBinder<Widget, ReleaseScreenPopupViewImpl> {
    }
}

