/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.asset.management.client.editors.repository.structure;

import com.google.gwt.core.client.GWT;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.guvnor.asset.management.client.editors.project.structure.widgets.ProjectModulesView;
import org.guvnor.asset.management.client.editors.project.structure.widgets.RepositoryStructureDataView;
import org.guvnor.asset.management.client.editors.repository.structure.RepositoryStructurePresenter;
import org.guvnor.asset.management.client.editors.repository.structure.RepositoryStructureView;
import org.guvnor.asset.management.client.editors.repository.structure.configure.ConfigureScreenPopupViewImpl;
import org.guvnor.asset.management.client.editors.repository.structure.promote.PromoteScreenPopupViewImpl;
import org.guvnor.asset.management.client.editors.repository.structure.release.ReleaseScreenPopupViewImpl;
import org.guvnor.asset.management.model.RepositoryStructureModel;
import org.guvnor.common.services.project.model.POM;
import org.guvnor.common.services.project.model.Project;
import org.gwtbootstrap3.client.ui.Row;
import org.uberfire.ext.widgets.common.client.common.BusyPopup;

@Dependent
public class RepositoryStructureViewImpl
extends Composite
implements RepositoryStructureView {
    private RepositoryStructurePresenter presenter;
    private static RepositoryStructureViewImplBinder uiBinder = (RepositoryStructureViewImplBinder)GWT.create(RepositoryStructureViewImplBinder.class);
    @UiField
    Row dataViewContainer;
    @UiField(provided=true)
    RepositoryStructureDataView dataView;
    @UiField
    Row modulesViewContainer;
    @UiField(provided=true)
    ProjectModulesView modulesView;
    @Inject
    ReleaseScreenPopupViewImpl releaseScreenPopupView;
    @Inject
    ConfigureScreenPopupViewImpl configureScreenPopupView;
    @Inject
    PromoteScreenPopupViewImpl promoteScreenPopupView;

    @Inject
    public RepositoryStructureViewImpl(RepositoryStructureDataView dataView, ProjectModulesView modulesView) {
        this.dataView = dataView;
        this.modulesView = modulesView;
        this.initWidget((Widget)uiBinder.createAndBindUi(this));
    }

    @Override
    public void setPresenter(RepositoryStructurePresenter presenter) {
        this.presenter = presenter;
    }

    @Override
    public ReleaseScreenPopupViewImpl getReleaseScreenPopupView() {
        return this.releaseScreenPopupView;
    }

    @Override
    public ConfigureScreenPopupViewImpl getConfigureScreenPopupView() {
        return this.configureScreenPopupView;
    }

    @Override
    public PromoteScreenPopupViewImpl getPromoteScreenPopupView() {
        return this.promoteScreenPopupView;
    }

    public void showBusyIndicator(String message) {
        BusyPopup.showMessage((String)message);
    }

    public void hideBusyIndicator() {
        BusyPopup.close();
    }

    @Override
    public RepositoryStructureDataView getDataView() {
        return this.dataView;
    }

    @Override
    public ProjectModulesView getModulesView() {
        return this.modulesView;
    }

    @Override
    public void setModulesViewVisible(boolean visible) {
        this.modulesViewContainer.setVisible(visible);
    }

    @Override
    public void setModel(RepositoryStructureModel model) {
        if (model == null) {
            return;
        }
        if (model.getPathToPOM() != null) {
            this.getDataView().setGroupId(model.getPOM().getGav().getGroupId());
            this.getDataView().setArtifactId(model.getPOM().getGav().getArtifactId());
            this.getDataView().setVersion(model.getPOM().getGav().getVersion());
        } else if (model.isSingleProject()) {
            Project project = (Project)model.getOrphanProjects().get(0);
            POM pom = (POM)model.getOrphanProjectsPOM().get(project.getSignatureId());
            if (pom != null && pom.getGav() != null) {
                this.getDataView().setGroupId(pom.getGav().getGroupId());
                this.getDataView().setArtifactId(pom.getGav().getArtifactId());
                this.getDataView().setVersion(pom.getGav().getVersion());
            }
        }
    }

    @Override
    public void clear() {
        this.getDataView().clear();
    }

    static interface RepositoryStructureViewImplBinder
    extends UiBinder<Widget, RepositoryStructureViewImpl> {
    }
}

