/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.asset.management.client.editors.common;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.guvnor.asset.management.client.editors.common.BaseAssetsMgmtView;
import org.guvnor.asset.management.client.i18n.Constants;
import org.guvnor.asset.management.service.AssetManagementService;
import org.guvnor.asset.management.service.RepositoryStructureService;
import org.guvnor.structure.repositories.NewRepositoryEvent;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryEnvironmentUpdatedEvent;
import org.guvnor.structure.repositories.RepositoryRemovedEvent;
import org.guvnor.structure.repositories.RepositoryService;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.security.shared.api.identity.User;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.security.Resource;
import org.uberfire.security.impl.authz.RuntimeAuthorizationManager;

public abstract class BaseAssetsMgmtPresenter {
    protected Constants constants = Constants.INSTANCE;
    @Inject
    protected Caller<AssetManagementService> assetManagementServices;
    @Inject
    protected Caller<RepositoryService> repositoryServices;
    @Inject
    protected Caller<RepositoryStructureService> repositoryStructureServices;
    @Inject
    protected User identity;
    @Inject
    protected RuntimeAuthorizationManager authorizationManager;
    @Inject
    protected PlaceManager placeManager;
    protected Map<String, Repository> repositories = new TreeMap<String, Repository>();
    protected BaseAssetsMgmtView baseView;
    protected PlaceRequest place;

    public void init() {
    }

    public void loadRepositories() {
        ((RepositoryService)this.repositoryServices.call((RemoteCallback)new RemoteCallback<List<Repository>>(){

            public void callback(List<Repository> repositoriesResults) {
                BaseAssetsMgmtPresenter.this.repositories.clear();
                BaseAssetsMgmtPresenter.this.baseView.getChooseRepositoryBox().clear();
                BaseAssetsMgmtPresenter.this.baseView.getChooseRepositoryBox().addItem(BaseAssetsMgmtPresenter.this.constants.Select_Repository());
                for (Repository repository : repositoriesResults) {
                    BaseAssetsMgmtPresenter.this.repositories.put(repository.getAlias(), repository);
                }
                for (Map.Entry entry : BaseAssetsMgmtPresenter.this.repositories.entrySet()) {
                    if (!BaseAssetsMgmtPresenter.this.authorizationManager.authorize((Resource)entry.getValue(), BaseAssetsMgmtPresenter.this.identity) || !BaseAssetsMgmtPresenter.this.isManaged((Repository)entry.getValue())) continue;
                    BaseAssetsMgmtPresenter.this.baseView.getChooseRepositoryBox().addItem((String)entry.getKey(), ((Repository)entry.getValue()).getAlias());
                }
            }
        })).getRepositories();
    }

    public boolean isManaged(Repository value) {
        return value != null && value.getEnvironment() != null && Boolean.TRUE.equals(value.getEnvironment().get("managed"));
    }

    public Repository getRepository(String alias) {
        return this.repositories.get(alias);
    }

    public Collection<Repository> getRepositories() {
        return this.repositories.values();
    }

    private void onRepositoryAdded(@Observes NewRepositoryEvent event) {
        this.loadRepositories();
    }

    private void onRepositoryRemovedEvent(@Observes RepositoryRemovedEvent event) {
        this.loadRepositories();
    }

    private void onRepositoryUpdatedEvent(@Observes RepositoryEnvironmentUpdatedEvent event) {
        this.loadRepositories();
    }
}

