/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.asset.management.client.editors.release;

import com.google.gwt.core.client.GWT;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.guvnor.asset.management.client.editors.common.BaseAssetsMgmtPresenter;
import org.guvnor.asset.management.client.editors.common.BaseAssetsMgmtView;
import org.guvnor.asset.management.client.i18n.Constants;
import org.guvnor.asset.management.model.RepositoryStructureModel;
import org.guvnor.asset.management.service.AssetManagementService;
import org.guvnor.asset.management.service.RepositoryStructureService;
import org.guvnor.common.services.project.model.POM;
import org.guvnor.structure.repositories.Repository;
import org.gwtbootstrap3.client.ui.ListBox;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.mvp.UberView;
import org.uberfire.client.workbench.events.BeforeClosePlaceEvent;
import org.uberfire.ext.widgets.common.client.common.popups.errors.ErrorPopup;
import org.uberfire.lifecycle.OnOpen;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.PlaceRequest;

@Dependent
@WorkbenchScreen(identifier="Release Management")
public class ReleaseConfigurationPresenter
extends BaseAssetsMgmtPresenter {
    private Constants constants = (Constants)GWT.create(Constants.class);
    @Inject
    ReleaseConfigurationView view;
    @Inject
    private Event<BeforeClosePlaceEvent> closePlaceEvent;
    private boolean supportRuntimeDeployment;

    @OnStartup
    public void onStartup(PlaceRequest place) {
        this.place = place;
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return this.constants.Release_Configuration();
    }

    @WorkbenchPartView
    public UberView<ReleaseConfigurationPresenter> getView() {
        return this.view;
    }

    @Override
    @PostConstruct
    public void init() {
        this.baseView = this.view;
    }

    public void releaseProject(String repository, String branch, String userName, String password, String serverURL, Boolean deployToRuntime, String version) {
        if (serverURL != null && !serverURL.isEmpty() && serverURL.endsWith("/")) {
            serverURL = serverURL.substring(0, serverURL.length() - 1);
        }
        ((AssetManagementService)this.assetManagementServices.call((RemoteCallback)new RemoteCallback<Long>(){

            public void callback(Long taskId) {
                ReleaseConfigurationPresenter.this.view.displayNotification("Release project process started");
            }
        }, (ErrorCallback)new ErrorCallback<Message>(){

            public boolean error(Message message, Throwable throwable) {
                ErrorPopup.showMessage((String)("Unexpected error encountered : " + throwable.getMessage()));
                return true;
            }
        })).releaseProject(repository, branch, userName, password, serverURL, deployToRuntime, version);
    }

    public void loadServerSetting() {
        ((AssetManagementService)this.assetManagementServices.call((RemoteCallback)new RemoteCallback<Boolean>(){

            public void callback(Boolean supportRuntimeDeployment) {
                ReleaseConfigurationPresenter.this.view.showHideDeployToRuntimeSection(supportRuntimeDeployment);
            }
        })).supportRuntimeDeployment();
    }

    public void loadBranches(String alias) {
        Repository repository = this.getRepository(alias);
        if (repository != null) {
            this.view.getChooseBranchBox().clear();
            this.view.getChooseBranchBox().addItem(this.constants.Select_A_Branch());
            for (String branch : repository.getBranches()) {
                this.view.getChooseBranchBox().addItem(branch, branch);
            }
        }
    }

    public void loadRepositoryStructure(String repositoryAlias) {
        Repository repository;
        if (!repositoryAlias.equals(this.constants.Select_Repository()) && (repository = this.getRepository(repositoryAlias)) != null) {
            this.load(repository);
            return;
        }
    }

    private void load(Repository repository) {
        ((RepositoryStructureService)this.repositoryStructureServices.call((RemoteCallback)new RemoteCallback<RepositoryStructureModel>(){

            public void callback(RepositoryStructureModel model) {
                POM pom = ReleaseConfigurationPresenter.this.getPom(model);
                if (pom != null) {
                    ReleaseConfigurationPresenter.this.view.setCurrentVersionText(pom.getGav().getVersion().replace("-SNAPSHOT", ""));
                    ReleaseConfigurationPresenter.this.view.setVersionText(pom.getGav().getVersion().replace("-SNAPSHOT", ""));
                } else {
                    ReleaseConfigurationPresenter.this.view.setCurrentVersionText(ReleaseConfigurationPresenter.this.constants.No_Project_Structure_Available());
                    ReleaseConfigurationPresenter.this.view.setVersionText("1.0.0");
                }
            }
        })).load(repository, repository.getDefaultBranch());
    }

    private POM getPom(RepositoryStructureModel model) {
        if (model != null && (model.isSingleProject() || model.isMultiModule())) {
            return model.getActivePom();
        }
        return null;
    }

    protected void setSupportRuntimeDeployment(boolean b) {
        this.supportRuntimeDeployment = b;
    }

    public boolean getSupportRuntimeDeployment() {
        return this.supportRuntimeDeployment;
    }

    @OnOpen
    public void onOpen() {
        this.view.getChooseRepositoryBox().setFocus(true);
    }

    public static interface ReleaseConfigurationView
    extends UberView<ReleaseConfigurationPresenter>,
    BaseAssetsMgmtView {
        public ListBox getChooseBranchBox();

        public void showHideDeployToRuntimeSection(boolean var1);

        public void setCurrentVersionText(String var1);

        public void setVersionText(String var1);
    }
}

