/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.inbox.backend.server;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.inbox.backend.server.InboxEntry;
import org.guvnor.inbox.backend.server.PageRowBuilder;
import org.guvnor.inbox.model.InboxIncomingPageRow;
import org.guvnor.inbox.model.InboxPageRequest;
import org.guvnor.inbox.model.InboxPageRow;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.Path;
import org.uberfire.security.Identity;

public class InboxPageRowBuilder
implements PageRowBuilder<InboxPageRequest, Iterator<InboxEntry>> {
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    private InboxPageRequest pageRequest;
    private Iterator<InboxEntry> iterator;
    private Identity identity;

    @Override
    public List<InboxPageRow> build() {
        this.validate();
        int skipped = 0;
        Integer pageSize = this.pageRequest.getPageSize();
        int startRowIndex = this.pageRequest.getStartRowIndex();
        ArrayList<InboxPageRow> rowList = new ArrayList<InboxPageRow>();
        while (this.iterator.hasNext() && (pageSize == null || rowList.size() < pageSize)) {
            InboxEntry ie = this.iterator.next();
            if (skipped >= startRowIndex) {
                rowList.add(this.createInboxPageRow(ie, this.pageRequest));
            }
            ++skipped;
        }
        return rowList;
    }

    private InboxPageRow createInboxPageRow(InboxEntry inboxEntry, InboxPageRequest request) {
        InboxPageRow row = null;
        if (request.getInboxName().equals("incoming")) {
            InboxIncomingPageRow tr = new InboxIncomingPageRow();
            tr.setNote(inboxEntry.getNote());
            tr.setPath(this.makePath(inboxEntry.getItemPath()));
            tr.setTimestamp(new Date(inboxEntry.getTimestamp()));
            tr.setFrom(inboxEntry.getFrom());
            row = tr;
        } else {
            InboxPageRow tr = new InboxPageRow();
            tr.setNote(inboxEntry.getNote());
            tr.setPath(this.makePath(inboxEntry.getItemPath()));
            tr.setTimestamp(new Date(inboxEntry.getTimestamp()));
            row = tr;
        }
        return row;
    }

    private org.uberfire.backend.vfs.Path makePath(String fullPath) {
        try {
            Path path = this.ioService.get(new URI(fullPath));
            return Paths.convert((Path)path);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    @Override
    public void validate() {
        if (this.pageRequest == null) {
            throw new IllegalArgumentException("PageRequest cannot be null");
        }
        if (this.iterator == null) {
            throw new IllegalArgumentException("Content cannot be null");
        }
    }

    public InboxPageRowBuilder withPageRequest(InboxPageRequest pageRequest) {
        this.pageRequest = pageRequest;
        return this;
    }

    public InboxPageRowBuilder withIdentity(Identity identity) {
        this.identity = identity;
        return this;
    }

    public InboxPageRowBuilder withContent(Iterator<InboxEntry> iterator) {
        this.iterator = iterator;
        return this;
    }
}

