/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.backend.server;

import java.util.Date;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.common.services.backend.exceptions.ExceptionUtilities;
import org.guvnor.common.services.project.backend.server.KModuleContentHandler;
import org.guvnor.common.services.project.model.KModuleModel;
import org.guvnor.common.services.project.service.KModuleService;
import org.guvnor.common.services.shared.metadata.MetadataService;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.jboss.errai.bus.server.annotations.Service;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.base.options.CommentedOption;
import org.uberfire.java.nio.file.FileAlreadyExistsException;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.attribute.FileAttribute;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.security.Identity;

@Service
@ApplicationScoped
public class KModuleServiceImpl
implements KModuleService {
    private IOService ioService;
    private MetadataService metadataService;
    private KModuleContentHandler moduleContentHandler;
    private Identity identity;
    private SessionInfo sessionInfo;

    public KModuleServiceImpl() {
    }

    @Inject
    public KModuleServiceImpl(@Named(value="ioStrategy") IOService ioService, MetadataService metadataService, KModuleContentHandler moduleContentHandler, Identity identity, SessionInfo sessionInfo) {
        this.ioService = ioService;
        this.metadataService = metadataService;
        this.moduleContentHandler = moduleContentHandler;
        this.identity = identity;
        this.sessionInfo = sessionInfo;
    }

    public org.uberfire.backend.vfs.Path setUpKModuleStructure(org.uberfire.backend.vfs.Path projectRoot) {
        try {
            Path nioRoot = Paths.convert((org.uberfire.backend.vfs.Path)projectRoot);
            this.ioService.createDirectory(nioRoot.resolve("src/main/java"), new FileAttribute[0]);
            this.ioService.createDirectory(nioRoot.resolve("src/main/resources"), new FileAttribute[0]);
            this.ioService.createDirectory(nioRoot.resolve("src/test/java"), new FileAttribute[0]);
            this.ioService.createDirectory(nioRoot.resolve("src/test/resources"), new FileAttribute[0]);
            Path pathToKModuleXML = nioRoot.resolve("src/main/resources/META-INF/kmodule.xml");
            if (this.ioService.exists(pathToKModuleXML)) {
                throw new FileAlreadyExistsException(pathToKModuleXML.toString());
            }
            this.ioService.write(pathToKModuleXML, this.moduleContentHandler.toString(new KModuleModel()), new OpenOption[0]);
            return Paths.convert((Path)pathToKModuleXML);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public KModuleModel load(org.uberfire.backend.vfs.Path path) {
        try {
            Path nioPath = Paths.convert((org.uberfire.backend.vfs.Path)path);
            String content = this.ioService.readAllString(nioPath);
            return this.moduleContentHandler.toModel(content);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public org.uberfire.backend.vfs.Path save(org.uberfire.backend.vfs.Path path, KModuleModel content, Metadata metadata, String comment) {
        try {
            if (metadata == null) {
                this.ioService.write(Paths.convert((org.uberfire.backend.vfs.Path)path), this.moduleContentHandler.toString(content), new OpenOption[]{this.makeCommentedOption(comment)});
            } else {
                this.ioService.write(Paths.convert((org.uberfire.backend.vfs.Path)path), this.moduleContentHandler.toString(content), this.metadataService.setUpAttributes(path, metadata), new OpenOption[]{this.makeCommentedOption(comment)});
            }
            return path;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    private CommentedOption makeCommentedOption(String commitMessage) {
        String name = this.identity.getName();
        Date when = new Date();
        CommentedOption co = new CommentedOption(this.sessionInfo.getId(), name, null, commitMessage, when);
        return co;
    }
}

