/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.backend.server;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.event.Event;
import org.guvnor.common.services.project.backend.server.DeleteProjectObserverBridge;
import org.guvnor.common.services.project.events.DeleteProjectEvent;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.common.services.project.project.ProjectFactory;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.Path;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.workbench.events.ResourceBatchChangesEvent;
import org.uberfire.workbench.events.ResourceChange;
import org.uberfire.workbench.events.ResourceDeleted;
import org.uberfire.workbench.events.ResourceDeletedEvent;
import org.uberfire.workbench.events.ResourceUpdated;

public class DeleteProjectObserverBridgeTest {
    private DeleteProjectObserverBridge bridge;
    private IOService ioService;
    private ProjectFactory<? extends Project> projectFactory;
    private Event<DeleteProjectEvent> deleteProjectEvent;
    private SessionInfo sessionInfo = (SessionInfo)Mockito.mock(SessionInfo.class);

    @Before
    public void setup() {
        this.ioService = (IOService)Mockito.mock(IOService.class);
        this.projectFactory = (ProjectFactory)Mockito.mock(ProjectFactory.class);
        this.deleteProjectEvent = (Event)Mockito.mock(Event.class);
        this.bridge = new DeleteProjectObserverBridge(this.ioService, this.projectFactory, this.deleteProjectEvent);
    }

    @Test
    public void testResourceDeletedEventPomFile() {
        org.uberfire.backend.vfs.Path path = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        Path nioPath = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)path.getFileName()).thenReturn((Object)"pom.xml");
        Mockito.when((Object)path.toURI()).thenReturn((Object)"file://project1/pom.xml");
        Mockito.when((Object)this.ioService.get((URI)Mockito.any(URI.class))).thenReturn((Object)nioPath);
        this.bridge.onBatchResourceChanges(new ResourceDeletedEvent(path, "message", this.sessionInfo));
        ((Event)Mockito.verify(this.deleteProjectEvent, (VerificationMode)Mockito.times((int)1))).fire(Mockito.any(DeleteProjectEvent.class));
    }

    @Test
    public void testResourceDeletedEventNonPomFile() {
        org.uberfire.backend.vfs.Path path = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        Path nioPath = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)path.getFileName()).thenReturn((Object)"cheese.drl");
        Mockito.when((Object)path.toURI()).thenReturn((Object)"file://project1/cheese.drl");
        Mockito.when((Object)this.ioService.get((URI)Mockito.any(URI.class))).thenReturn((Object)nioPath);
        this.bridge.onBatchResourceChanges(new ResourceDeletedEvent(path, "message", this.sessionInfo));
        ((Event)Mockito.verify(this.deleteProjectEvent, (VerificationMode)Mockito.times((int)0))).fire(Mockito.any(DeleteProjectEvent.class));
    }

    @Test
    public void testResourceBatchChangesEventUpdatePomFile() {
        final org.uberfire.backend.vfs.Path path = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        Path nioPath = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)path.getFileName()).thenReturn((Object)"pom.xml");
        Mockito.when((Object)path.toURI()).thenReturn((Object)"file://project1/pom.xml");
        Mockito.when((Object)this.ioService.get((URI)Mockito.any(URI.class))).thenReturn((Object)nioPath);
        HashMap<org.uberfire.backend.vfs.Path, Collection<ResourceChange>> batch = new HashMap<org.uberfire.backend.vfs.Path, Collection<ResourceChange>>(){
            {
                this.put(path, new ArrayList<ResourceChange>(){
                    {
                        this.add(new ResourceUpdated(""));
                    }
                });
            }
        };
        this.bridge.onBatchResourceChanges(new ResourceBatchChangesEvent((Map)batch, "message", this.sessionInfo));
        ((Event)Mockito.verify(this.deleteProjectEvent, (VerificationMode)Mockito.times((int)0))).fire(Mockito.any(DeleteProjectEvent.class));
    }

    @Test
    public void testResourceBatchChangesEventUpdateNonPomFile() {
        final org.uberfire.backend.vfs.Path path = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        Path nioPath = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)path.getFileName()).thenReturn((Object)"cheese.drl");
        Mockito.when((Object)path.toURI()).thenReturn((Object)"file://project1/cheese.drl");
        Mockito.when((Object)this.ioService.get((URI)Mockito.any(URI.class))).thenReturn((Object)nioPath);
        HashMap<org.uberfire.backend.vfs.Path, Collection<ResourceChange>> batch = new HashMap<org.uberfire.backend.vfs.Path, Collection<ResourceChange>>(){
            {
                this.put(path, new ArrayList<ResourceChange>(){
                    {
                        this.add(new ResourceUpdated(""));
                    }
                });
            }
        };
        this.bridge.onBatchResourceChanges(new ResourceBatchChangesEvent((Map)batch, "message", this.sessionInfo));
        ((Event)Mockito.verify(this.deleteProjectEvent, (VerificationMode)Mockito.times((int)0))).fire(Mockito.any(DeleteProjectEvent.class));
    }

    @Test
    public void testResourceBatchChangesEventDeletePomFile() {
        final org.uberfire.backend.vfs.Path path = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        Path nioPath = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)path.getFileName()).thenReturn((Object)"pom.xml");
        Mockito.when((Object)path.toURI()).thenReturn((Object)"file://project1/pom.xml");
        Mockito.when((Object)this.ioService.get((URI)Mockito.any(URI.class))).thenReturn((Object)nioPath);
        HashMap<org.uberfire.backend.vfs.Path, Collection<ResourceChange>> batch = new HashMap<org.uberfire.backend.vfs.Path, Collection<ResourceChange>>(){
            {
                this.put(path, new ArrayList<ResourceChange>(){
                    {
                        this.add(new ResourceDeleted(""));
                    }
                });
            }
        };
        this.bridge.onBatchResourceChanges(new ResourceBatchChangesEvent((Map)batch, "message", this.sessionInfo));
        ((Event)Mockito.verify(this.deleteProjectEvent, (VerificationMode)Mockito.times((int)1))).fire(Mockito.any(DeleteProjectEvent.class));
    }

    @Test
    public void testResourceBatchChangesEventDeleteNonPomFile() {
        final org.uberfire.backend.vfs.Path path = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        Path nioPath = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)path.getFileName()).thenReturn((Object)"cheese.drl");
        Mockito.when((Object)path.toURI()).thenReturn((Object)"file://project1/cheese.drl");
        Mockito.when((Object)this.ioService.get((URI)Mockito.any(URI.class))).thenReturn((Object)nioPath);
        HashMap<org.uberfire.backend.vfs.Path, Collection<ResourceChange>> batch = new HashMap<org.uberfire.backend.vfs.Path, Collection<ResourceChange>>(){
            {
                this.put(path, new ArrayList<ResourceChange>(){
                    {
                        this.add(new ResourceDeleted(""));
                    }
                });
            }
        };
        this.bridge.onBatchResourceChanges(new ResourceBatchChangesEvent((Map)batch, "message", this.sessionInfo));
        ((Event)Mockito.verify(this.deleteProjectEvent, (VerificationMode)Mockito.times((int)0))).fire(Mockito.any(DeleteProjectEvent.class));
    }
}

