/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.backend.server;

import java.net.URL;
import java.util.List;
import org.guvnor.common.services.project.backend.server.CDITestBase;
import org.guvnor.common.services.project.model.Dependency;
import org.guvnor.common.services.project.model.POM;
import org.guvnor.common.services.project.service.POMService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.java.nio.file.Path;

@RunWith(value=MockitoJUnitRunner.class)
public class POMServiceImplLoadTest
extends CDITestBase {
    private POMService service;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.service = this.getReference(POMService.class);
    }

    @Test
    public void testLoad() throws Exception {
        URL url = this.getClass().getResource("/TestProject/pom.xml");
        POM pom = (POM)this.service.load(Paths.convert((Path)this.fs.getPath(url.toURI())));
        Assert.assertEquals((Object)"org.test", (Object)pom.getGav().getGroupId());
        Assert.assertEquals((Object)"my-test", (Object)pom.getGav().getArtifactId());
        Assert.assertEquals((Object)"1.0", (Object)pom.getGav().getVersion());
        Assert.assertEquals((long)2L, (long)pom.getDependencies().size());
        this.assertContainsDependency("org.apache.commons", "commons-lang3", "compile", (List<Dependency>)pom.getDependencies());
        this.assertContainsDependency("org.jboss.weld", "weld-core", "test", (List<Dependency>)pom.getDependencies());
    }

    private void assertContainsDependency(String groupID, String artifactID, String scope, List<Dependency> dependencies) {
        boolean foundOne = false;
        for (Dependency dependency : dependencies) {
            if (!groupID.equals(dependency.getGroupId()) || !artifactID.equals(dependency.getArtifactId()) || !scope.equals(dependency.getScope()) && (!scope.equals("compile") || dependency.getScope() != null)) continue;
            foundOne = true;
        }
        Assert.assertTrue((String)("Did not find dependency: " + groupID + ":" + artifactID + ":" + scope), (boolean)foundOne);
    }
}

