/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.backend.server.utils;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.Dependent;
import org.apache.maven.model.Build;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.guvnor.common.services.project.backend.server.utils.BuildContentHandler;
import org.guvnor.common.services.project.backend.server.utils.DependencyContentHandler;
import org.guvnor.common.services.project.backend.server.utils.DependencyUpdater;
import org.guvnor.common.services.project.model.Dependency;
import org.guvnor.common.services.project.model.GAV;
import org.guvnor.common.services.project.model.POM;
import org.guvnor.common.services.project.model.Repository;

@Dependent
public class POMContentHandler {
    public String toString(POM pomModel) throws IOException {
        return this.toString(pomModel, new Model());
    }

    private String toString(POM pom, Model model) throws IOException {
        model.setName(pom.getName());
        model.setDescription(pom.getDescription());
        model.setArtifactId(pom.getGav().getArtifactId());
        model.setModelVersion(pom.getModelVersion());
        model.setGroupId(pom.getGav().getGroupId());
        model.setVersion(pom.getGav().getVersion());
        model.setPackaging(pom.getPackaging());
        model.setParent(this.getParent(pom));
        model.setBuild(this.getBuild(pom, model));
        model.setModules(this.getModules(pom));
        model.setRepositories(this.getRepositories(pom));
        new DependencyUpdater(model.getDependencies()).updateDependencies((List<Dependency>)pom.getDependencies());
        StringWriter stringWriter = new StringWriter();
        new MavenXpp3Writer().write((Writer)stringWriter, model);
        return stringWriter.toString();
    }

    private Build getBuild(POM pom, Model model) {
        return new BuildContentHandler().update(pom.getBuild(), model.getBuild());
    }

    private ArrayList<org.apache.maven.model.Repository> getRepositories(POM pom) {
        ArrayList<org.apache.maven.model.Repository> result = new ArrayList<org.apache.maven.model.Repository>();
        for (Repository repository : pom.getRepositories()) {
            result.add(this.fromClientModelToPom(repository));
        }
        return result;
    }

    private ArrayList<String> getModules(POM pom) {
        ArrayList<String> result = new ArrayList<String>();
        if (pom.getModules() != null) {
            for (String module : pom.getModules()) {
                result.add(module);
            }
        }
        return result;
    }

    private Parent getParent(POM pom) {
        if (pom.getParent() == null) {
            return null;
        }
        Parent parent = new Parent();
        parent.setGroupId(pom.getParent().getGroupId());
        parent.setArtifactId(pom.getParent().getArtifactId());
        parent.setVersion(pom.getParent().getVersion());
        return parent;
    }

    public String toString(POM gavModel, String originalPomAsText) throws IOException, XmlPullParserException {
        return this.toString(gavModel, new MavenXpp3Reader().read((Reader)new StringReader(originalPomAsText)));
    }

    private org.apache.maven.model.Repository fromClientModelToPom(Repository from) {
        org.apache.maven.model.Repository to = new org.apache.maven.model.Repository();
        to.setId(from.getId());
        to.setName(from.getName());
        to.setUrl(from.getUrl());
        return to;
    }

    public POM toModel(String pomAsString) throws IOException, XmlPullParserException {
        Model model = new MavenXpp3Reader().read((Reader)new StringReader(pomAsString));
        POM pomModel = new POM(model.getName(), model.getDescription(), new GAV(model.getGroupId() == null ? model.getParent().getGroupId() : model.getGroupId(), model.getArtifactId() == null ? model.getParent().getArtifactId() : model.getArtifactId(), model.getVersion() == null ? model.getParent().getVersion() : model.getVersion()));
        pomModel.setPackaging(model.getPackaging());
        if (model.getParent() != null) {
            pomModel.setParent(new GAV(model.getParent().getGroupId(), model.getParent().getArtifactId(), model.getParent().getVersion()));
        }
        pomModel.getModules().clear();
        for (String module : model.getModules()) {
            pomModel.getModules().add(module);
            pomModel.setPackaging("pom");
        }
        for (org.apache.maven.model.Repository repository : model.getRepositories()) {
            pomModel.addRepository(this.fromPomModelToClientModel(repository));
        }
        pomModel.setDependencies(new DependencyContentHandler().fromPomModelToClientModel(model.getDependencies()));
        pomModel.setBuild(new BuildContentHandler().fromPomModelToClientModel(model.getBuild()));
        return pomModel;
    }

    private Repository fromPomModelToClientModel(org.apache.maven.model.Repository from) {
        Repository to = new Repository();
        to.setId(from.getId());
        to.setName(from.getName());
        to.setUrl(from.getUrl());
        return to;
    }
}

