/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.rest.backend;

import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.guvnor.asset.management.model.ExecuteOperationEvent;
import org.guvnor.rest.backend.cmd.AddRepositoryToOrgUnitCmd;
import org.guvnor.rest.backend.cmd.CompileProjectCmd;
import org.guvnor.rest.backend.cmd.CreateOrCloneRepositoryCmd;
import org.guvnor.rest.backend.cmd.CreateOrgUnitCmd;
import org.guvnor.rest.backend.cmd.CreateProjectCmd;
import org.guvnor.rest.backend.cmd.DeleteProjectCmd;
import org.guvnor.rest.backend.cmd.DeployProjectCmd;
import org.guvnor.rest.backend.cmd.InstallProjectCmd;
import org.guvnor.rest.backend.cmd.RemoveOrgUnitCmd;
import org.guvnor.rest.backend.cmd.RemoveRepositoryCmd;
import org.guvnor.rest.backend.cmd.RemoveRepositoryFromOrgUnitCmd;
import org.guvnor.rest.backend.cmd.TestProjectCmd;
import org.guvnor.rest.client.AddRepositoryToOrganizationalUnitRequest;
import org.guvnor.rest.client.CompileProjectRequest;
import org.guvnor.rest.client.CreateOrCloneRepositoryRequest;
import org.guvnor.rest.client.CreateOrganizationalUnitRequest;
import org.guvnor.rest.client.CreateProjectRequest;
import org.guvnor.rest.client.DeleteProjectRequest;
import org.guvnor.rest.client.DeployProjectRequest;
import org.guvnor.rest.client.InstallProjectRequest;
import org.guvnor.rest.client.JobRequest;
import org.guvnor.rest.client.RemoveOrganizationalUnitRequest;
import org.guvnor.rest.client.RemoveRepositoryFromOrganizationalUnitRequest;
import org.guvnor.rest.client.RemoveRepositoryRequest;
import org.guvnor.rest.client.TestProjectRequest;
import org.kie.internal.executor.api.CommandContext;
import org.kie.internal.executor.api.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class JobRequestScheduler {
    private static final Logger logger = LoggerFactory.getLogger(JobRequestScheduler.class);
    @Inject
    private Event<ExecuteOperationEvent> excuteOperationEvent;

    public void createOrCloneRepositoryRequest(CreateOrCloneRepositoryRequest jobRequest) {
        Map params = this.getContext((JobRequest)jobRequest).getData();
        params.put("CommandClass", CreateOrCloneRepositoryCmd.class.getName());
        params.put("Repository", jobRequest.getRepository());
        params.put("Operation", "createOrCloneRepository");
        this.excuteOperationEvent.fire((Object)new ExecuteOperationEvent(params));
    }

    public void removeRepositoryRequest(RemoveRepositoryRequest jobRequest) {
        Map params = this.getContext((JobRequest)jobRequest).getData();
        params.put("CommandClass", RemoveRepositoryCmd.class.getName());
        params.put("Repository", jobRequest.getRepositoryName());
        params.put("Operation", "removeRepository");
        this.excuteOperationEvent.fire((Object)new ExecuteOperationEvent(params));
    }

    public void createProjectRequest(CreateProjectRequest jobRequest) {
        Map params = this.getContext((JobRequest)jobRequest).getData();
        params.put("CommandClass", CreateProjectCmd.class.getName());
        params.put("Repository", jobRequest.getRepositoryName());
        params.put("Project", jobRequest.getProjectName());
        params.put("Operation", "createProject");
        this.excuteOperationEvent.fire((Object)new ExecuteOperationEvent(params));
    }

    public void deleteProjectRequest(DeleteProjectRequest jobRequest) {
        Map params = this.getContext((JobRequest)jobRequest).getData();
        params.put("CommandClass", DeleteProjectCmd.class.getName());
        params.put("Repository", jobRequest.getRepositoryName());
        params.put("Project", jobRequest.getProjectName());
        params.put("Operation", "deleteProject");
        this.excuteOperationEvent.fire((Object)new ExecuteOperationEvent(params));
    }

    public void compileProjectRequest(CompileProjectRequest jobRequest) {
        Map params = this.getContext((JobRequest)jobRequest).getData();
        params.put("CommandClass", CompileProjectCmd.class.getName());
        params.put("Repository", jobRequest.getRepositoryName());
        params.put("Project", jobRequest.getProjectName());
        params.put("Operation", "compileProject");
        this.excuteOperationEvent.fire((Object)new ExecuteOperationEvent(params));
    }

    public void installProjectRequest(InstallProjectRequest jobRequest) {
        Map params = this.getContext((JobRequest)jobRequest).getData();
        params.put("CommandClass", InstallProjectCmd.class.getName());
        params.put("Repository", jobRequest.getRepositoryName());
        params.put("Project", jobRequest.getProjectName());
        params.put("Operation", "installProject");
        this.excuteOperationEvent.fire((Object)new ExecuteOperationEvent(params));
    }

    public void testProjectRequest(TestProjectRequest jobRequest) {
        Map params = this.getContext((JobRequest)jobRequest).getData();
        params.put("CommandClass", TestProjectCmd.class.getName());
        params.put("Repository", jobRequest.getRepositoryName());
        params.put("Project", jobRequest.getProjectName());
        params.put("Operation", "testProject");
        this.excuteOperationEvent.fire((Object)new ExecuteOperationEvent(params));
    }

    public void deployProjectRequest(DeployProjectRequest jobRequest) {
        Map params = this.getContext((JobRequest)jobRequest).getData();
        params.put("CommandClass", DeployProjectCmd.class.getName());
        params.put("Repository", jobRequest.getRepositoryName());
        params.put("Project", jobRequest.getProjectName());
        params.put("Operation", "deployProject");
        this.excuteOperationEvent.fire((Object)new ExecuteOperationEvent(params));
    }

    public void createOrganizationalUnitRequest(CreateOrganizationalUnitRequest jobRequest) {
        Map params = this.getContext((JobRequest)jobRequest).getData();
        params.put("CommandClass", CreateOrgUnitCmd.class.getName());
        params.put("Operation", "createOrgUnit");
        this.excuteOperationEvent.fire((Object)new ExecuteOperationEvent(params));
    }

    public void addRepositoryToOrganizationalUnitRequest(AddRepositoryToOrganizationalUnitRequest jobRequest) {
        Map params = this.getContext((JobRequest)jobRequest).getData();
        params.put("CommandClass", AddRepositoryToOrgUnitCmd.class.getName());
        params.put("Repository", jobRequest.getRepositoryName());
        params.put("Operation", "addRepositoryToOrgUnit");
        this.excuteOperationEvent.fire((Object)new ExecuteOperationEvent(params));
    }

    public void removeRepositoryFromOrganizationalUnitRequest(RemoveRepositoryFromOrganizationalUnitRequest jobRequest) {
        Map params = this.getContext((JobRequest)jobRequest).getData();
        params.put("CommandClass", RemoveRepositoryFromOrgUnitCmd.class.getName());
        params.put("Repository", jobRequest.getRepositoryName());
        params.put("Operation", "removeRepositoryFromOrgUnit");
        this.excuteOperationEvent.fire((Object)new ExecuteOperationEvent(params));
    }

    public void removeOrganizationalUnitRequest(RemoveOrganizationalUnitRequest jobRequest) {
        Map params = this.getContext((JobRequest)jobRequest).getData();
        params.put("CommandClass", RemoveOrgUnitCmd.class.getName());
        params.put("Operation", "removeOrgUnit");
        this.excuteOperationEvent.fire((Object)new ExecuteOperationEvent(params));
    }

    protected CommandContext getContext(JobRequest jobRequest) {
        CommandContext ctx = new CommandContext();
        ctx.setData("JobRequest", (Object)jobRequest);
        ctx.setData("Retries", (Object)0);
        ctx.setData("Owner", (Object)ExecutorService.EXECUTOR_ID);
        return ctx;
    }
}

