/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.rest.backend;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.core.Variant;
import org.guvnor.common.services.project.model.GAV;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.common.services.project.service.ProjectService;
import org.guvnor.rest.backend.JobRequestScheduler;
import org.guvnor.rest.backend.JobResultManager;
import org.guvnor.rest.client.AddRepositoryToOrganizationalUnitRequest;
import org.guvnor.rest.client.BuildConfig;
import org.guvnor.rest.client.CompileProjectRequest;
import org.guvnor.rest.client.CreateOrCloneRepositoryRequest;
import org.guvnor.rest.client.CreateOrganizationalUnitRequest;
import org.guvnor.rest.client.CreateProjectRequest;
import org.guvnor.rest.client.DeleteProjectRequest;
import org.guvnor.rest.client.DeployProjectRequest;
import org.guvnor.rest.client.InstallProjectRequest;
import org.guvnor.rest.client.JobRequest;
import org.guvnor.rest.client.JobResult;
import org.guvnor.rest.client.JobStatus;
import org.guvnor.rest.client.OrganizationalUnit;
import org.guvnor.rest.client.ProjectRequest;
import org.guvnor.rest.client.ProjectResponse;
import org.guvnor.rest.client.RemoveOrganizationalUnitRequest;
import org.guvnor.rest.client.RemoveRepositoryFromOrganizationalUnitRequest;
import org.guvnor.rest.client.RemoveRepositoryRequest;
import org.guvnor.rest.client.RepositoryRequest;
import org.guvnor.rest.client.RepositoryResponse;
import org.guvnor.rest.client.TestProjectRequest;
import org.guvnor.structure.organizationalunit.OrganizationalUnitService;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.io.IOService;

@Path(value="/")
@Named
@ApplicationScoped
public class ProjectResource {
    private static final Logger logger = LoggerFactory.getLogger(ProjectResource.class);
    @Context
    protected UriInfo uriInfo;
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    @Inject
    private OrganizationalUnitService organizationalUnitService;
    @Inject
    private RepositoryService repositoryService;
    @Inject
    private ProjectService<? extends Project> projectService;
    @Inject
    private JobRequestScheduler jobRequestObserver;
    @Inject
    private JobResultManager jobManager;
    private AtomicLong counter = new AtomicLong(0L);
    private static Variant defaultVariant = (Variant)Variant.mediaTypes((MediaType[])new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).add().build().get(0);

    private void addAcceptedJobResult(String jobId) {
        JobResult jobResult = new JobResult();
        jobResult.setJobId(jobId);
        jobResult.setStatus(JobStatus.ACCEPTED);
        this.jobManager.putJob(jobResult);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/jobs/{jobId}")
    public JobResult getJobStatus(@PathParam(value="jobId") String jobId) {
        logger.debug("-----getJobStatus--- , jobId: {}", (Object)jobId);
        JobResult job = this.jobManager.getJob(jobId);
        if (job == null) {
            logger.debug("-----getJobStatus--- , can not find jobId: " + jobId + ", the job has gone probably because its done and has been removed.");
            job = new JobResult();
            job.setStatus(JobStatus.GONE);
            return job;
        }
        return job;
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/jobs/{jobId}")
    public JobResult removeJob(@PathParam(value="jobId") String jobId) {
        logger.debug("-----removeJob--- , jobId: {}", (Object)jobId);
        JobResult job = this.jobManager.removeJob(jobId);
        if (job == null) {
            logger.debug("-----removeJob--- , can not find jobId: " + jobId + ", the job has gone probably because its done and has been removed.");
            job = new JobResult();
            job.setStatus(JobStatus.GONE);
            return job;
        }
        job.setStatus(JobStatus.GONE);
        return job;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/repositories")
    public Collection<RepositoryResponse> getRepositories() {
        logger.debug("-----getRepositories--- ");
        Collection repos = this.repositoryService.getRepositories();
        ArrayList<RepositoryResponse> result = new ArrayList<RepositoryResponse>();
        for (Repository r : repos) {
            RepositoryResponse repo = new RepositoryResponse();
            repo.setGitURL(r.getUri());
            repo.setName(r.getAlias());
            result.add(repo);
        }
        return result;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/repositories/{repositoryName}")
    public RepositoryResponse getRepository(@PathParam(value="repositoryName") String repositoryName) {
        logger.debug("-----getRepository---, repository name: {}", (Object)repositoryName);
        Repository origRepo = this.checkRepositoryExistence(repositoryName);
        RepositoryResponse repo = new RepositoryResponse();
        repo.setGitURL(origRepo.getUri());
        repo.setName(origRepo.getAlias());
        return repo;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/repositories")
    public Response createOrCloneRepository(RepositoryRequest repository) {
        logger.debug("-----createOrCloneRepository--- , repository name: {}", (Object)repository.getName());
        String id = "" + System.currentTimeMillis() + "-" + this.counter.incrementAndGet();
        CreateOrCloneRepositoryRequest jobRequest = new CreateOrCloneRepositoryRequest();
        jobRequest.setStatus(JobStatus.ACCEPTED);
        jobRequest.setJobId(id);
        jobRequest.setRepository(repository);
        String reqType = repository.getRequestType();
        if (reqType == null || reqType.trim().isEmpty() || !"new".equals(reqType) && !"clone".equals(reqType)) {
            jobRequest.setStatus(JobStatus.BAD_REQUEST);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)jobRequest).variant(defaultVariant).build();
        }
        this.addAcceptedJobResult(id);
        this.jobRequestObserver.createOrCloneRepositoryRequest(jobRequest);
        return this.createAcceptedStatusResponse((JobRequest)jobRequest);
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/repositories/{repositoryName}")
    public Response removeRepository(@PathParam(value="repositoryName") String repositoryName) {
        logger.debug("-----removeRepository--- , repositoryName: {}", (Object)repositoryName);
        String id = "" + System.currentTimeMillis() + "-" + this.counter.incrementAndGet();
        RemoveRepositoryRequest jobRequest = new RemoveRepositoryRequest();
        jobRequest.setStatus(JobStatus.ACCEPTED);
        jobRequest.setJobId(id);
        jobRequest.setRepositoryName(repositoryName);
        this.addAcceptedJobResult(id);
        this.jobRequestObserver.removeRepositoryRequest(jobRequest);
        return this.createAcceptedStatusResponse((JobRequest)jobRequest);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/repositories/{repositoryName}/projects")
    public Response createProject(@PathParam(value="repositoryName") String repositoryName, ProjectRequest project) {
        logger.debug("-----createProject--- , repositoryName: {} , project name: {}", (Object)repositoryName, (Object)project.getName());
        this.checkRepositoryExistence(repositoryName);
        String id = "" + System.currentTimeMillis() + "-" + this.counter.incrementAndGet();
        CreateProjectRequest jobRequest = new CreateProjectRequest();
        jobRequest.setStatus(JobStatus.ACCEPTED);
        jobRequest.setJobId(id);
        jobRequest.setRepositoryName(repositoryName);
        jobRequest.setProjectName(project.getName());
        jobRequest.setProjectGroupId(project.getGroupId());
        jobRequest.setProjectVersion(project.getVersion());
        jobRequest.setDescription(project.getDescription());
        this.addAcceptedJobResult(id);
        this.jobRequestObserver.createProjectRequest(jobRequest);
        return this.createAcceptedStatusResponse((JobRequest)jobRequest);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/repositories/{repositoryName}/projects")
    public List<ProjectResponse> getProjects(@PathParam(value="repositoryName") String repositoryName) {
        logger.info("-----getProjects--- , repositoryName: {}", (Object)repositoryName);
        Repository repository = this.repositoryService.getRepository(repositoryName);
        if (repository == null) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)repositoryName).build());
        }
        Set projects = this.projectService.getProjects(repository, repository.getCurrentBranch());
        ArrayList<ProjectResponse> projectRequests = new ArrayList<ProjectResponse>(projects.size());
        for (Project project : projects) {
            ProjectResponse projectReq = new ProjectResponse();
            GAV projectGAV = project.getPom().getGav();
            projectReq.setGroupId(projectGAV.getGroupId());
            projectReq.setName(projectGAV.getArtifactId());
            projectReq.setVersion(projectGAV.getVersion());
            projectRequests.add(projectReq);
        }
        return projectRequests;
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/repositories/{repositoryName}/projects/{projectName}")
    public Response deleteProject(@PathParam(value="repositoryName") String repositoryName, @PathParam(value="projectName") String projectName) {
        logger.debug("-----deleteProject--- , repositoryName: {}, project name: {}", (Object)repositoryName, (Object)projectName);
        this.checkRepositoryExistence(repositoryName);
        String id = "" + System.currentTimeMillis() + "-" + this.counter.incrementAndGet();
        DeleteProjectRequest jobRequest = new DeleteProjectRequest();
        jobRequest.setStatus(JobStatus.ACCEPTED);
        jobRequest.setJobId(id);
        jobRequest.setRepositoryName(repositoryName);
        jobRequest.setProjectName(projectName);
        this.addAcceptedJobResult(id);
        this.jobRequestObserver.deleteProjectRequest(jobRequest);
        return this.createAcceptedStatusResponse((JobRequest)jobRequest);
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="/repositories/{repositoryName}/projects/{projectName}/maven/compile")
    public Response compileProject(@PathParam(value="repositoryName") String repositoryName, @PathParam(value="projectName") String projectName) {
        logger.debug("-----compileProject--- , repositoryName: {}, project name: {}", (Object)repositoryName, (Object)projectName);
        this.checkRepositoryExistence(repositoryName);
        String id = "" + System.currentTimeMillis() + "-" + this.counter.incrementAndGet();
        CompileProjectRequest jobRequest = new CompileProjectRequest();
        jobRequest.setStatus(JobStatus.ACCEPTED);
        jobRequest.setJobId(id);
        jobRequest.setRepositoryName(repositoryName);
        jobRequest.setProjectName(projectName);
        this.addAcceptedJobResult(id);
        this.jobRequestObserver.compileProjectRequest(jobRequest);
        return this.createAcceptedStatusResponse((JobRequest)jobRequest);
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="/repositories/{repositoryName}/projects/{projectName}/maven/install")
    public Response installProject(@PathParam(value="repositoryName") String repositoryName, @PathParam(value="projectName") String projectName) {
        logger.debug("-----installProject--- , repositoryName: {}, project name: {}", (Object)repositoryName, (Object)projectName);
        this.checkRepositoryExistence(repositoryName);
        String id = "" + System.currentTimeMillis() + "-" + this.counter.incrementAndGet();
        InstallProjectRequest jobRequest = new InstallProjectRequest();
        jobRequest.setStatus(JobStatus.ACCEPTED);
        jobRequest.setJobId(id);
        jobRequest.setRepositoryName(repositoryName);
        jobRequest.setProjectName(projectName);
        this.addAcceptedJobResult(id);
        this.jobRequestObserver.installProjectRequest(jobRequest);
        return this.createAcceptedStatusResponse((JobRequest)jobRequest);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/repositories/{repositoryName}/projects/{projectName}/maven/test")
    public Response testProject(@PathParam(value="repositoryName") String repositoryName, @PathParam(value="projectName") String projectName, BuildConfig mavenConfig) {
        logger.debug("-----testProject--- , repositoryName: {}, project name: {}", (Object)repositoryName, (Object)projectName);
        this.checkRepositoryExistence(repositoryName);
        String id = "" + System.currentTimeMillis() + "-" + this.counter.incrementAndGet();
        TestProjectRequest jobRequest = new TestProjectRequest();
        jobRequest.setStatus(JobStatus.ACCEPTED);
        jobRequest.setJobId(id);
        jobRequest.setRepositoryName(repositoryName);
        jobRequest.setProjectName(projectName);
        jobRequest.setBuildConfig(mavenConfig);
        this.addAcceptedJobResult(id);
        this.jobRequestObserver.testProjectRequest(jobRequest);
        return this.createAcceptedStatusResponse((JobRequest)jobRequest);
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="/repositories/{repositoryName}/projects/{projectName}/maven/deploy")
    public Response deployProject(@PathParam(value="repositoryName") String repositoryName, @PathParam(value="projectName") String projectName) {
        logger.debug("-----deployProject--- , repositoryName: {}, project name: {}", (Object)repositoryName, (Object)projectName);
        this.checkRepositoryExistence(repositoryName);
        String id = "" + System.currentTimeMillis() + "-" + this.counter.incrementAndGet();
        DeployProjectRequest jobRequest = new DeployProjectRequest();
        jobRequest.setStatus(JobStatus.ACCEPTED);
        jobRequest.setJobId(id);
        jobRequest.setRepositoryName(repositoryName);
        jobRequest.setProjectName(projectName);
        this.addAcceptedJobResult(id);
        this.jobRequestObserver.deployProjectRequest(jobRequest);
        return this.createAcceptedStatusResponse((JobRequest)jobRequest);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/organizationalunits")
    public Collection<OrganizationalUnit> getOrganizationalUnits() {
        logger.debug("-----getOrganizationalUnits--- ");
        Collection origOrgUnits = this.organizationalUnitService.getOrganizationalUnits();
        ArrayList<OrganizationalUnit> organizationalUnits = new ArrayList<OrganizationalUnit>();
        for (org.guvnor.structure.organizationalunit.OrganizationalUnit ou : origOrgUnits) {
            OrganizationalUnit orgUnit = new OrganizationalUnit();
            orgUnit.setName(ou.getName());
            orgUnit.setOwner(ou.getOwner());
            ArrayList<String> repoNames = new ArrayList<String>();
            for (Repository r : ou.getRepositories()) {
                repoNames.add(r.getAlias());
            }
            orgUnit.setRepositories(repoNames);
            organizationalUnits.add(orgUnit);
        }
        return organizationalUnits;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/organizationalunits/{organizationalUnitName}")
    public OrganizationalUnit getOrganizationalUnit(@PathParam(value="organizationalUnitName") String organizationalUnitName) {
        logger.debug("-----getOrganizationalUnit ---, OrganizationalUnit name: {}", (Object)organizationalUnitName);
        org.guvnor.structure.organizationalunit.OrganizationalUnit origOrgUnit = this.checkOrganizationalUnitExistence(organizationalUnitName);
        OrganizationalUnit orgUnit = new OrganizationalUnit();
        orgUnit.setName(origOrgUnit.getName());
        orgUnit.setOwner(origOrgUnit.getOwner());
        ArrayList<String> repoNames = new ArrayList<String>();
        for (Repository r : origOrgUnit.getRepositories()) {
            repoNames.add(r.getAlias());
        }
        orgUnit.setRepositories(repoNames);
        return orgUnit;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/organizationalunits")
    public Response createOrganizationalUnit(OrganizationalUnit organizationalUnit) {
        logger.debug("-----createOrganizationalUnit--- , OrganizationalUnit name: {}, OrganizationalUnit owner: {}", (Object)organizationalUnit.getName(), (Object)organizationalUnit.getOwner());
        String id = "" + System.currentTimeMillis() + "-" + this.counter.incrementAndGet();
        CreateOrganizationalUnitRequest jobRequest = new CreateOrganizationalUnitRequest();
        jobRequest.setStatus(JobStatus.ACCEPTED);
        jobRequest.setJobId(id);
        jobRequest.setOrganizationalUnitName(organizationalUnit.getName());
        jobRequest.setOwner(organizationalUnit.getOwner());
        jobRequest.setRepositories(organizationalUnit.getRepositories());
        this.addAcceptedJobResult(id);
        this.jobRequestObserver.createOrganizationalUnitRequest(jobRequest);
        return this.createAcceptedStatusResponse((JobRequest)jobRequest);
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="/organizationalunits/{organizationalUnitName}/repositories/{repositoryName}")
    public Response addRepositoryToOrganizationalUnit(@PathParam(value="organizationalUnitName") String organizationalUnitName, @PathParam(value="repositoryName") String repositoryName) {
        logger.debug("-----addRepositoryToOrganizationalUnit--- , OrganizationalUnit name: {}, Repository name: {}", (Object)organizationalUnitName, (Object)repositoryName);
        this.checkOrganizationalUnitExistence(organizationalUnitName);
        this.checkRepositoryExistence(repositoryName);
        String id = "" + System.currentTimeMillis() + "-" + this.counter.incrementAndGet();
        AddRepositoryToOrganizationalUnitRequest jobRequest = new AddRepositoryToOrganizationalUnitRequest();
        jobRequest.setStatus(JobStatus.ACCEPTED);
        jobRequest.setJobId(id);
        jobRequest.setOrganizationalUnitName(organizationalUnitName);
        jobRequest.setRepositoryName(repositoryName);
        this.addAcceptedJobResult(id);
        this.jobRequestObserver.addRepositoryToOrganizationalUnitRequest(jobRequest);
        return this.createAcceptedStatusResponse((JobRequest)jobRequest);
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/organizationalunits/{organizationalUnitName}/repositories/{repositoryName}")
    public Response removeRepositoryFromOrganizationalUnit(@PathParam(value="organizationalUnitName") String organizationalUnitName, @PathParam(value="repositoryName") String repositoryName) {
        logger.debug("-----removeRepositoryFromOrganizationalUnit--- , OrganizationalUnit name: {}, Repository name: {}", (Object)organizationalUnitName, (Object)repositoryName);
        this.checkOrganizationalUnitExistence(organizationalUnitName);
        this.checkRepositoryExistence(repositoryName);
        String id = "" + System.currentTimeMillis() + "-" + this.counter.incrementAndGet();
        RemoveRepositoryFromOrganizationalUnitRequest jobRequest = new RemoveRepositoryFromOrganizationalUnitRequest();
        jobRequest.setStatus(JobStatus.ACCEPTED);
        jobRequest.setJobId(id);
        jobRequest.setOrganizationalUnitName(organizationalUnitName);
        jobRequest.setRepositoryName(repositoryName);
        this.addAcceptedJobResult(id);
        this.jobRequestObserver.removeRepositoryFromOrganizationalUnitRequest(jobRequest);
        return this.createAcceptedStatusResponse((JobRequest)jobRequest);
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/organizationalunits/{organizationalUnitName}")
    public Response deleteOrganizationalUnit(@PathParam(value="organizationalUnitName") String organizationalUnitName) {
        logger.debug("-----deleteOrganizationalUnit--- , OrganizationalUnit name: {}", (Object)organizationalUnitName);
        this.checkOrganizationalUnitExistence(organizationalUnitName);
        String id = "" + System.currentTimeMillis() + "-" + this.counter.incrementAndGet();
        RemoveOrganizationalUnitRequest jobRequest = new RemoveOrganizationalUnitRequest();
        jobRequest.setStatus(JobStatus.ACCEPTED);
        jobRequest.setJobId(id);
        jobRequest.setOrganizationalUnitName(organizationalUnitName);
        this.addAcceptedJobResult(id);
        this.jobRequestObserver.removeOrganizationalUnitRequest(jobRequest);
        return this.createAcceptedStatusResponse((JobRequest)jobRequest);
    }

    private Repository checkRepositoryExistence(String repoName) {
        Repository repo = this.repositoryService.getRepository(repoName);
        if (repo == null) {
            throw new IllegalStateException("Repository " + repoName + " does not exist.");
        }
        return repo;
    }

    private org.guvnor.structure.organizationalunit.OrganizationalUnit checkOrganizationalUnitExistence(String orgUnitName) {
        org.guvnor.structure.organizationalunit.OrganizationalUnit origOrgUnit = this.organizationalUnitService.getOrganizationalUnit(orgUnitName);
        if (origOrgUnit == null) {
            throw new IllegalStateException("Organizational unit " + orgUnitName + " does not exist.");
        }
        return origOrgUnit;
    }

    private Response createAcceptedStatusResponse(JobRequest jobRequest) {
        return Response.status((Response.Status)Response.Status.ACCEPTED).entity((Object)jobRequest).variant(defaultVariant).build();
    }
}

