/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.shared.metadata.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.errai.common.client.api.annotations.Portable;
import org.kie.commons.validation.PortablePreconditions;

@Portable
public class CategoryItem {
    private CategoryItem parent;
    private List<CategoryItem> children = new ArrayList<CategoryItem>();
    private String name;
    private String description;

    public CategoryItem() {
    }

    public CategoryItem(String name, String description, CategoryItem parent) {
        this.name = PortablePreconditions.checkNotEmpty((String)"name", (String)name);
        this.description = description;
        this.parent = parent;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public CategoryItem getParent() {
        return this.parent;
    }

    public List<CategoryItem> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public void removeChildren(String name) {
        for (int i = 0; i < this.children.size(); ++i) {
            CategoryItem child = this.children.get(i);
            if (!child.getName().equals(name)) continue;
            this.children.remove(i);
            break;
        }
    }

    public boolean hasChild() {
        return this.children.size() > 0;
    }

    public CategoryItem addChildren(String name, String description) {
        CategoryItem newCategory = new CategoryItem(name, description, this);
        this.children.add(newCategory);
        return newCategory;
    }

    public boolean contains(String name) {
        for (CategoryItem child : this.children) {
            if (!child.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getFullPath() {
        if (this.getName() == null) {
            return "";
        }
        if (this.getParent() == null) {
            return this.getName();
        }
        String parent = this.getParent().getFullPath();
        if (parent.equals("")) {
            return this.getName();
        }
        return parent + "/" + this.getName();
    }
}

