/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.shared.security;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Set;
import org.fest.assertions.api.Assertions;
import org.guvnor.common.services.shared.security.KieWorkbenchFeature;
import org.guvnor.common.services.shared.security.KieWorkbenchFeatureRegistry;
import org.guvnor.common.services.shared.security.KieWorkbenchPolicy;
import org.guvnor.common.services.shared.security.impl.KieWorkbenchACLImpl;
import org.junit.Before;
import org.junit.Test;

public class KieWorkbenchPolicyTest {
    private KieWorkbenchFeatureRegistry registry;
    private KieWorkbenchPolicy policy;
    private KieWorkbenchACLImpl acl;

    @Before
    public void setUp() throws Exception {
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream("workbench-policy.properties");
        String policyStr = KieWorkbenchPolicyTest.fromStream(is);
        this.policy = new KieWorkbenchPolicy(policyStr);
        this.registry = new KieWorkbenchFeatureRegistry();
        this.acl = new KieWorkbenchACLImpl();
        this.acl.setFeatureRegistry(this.registry);
        this.acl.activatePolicy(this.policy);
    }

    public static String fromStream(InputStream in) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        StringBuilder out = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            out.append(line).append("\n");
        }
        return out.toString();
    }

    @Test
    public void testImply() {
        KieWorkbenchFeature endUsers = this.registry.getFeature("wb_for_business_users");
        KieWorkbenchFeature admin = this.registry.getFeature("wb_administration");
        KieWorkbenchFeature tasks = this.registry.getFeature("wb_tasks");
        Assertions.assertThat((Object)endUsers).isNotNull();
        Assertions.assertThat((Object)admin).isNotNull();
        Assertions.assertThat((Object)tasks).isNotNull();
        Assertions.assertThat((boolean)endUsers.implies(tasks));
        Assertions.assertThat((!endUsers.implies(admin) ? 1 : 0) != 0);
    }

    @Test
    public void testGranted() {
        Set roles = this.acl.getGrantedRoles("wb_administration");
        Assertions.assertThat((Iterable)roles).contains((Object[])new String[]{"admin"});
        roles = this.acl.getGrantedRoles("wb_asset_repository");
        Assertions.assertThat((Iterable)roles).contains((Object[])new String[]{"admin", "developer"});
        roles = this.acl.getGrantedRoles("wb_jobs");
        Assertions.assertThat((Iterable)roles).contains((Object[])new String[]{"admin", "developer"});
        roles = this.acl.getGrantedRoles("wb_tasks");
        Assertions.assertThat((Iterable)roles).contains((Object[])new String[]{"admin", "analyst", "developer", "user"});
        roles = this.acl.getGrantedRoles("wb_dashboard_builder");
        Assertions.assertThat((Iterable)roles).contains((Object[])new String[]{"user", "manager"});
    }

    @Test
    public void testDeny() {
        Set roles = this.acl.getGrantedRoles("wb_administration");
        Assertions.assertThat((Iterable)roles).doesNotContain((Object[])new String[]{"developer", "analyst", "user", "manager"});
        roles = this.acl.getGrantedRoles("wb_jobs");
        Assertions.assertThat((Iterable)roles).doesNotContain((Object[])new String[]{"analyst"});
        roles = this.acl.getGrantedRoles("wb_deploy");
        Assertions.assertThat((Iterable)roles).doesNotContain((Object[])new String[]{"manager"});
    }
}

