/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.backend.metadata;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.guvnor.common.services.shared.metadata.model.DiscussionRecord;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.kie.commons.java.nio.base.version.VersionRecord;
import org.kie.commons.validation.Preconditions;
import org.uberfire.backend.vfs.Path;

public final class MetadataBuilder {
    private Path path;
    private String checkinComment;
    private String lastContributor;
    private String creator;
    private Date lastModified;
    private Date dateCreated;
    private String subject;
    private String type;
    private String externalRelation;
    private String externalSource;
    private String description;
    private List<String> categories = new ArrayList<String>();
    private List<DiscussionRecord> discussion = new ArrayList<DiscussionRecord>();
    private List<VersionRecord> version = new ArrayList<VersionRecord>();

    private MetadataBuilder() {
    }

    public static MetadataBuilder newMetadata() {
        return new MetadataBuilder();
    }

    public MetadataBuilder withPath(Path path) {
        this.path = (Path)Preconditions.checkNotNull((String)"path", (Object)path);
        return this;
    }

    public MetadataBuilder withCheckinComment(String checkinComment) {
        this.checkinComment = checkinComment;
        return this;
    }

    public MetadataBuilder withLastContributor(String lastContributor) {
        this.lastContributor = lastContributor;
        return this;
    }

    public MetadataBuilder withCreator(String creator) {
        this.creator = Preconditions.checkNotEmpty((String)"creator", (String)creator);
        return this;
    }

    public MetadataBuilder withLastModified(Date date) {
        this.lastModified = (Date)Preconditions.checkNotNull((String)"date", (Object)date);
        return this;
    }

    public MetadataBuilder withDateCreated(Date date) {
        this.dateCreated = (Date)Preconditions.checkNotNull((String)"date", (Object)date);
        return this;
    }

    public MetadataBuilder withSubject(String subject) {
        this.subject = subject;
        return this;
    }

    public MetadataBuilder withType(String type) {
        this.type = type;
        return this;
    }

    public MetadataBuilder withExternalRelation(String externalRelation) {
        this.externalRelation = externalRelation;
        return this;
    }

    public MetadataBuilder withExternalSource(String externalSource) {
        this.externalSource = externalSource;
        return this;
    }

    public MetadataBuilder withDescription(String description) {
        this.description = description;
        return this;
    }

    public MetadataBuilder withCategories(List<String> categories) {
        this.categories = categories;
        return this;
    }

    public MetadataBuilder withDiscussion(List<DiscussionRecord> discussion) {
        this.discussion = discussion;
        return this;
    }

    public MetadataBuilder withVersion(List<VersionRecord> version) {
        this.version = version;
        return this;
    }

    public Metadata build() {
        return new Metadata(this.path, this.checkinComment, this.lastContributor, this.creator, this.lastModified, this.dateCreated, this.subject, this.type, this.externalRelation, this.externalSource, this.description, this.categories, this.discussion, this.version);
    }
}

