/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.backend.metadata;

import com.thoughtworks.xstream.XStream;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.common.services.backend.exceptions.ExceptionUtilities;
import org.guvnor.common.services.shared.metadata.CategoriesService;
import org.guvnor.common.services.shared.metadata.model.Categories;
import org.guvnor.common.services.shared.metadata.model.CategoriesModelContent;
import org.jboss.errai.bus.server.annotations.Service;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;

@Service
@ApplicationScoped
public class CategoryServiceImpl
implements CategoriesService {
    private final XStream xt = new XStream();
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;

    public void save(org.uberfire.backend.vfs.Path path, Categories content) {
        this.saveWithServerSidePath(Paths.convert((org.uberfire.backend.vfs.Path)path), content);
    }

    private void saveWithServerSidePath(Path path, Categories content) {
        try {
            this.ioService.write(path, this.xt.toXML((Object)content), new OpenOption[0]);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public Categories getContent(org.uberfire.backend.vfs.Path path) {
        try {
            String content = this.ioService.readAllString(Paths.convert((org.uberfire.backend.vfs.Path)path));
            Categories categories = content.trim().equals("") ? new Categories() : (Categories)this.xt.fromXML(content);
            return categories;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public CategoriesModelContent getContentByRoot(org.uberfire.backend.vfs.Path pathToRoot) {
        CategoriesModelContent categoriesModelContent = new CategoriesModelContent();
        Path path = Paths.convert((org.uberfire.backend.vfs.Path)pathToRoot).resolve("categories.xml");
        if (!this.ioService.exists(path)) {
            this.saveWithServerSidePath(path, new Categories());
        }
        org.uberfire.backend.vfs.Path categoriesPath = Paths.convert((Path)path);
        categoriesModelContent.setPath(categoriesPath);
        categoriesModelContent.setCategories(this.getContent(categoriesPath));
        return categoriesModelContent;
    }

    public Categories getCategoriesFromResource(org.uberfire.backend.vfs.Path resource) {
        try {
            Path categoriesPath = Paths.convert((org.uberfire.backend.vfs.Path)resource).getRoot().resolve("categories.xml");
            return this.getContent(Paths.convert((Path)categoriesPath));
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }
}

