/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.backend.version;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.common.services.backend.config.SafeSessionInfo;
import org.guvnor.common.services.backend.exceptions.ExceptionUtilities;
import org.guvnor.common.services.shared.version.VersionService;
import org.guvnor.structure.repositories.impl.PortableVersionRecord;
import org.jboss.errai.bus.server.annotations.Service;
import org.jboss.errai.security.shared.api.identity.User;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.base.options.CommentedOption;
import org.uberfire.java.nio.base.version.VersionAttributeView;
import org.uberfire.java.nio.base.version.VersionRecord;
import org.uberfire.java.nio.file.CopyOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.StandardCopyOption;
import org.uberfire.rpc.SessionInfo;

@Service
@ApplicationScoped
public class VersionServiceImpl
implements VersionService {
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    @Inject
    private User identity;
    @Inject
    private SessionInfo sessionInfo;

    public List<VersionRecord> getVersions(org.uberfire.backend.vfs.Path path) {
        try {
            List records = ((VersionAttributeView)this.ioService.getFileAttributeView(Paths.convert((org.uberfire.backend.vfs.Path)path), VersionAttributeView.class)).readAttributes().history().records();
            ArrayList<VersionRecord> result = new ArrayList<VersionRecord>(records.size());
            for (VersionRecord record : records) {
                result.add((VersionRecord)new PortableVersionRecord(record.id(), record.author(), record.email(), record.comment(), record.date(), record.uri()));
            }
            return result;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public org.uberfire.backend.vfs.Path getPathToPreviousVersion(String uri) {
        URI uri1 = URI.create(uri);
        Path path = this.ioService.get(uri1);
        return Paths.convert((Path)path);
    }

    public org.uberfire.backend.vfs.Path restore(org.uberfire.backend.vfs.Path _path, String comment) {
        try {
            Path path = Paths.convert((org.uberfire.backend.vfs.Path)_path);
            Path target = path.getFileSystem().getPath(path.toString(), new String[0]);
            return Paths.convert((Path)this.ioService.copy(path, target, new CopyOption[]{StandardCopyOption.REPLACE_EXISTING, new CommentedOption(this.getSessionInfo().getId(), this.identity.getIdentifier(), null, comment)}));
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    protected SessionInfo getSessionInfo() {
        return new SafeSessionInfo(this.sessionInfo);
    }
}

