/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.backend.archive;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.guvnor.common.services.backend.archive.Archiver;

public class ArchiveServlet
extends HttpServlet {
    @Inject
    private Archiver archiver;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String uri = request.getParameter("attachmentPath");
        try {
            if (uri != null) {
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                this.archiver.archive(outputStream, uri);
                response.setContentType("application/zip");
                response.setHeader("Content-Disposition", "attachment; filename=download.zip");
                response.setContentLength(outputStream.size());
                response.getOutputStream().write(outputStream.toByteArray());
                response.getOutputStream().flush();
            } else {
                response.sendError(400);
            }
        }
        catch (URISyntaxException e) {
            response.sendError(400);
        }
    }
}

