/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.backend.file;

import javax.enterprise.event.Event;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.common.services.backend.config.SafeSessionInfo;
import org.guvnor.common.services.backend.exceptions.ExceptionUtilities;
import org.guvnor.common.services.backend.file.CopyHelper;
import org.guvnor.common.services.shared.file.CopyService;
import org.jboss.errai.bus.server.annotations.Service;
import org.jboss.errai.security.shared.api.identity.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.base.options.CommentedOption;
import org.uberfire.java.nio.file.CopyOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.workbench.events.ResourceCopiedEvent;

@Service
public class CopyServiceImpl
implements CopyService {
    private static final Logger LOGGER = LoggerFactory.getLogger(CopyServiceImpl.class);
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    @Inject
    private User identity;
    @Inject
    private SessionInfo sessionInfo;
    @Inject
    private Instance<CopyHelper> helpers;
    @Inject
    private Event<ResourceCopiedEvent> resourceCopiedEvent;

    public org.uberfire.backend.vfs.Path copy(org.uberfire.backend.vfs.Path path, String newName, String comment) {
        try {
            LOGGER.info("User:" + this.identity.getIdentifier() + " copying file [" + path.getFileName() + "] to [" + newName + "]");
            Path _path = Paths.convert((org.uberfire.backend.vfs.Path)path);
            String originalFileName = _path.getFileName().toString();
            String extension = originalFileName.substring(originalFileName.lastIndexOf("."));
            Path _target = _path.resolveSibling(newName + extension);
            org.uberfire.backend.vfs.Path targetPath = Paths.convert((Path)_target);
            try {
                this.ioService.startBatch(_target.getFileSystem());
                this.ioService.copy(Paths.convert((org.uberfire.backend.vfs.Path)path), Paths.convert((org.uberfire.backend.vfs.Path)targetPath), new CopyOption[]{new CommentedOption(this.getSessionInfo().getId(), this.identity.getIdentifier(), null, comment)});
                for (CopyHelper helper : this.helpers) {
                    if (!helper.supports(targetPath)) continue;
                    helper.postProcess(path, targetPath);
                }
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                this.ioService.endBatch();
            }
            this.resourceCopiedEvent.fire((Object)new ResourceCopiedEvent(path, targetPath, comment, this.getSessionInfo()));
            return targetPath;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    protected SessionInfo getSessionInfo() {
        return new SafeSessionInfo(this.sessionInfo);
    }
}

