/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.backend.metadata;

import java.util.ArrayList;
import java.util.List;
import org.guvnor.common.services.backend.metadata.MetadataServerSideService;
import org.guvnor.common.services.backend.metadata.MetadataServiceImpl;
import org.guvnor.common.services.backend.metadata.OtherMetaAttributesMock;
import org.guvnor.common.services.backend.metadata.attribute.OtherMetaView;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.fs.file.SimpleFileSystemProvider;

@RunWith(value=MockitoJUnitRunner.class)
public class MetadataServiceImplTest {
    private SimpleFileSystemProvider fileSystemProvider;
    @Mock
    private IOService ioService;
    @Mock
    private OtherMetaView otherMetaView;
    private Path path;
    private MetadataServerSideService service;

    @Before
    public void setUp() throws Exception {
        this.fileSystemProvider = new SimpleFileSystemProvider();
        this.fileSystemProvider.forceAsDefault();
        this.path = this.fileSystemProvider.getPath(this.getClass().getResource("myfile.file").toURI());
        this.service = new MetadataServiceImpl(this.ioService);
    }

    @Test
    public void testGetEmptyTagsNoOtherMetaView() {
        List tags = this.service.getTags(this.path);
        Assert.assertNotNull((Object)tags);
        Assert.assertEquals((long)0L, (long)tags.size());
    }

    @Test
    public void testGetEmptyTags() {
        Mockito.when((Object)this.otherMetaView.readAttributes()).thenReturn((Object)new OtherMetaAttributesMock());
        Mockito.when((Object)this.ioService.getFileAttributeView(this.path, OtherMetaView.class)).thenReturn((Object)this.otherMetaView);
        List tags = this.service.getTags(this.path);
        Assert.assertNotNull((Object)tags);
        Assert.assertEquals((long)0L, (long)tags.size());
    }

    @Test
    public void testGetTags() {
        Mockito.when((Object)this.otherMetaView.readAttributes()).thenReturn((Object)new OtherMetaAttributesMock(){
            List<String> tags = new ArrayList<String>(){
                {
                    this.add("tag1");
                }
            };

            public List<String> tags() {
                return this.tags;
            }
        });
        Mockito.when((Object)this.ioService.getFileAttributeView(this.path, OtherMetaView.class)).thenReturn((Object)this.otherMetaView);
        List tags = this.service.getTags(this.path);
        Assert.assertNotNull((Object)tags);
        Assert.assertEquals((long)1L, (long)tags.size());
    }
}

