/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.backend.social;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.ext.uberfire.social.activities.model.DefaultTypes;
import org.ext.uberfire.social.activities.model.PagedSocialQuery;
import org.ext.uberfire.social.activities.model.SocialActivitiesEvent;
import org.ext.uberfire.social.activities.model.SocialEventType;
import org.ext.uberfire.social.activities.model.SocialPaged;
import org.ext.uberfire.social.activities.model.SocialUser;
import org.ext.uberfire.social.activities.service.SocialAdapter;
import org.ext.uberfire.social.activities.service.SocialAdapterRepositoryAPI;
import org.ext.uberfire.social.activities.service.SocialCommandTypeFilter;
import org.ext.uberfire.social.activities.service.SocialTimeLineRepositoryAPI;
import org.ext.uberfire.social.activities.service.SocialTypeTimelinePagedRepositoryAPI;
import org.guvnor.common.services.backend.social.SocialTimelineRulesQuery;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class SocialTimelineRulesQueryTest {
    @Mock
    private SocialTimeLineRepositoryAPI socialTimeLineRepositoryAPI;
    @Mock
    private SocialTypeTimelinePagedRepositoryAPI socialTypeTimelinePagedRepositoryAPI;
    @Mock
    private SocialAdapterRepositoryAPI socialAdapterRepositoryAPI;
    @Mock
    private PagedSocialQuery pagedSocialQuery;
    private SocialTimelineRulesQuery query;

    @Before
    public void setup() {
        this.query = new SocialTimelineRulesQuery(this.socialTimeLineRepositoryAPI, this.socialTypeTimelinePagedRepositoryAPI, this.socialAdapterRepositoryAPI);
        Mockito.when((Object)this.socialTimeLineRepositoryAPI.getLastEventTimeline(Matchers.anyString(), Matchers.anyMap())).thenReturn(Collections.singletonList(this.makeMockEvent()));
        Mockito.when((Object)this.socialAdapterRepositoryAPI.getSocialAdapters()).thenReturn((Object)new HashMap<Class, SocialAdapter>(){
            {
                this.put(TestSocialEvent.class, new TestSocialAdaptor());
            }
        });
        Mockito.when((Object)this.socialTypeTimelinePagedRepositoryAPI.getEventTimeline(Matchers.anyString(), (SocialPaged)Mockito.any(SocialPaged.class), Matchers.anyMap())).thenReturn((Object)this.pagedSocialQuery);
        Mockito.when((Object)this.pagedSocialQuery.socialEvents()).thenReturn(Collections.singletonList(this.makeMockEvent()));
    }

    @Test
    public void checkKSessionInstantiation() {
        List events = this.query.executeAllRules();
        Assert.assertNotNull((Object)events);
    }

    private SocialActivitiesEvent makeMockEvent() {
        return new SocialActivitiesEvent().withAdicionalInfo(new String[]{"info"});
    }

    private static class TestSocialAdaptor
    implements SocialAdapter<TestSocialEvent> {
        private TestSocialAdaptor() {
        }

        public Class<TestSocialEvent> eventToIntercept() {
            return TestSocialEvent.class;
        }

        public SocialEventType socialEventType() {
            return DefaultTypes.DUMMY_EVENT;
        }

        public boolean shouldInterceptThisEvent(Object event) {
            return event.getClass().getSimpleName().equals(this.eventToIntercept().getSimpleName());
        }

        public SocialActivitiesEvent toSocial(Object object) {
            return new SocialActivitiesEvent(new SocialUser("user"), this.socialEventType().name(), new Date()).withDescription("test adaptor").withAdicionalInfo(new String[]{"info"});
        }

        public List<SocialCommandTypeFilter> getTimelineFilters() {
            return new ArrayList<SocialCommandTypeFilter>();
        }

        public List<String> getTimelineFiltersNames() {
            return new ArrayList<String>();
        }
    }

    private static class TestSocialEvent {
        private TestSocialEvent() {
        }
    }
}

