/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.client.editors.fileexplorer;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.Arrays;
import org.guvnor.structure.client.editors.fileexplorer.FileExplorerPresenter;
import org.guvnor.structure.client.editors.fileexplorer.FileExplorerViewImpl;
import org.guvnor.structure.client.resources.i18n.CommonConstants;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.backend.vfs.Path;
import org.uberfire.ext.widgets.core.client.tree.TreeItem;

@RunWith(value=GwtMockitoTestRunner.class)
public class FileExplorerViewImplTest {
    @Mock
    private FileExplorerPresenter presenter;
    private TreeItem item;
    private FileExplorerViewImpl view;

    @Before
    public void setUp() {
        this.view = new FileExplorerViewImpl();
        this.view.init(this.presenter);
    }

    @Test
    public void checkItemsAreNotLazyLoaded() {
        this.item = this.newTreeItem(new TreeItemData(TreeItem.Type.ITEM, "file", (Path)Mockito.mock(Path.class)), new TreeItemData[0]);
        Assert.assertFalse((boolean)this.view.needsLoading(this.item));
    }

    @Test
    public void checkFoldersWithNoChildrenAreNotLazyLoaded() {
        this.item = this.newTreeItem(new TreeItemData(TreeItem.Type.FOLDER, "folder", (Path)Mockito.mock(Path.class)), new TreeItemData[0]);
        Assert.assertFalse((boolean)this.view.needsLoading(this.item));
    }

    @Test
    public void checkFoldersWithExistingChildrenAreNotLazyLoaded() {
        this.item = this.newTreeItem(new TreeItemData(TreeItem.Type.FOLDER, "folder", (Path)Mockito.mock(Path.class)), new TreeItemData(TreeItem.Type.ITEM, "file1", (Path)Mockito.mock(Path.class)), new TreeItemData(TreeItem.Type.ITEM, "file2", (Path)Mockito.mock(Path.class)));
        Assert.assertFalse((boolean)this.view.needsLoading(this.item));
    }

    @Test
    public void checkFoldersWithLazyFlagAreLazyLoaded() {
        this.item = this.newTreeItem(new TreeItemData(TreeItem.Type.FOLDER, "folder", (Path)Mockito.mock(Path.class)), new TreeItemData(TreeItem.Type.ITEM, CommonConstants.INSTANCE.Loading(), (Path)Mockito.mock(Path.class)));
        Assert.assertTrue((boolean)this.view.needsLoading(this.item));
    }

    private TreeItem newTreeItem(TreeItemData parent, TreeItemData ... children) {
        final ArrayList cti = new ArrayList();
        TreeItem item = new TreeItem(parent.type, parent.value){

            public int getChildCount() {
                return cti.size();
            }

            public TreeItem getChild(int i) {
                return (TreeItem)cti.get(i);
            }

            public Iterable<TreeItem> getChildren() {
                return cti;
            }

            protected TreeItem makeChild(TreeItem.Type type, final String value) {
                return new TreeItem(type, value){

                    public String getText() {
                        return value;
                    }
                };
            }
        };
        item.setUserObject((Object)parent.path);
        Arrays.asList(children).stream().forEach(c -> {
            TreeItem ti = item.addItem(c.type, c.value);
            ti.setUserObject((Object)c.path);
            cti.add(ti);
        });
        return item;
    }

    private class TreeItemData {
        TreeItem.Type type;
        String value;
        Path path;

        TreeItemData(TreeItem.Type type, String value, Path path) {
            this.type = type;
            this.value = value;
            this.path = path;
        }
    }
}

