/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.client.editors.repository.edit;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.guvnor.structure.client.editors.repository.edit.RepositoryEditorPresenter;
import org.guvnor.structure.client.security.RepositoryController;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryInfo;
import org.guvnor.structure.repositories.RepositoryRemovedEvent;
import org.guvnor.structure.repositories.RepositoryService;
import org.guvnor.structure.repositories.RepositoryServiceEditor;
import org.jboss.errai.common.client.api.Caller;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.ext.widgets.core.client.resources.i18n.CoreConstants;
import org.uberfire.java.nio.base.version.VersionRecord;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.workbench.events.NotificationEvent;

@RunWith(value=GwtMockitoTestRunner.class)
public class RepositoryEditorPresenterTest {
    private RepositoryEditorPresenter presenter;
    @Mock
    private RepositoryEditorPresenter.View view;
    @Mock
    private RepositoryService repositoryService;
    @Mock
    private RepositoryServiceEditor repositoryServiceEditor;
    @Mock
    private EventSourceMock<NotificationEvent> notification;
    @Mock
    private PlaceManager placeManager;
    @Mock
    private RepositoryController repositoryController;
    @Mock
    private Path root;
    private RepositoryInfo repositoryInfo;
    private List<VersionRecord> repositoryHistory;
    private PlaceRequest place = new DefaultPlaceRequest();
    private Caller<RepositoryService> repositoryServiceCaller;
    private Caller<RepositoryServiceEditor> repositoryServiceEditorCaller;

    @Before
    public void before() {
        this.repositoryServiceCaller = new CallerMock((Object)this.repositoryService);
        this.repositoryServiceEditorCaller = new CallerMock((Object)this.repositoryServiceEditor);
        this.presenter = new RepositoryEditorPresenter(this.view, this.repositoryServiceCaller, this.repositoryServiceEditorCaller, this.notification, this.placeManager, this.repositoryController);
        this.repositoryInfo = new RepositoryInfo("repository", "repository", "owner", this.root, new ArrayList(), new ArrayList());
        this.repositoryHistory = Collections.EMPTY_LIST;
        Mockito.when((Object)this.repositoryService.getRepositoryInfo((String)Mockito.any(String.class))).thenReturn((Object)this.repositoryInfo);
        Mockito.when((Object)this.repositoryService.getRepositoryHistory((String)Mockito.any(String.class), ((Integer)Mockito.any(Integer.class)).intValue())).thenReturn(this.repositoryHistory);
        Mockito.when((Object)this.repositoryServiceEditor.revertHistory((String)Mockito.any(String.class), (Path)Mockito.eq((Object)this.root), (String)Mockito.any(String.class), (VersionRecord)Mockito.any(VersionRecord.class))).thenReturn(this.repositoryHistory);
        this.place.addParameter("alias", "repository");
        this.presenter.onStartup(this.place);
    }

    @Test
    public void testOnStartup() {
        ((RepositoryService)Mockito.verify((Object)this.repositoryService, (VerificationMode)Mockito.times((int)1))).getRepositoryInfo((String)Mockito.eq((Object)"repository"));
        ((RepositoryEditorPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setRepositoryInfo((String)Mockito.eq((Object)this.repositoryInfo.getAlias()), (String)Mockito.eq((Object)this.repositoryInfo.getOwner()), Mockito.eq((boolean)true), (List)Mockito.eq((Object)this.repositoryInfo.getPublicURIs()), (String)Mockito.eq((Object)CoreConstants.INSTANCE.Empty()), (List)Mockito.eq((Object)this.repositoryInfo.getInitialVersionList()));
    }

    @Test
    public void testLoadMoreHistory() {
        this.presenter.onLoadMoreHistory(0);
        ((RepositoryService)Mockito.verify((Object)this.repositoryService, (VerificationMode)Mockito.times((int)1))).getRepositoryHistory((String)Mockito.eq((Object)"repository"), Mockito.eq((int)0));
        ((RepositoryEditorPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).addHistory((List)Mockito.eq(this.repositoryHistory));
    }

    @Test
    public void testRevertNoCommitMessage() {
        VersionRecord vr = (VersionRecord)Mockito.mock(VersionRecord.class);
        this.presenter.onRevert(vr);
        ((RepositoryServiceEditor)Mockito.verify((Object)this.repositoryServiceEditor, (VerificationMode)Mockito.times((int)1))).revertHistory((String)Mockito.eq((Object)"repository"), (Path)Mockito.eq((Object)this.root), (String)Mockito.isNull(String.class), (VersionRecord)Mockito.eq((Object)vr));
        ((RepositoryEditorPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).reloadHistory((List)Mockito.eq(this.repositoryHistory));
    }

    @Test
    public void testRevertWithCommitMessage() {
        VersionRecord vr = (VersionRecord)Mockito.mock(VersionRecord.class);
        this.presenter.onRevert(vr, "comment");
        ((RepositoryServiceEditor)Mockito.verify((Object)this.repositoryServiceEditor, (VerificationMode)Mockito.times((int)1))).revertHistory((String)Mockito.eq((Object)"repository"), (Path)Mockito.eq((Object)this.root), (String)Mockito.eq((Object)"comment"), (VersionRecord)Mockito.eq((Object)vr));
        ((RepositoryEditorPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).reloadHistory((List)Mockito.eq(this.repositoryHistory));
    }

    @Test
    public void testRepositoryRemovedEvent() {
        RepositoryRemovedEvent event = (RepositoryRemovedEvent)Mockito.mock(RepositoryRemovedEvent.class);
        Repository repository = (Repository)Mockito.mock(Repository.class);
        Mockito.when((Object)repository.getAlias()).thenReturn((Object)"repository");
        Mockito.when((Object)event.getRepository()).thenReturn((Object)repository);
        this.presenter.onRepositoryRemovedEvent(event);
        ((PlaceManager)Mockito.verify((Object)this.placeManager, (VerificationMode)Mockito.times((int)1))).closePlace((PlaceRequest)Mockito.eq((Object)this.place));
    }

    @Test
    public void testNotificationFiredWhenGitUriCopied() {
        this.presenter.onGitUrlCopied("uri");
        ((EventSourceMock)Mockito.verify(this.notification, (VerificationMode)Mockito.times((int)1))).fire(Mockito.any(NotificationEvent.class));
    }
}

