/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.client.editors.repository.list;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.Collection;
import org.guvnor.structure.client.editors.context.GuvnorStructureContext;
import org.guvnor.structure.client.editors.context.GuvnorStructureContextChangeHandler;
import org.guvnor.structure.client.editors.repository.list.RepositoriesPresenter;
import org.guvnor.structure.client.editors.repository.list.RepositoriesView;
import org.guvnor.structure.client.editors.repository.list.RepositoryItemPresenter;
import org.guvnor.structure.client.editors.repository.list.RepositoryItemView;
import org.guvnor.structure.client.security.RepositoryController;
import org.guvnor.structure.repositories.NewBranchEvent;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryService;
import org.guvnor.structure.repositories.impl.git.GitRepository;
import org.jboss.errai.common.client.api.Caller;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.Path;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.workbench.events.NotificationEvent;

@RunWith(value=GwtMockitoTestRunner.class)
public class RepositoriesPresenterTest {
    private RepositoriesPresenter presenter;
    @Mock
    private RepositoriesView view;
    @Mock
    private RepositoryService repositoryService;
    @Mock
    private RepositoryController repositoryController;
    @Mock
    private EventSourceMock<NotificationEvent> notification;
    private GuvnorStructureContext guvnorStructureContext;
    private Collection<Repository> repositories;
    @Mock
    private Path branchPath;
    private Repository r1 = this.createRepository("r1");
    private Repository r2 = this.createRepository("r2");
    private Repository r3 = this.createRepository("r3");
    private Repository r4 = this.createRepository("r4");
    @Mock
    private RepositoryItemView itemView1;
    @Mock
    private RepositoryItemView itemView2;
    @Mock
    private RepositoryItemView itemView3;
    @Mock
    private RepositoryItemView itemView4;
    private RepositoryItemPresenter itemPresenter1;
    private RepositoryItemPresenter itemPresenter2;
    private RepositoryItemPresenter itemPresenter3;
    private RepositoryItemPresenter itemPresenter4;
    private GuvnorStructureContextChangeHandler changeHandler;
    private GuvnorStructureContextChangeHandler.HandlerRegistration changeHandlerRegistration;
    private GuvnorStructureContextChangeHandler.HandlerRegistration removedChangeHandlerRegistration;

    @Before
    public void init() {
        this.repositories = new ArrayList<Repository>();
        this.repositories.add(this.r1);
        this.repositories.add(this.r2);
        this.repositories.add(this.r3);
        Mockito.when((Object)this.repositoryController.canReadRepository((Repository)Mockito.any())).thenReturn((Object)true);
        this.guvnorStructureContext = new GuvnorStructureContext((Caller)new CallerMock((Object)this.repositoryService)){

            public GuvnorStructureContextChangeHandler.HandlerRegistration addGuvnorStructureContextChangeHandler(GuvnorStructureContextChangeHandler handler) {
                RepositoriesPresenterTest.this.changeHandler = handler;
                RepositoriesPresenterTest.this.changeHandlerRegistration = super.addGuvnorStructureContextChangeHandler(handler);
                return RepositoriesPresenterTest.this.changeHandlerRegistration;
            }

            public void removeHandler(GuvnorStructureContextChangeHandler.HandlerRegistration handlerRegistration) {
                RepositoriesPresenterTest.this.removedChangeHandlerRegistration = handlerRegistration;
                super.removeHandler(handlerRegistration);
            }
        };
        this.itemPresenter1 = this.createItemPresenter(this.itemView1, this.guvnorStructureContext, this.r1, "master");
        this.itemPresenter2 = this.createItemPresenter(this.itemView2, this.guvnorStructureContext, this.r2, "master");
        this.itemPresenter3 = this.createItemPresenter(this.itemView3, this.guvnorStructureContext, this.r3, "master");
        this.itemPresenter4 = this.createItemPresenter(this.itemView4, this.guvnorStructureContext, this.r4, "master");
        this.presenter = new RepositoriesPresenter(this.view, this.guvnorStructureContext, (Caller)new CallerMock((Object)this.repositoryService), this.repositoryController);
        Mockito.when((Object)this.repositoryService.getRepositories()).thenReturn(this.repositories);
        Mockito.when((Object)this.view.addRepository(this.r1, this.r1.getDefaultBranch())).thenReturn((Object)this.itemPresenter1);
        Mockito.when((Object)this.view.addRepository(this.r2, this.r2.getDefaultBranch())).thenReturn((Object)this.itemPresenter2);
        Mockito.when((Object)this.view.addRepository(this.r3, this.r3.getDefaultBranch())).thenReturn((Object)this.itemPresenter3);
        Mockito.when((Object)this.view.addRepository(this.r4, this.r4.getDefaultBranch())).thenReturn((Object)this.itemPresenter4);
        ((RepositoriesView)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocationOnMock) throws Throwable {
                throw new RuntimeException("Should remove a valid repository item.");
            }
        }).when((Object)this.view)).removeIfExists((RepositoryItemPresenter)Mockito.eq((Object)null));
    }

    @Test
    public void testSetHandlers() throws Exception {
        Assert.assertTrue((this.changeHandler == this.presenter ? 1 : 0) != 0);
    }

    @Test
    public void testRemoveHandlers() throws Exception {
        Assert.assertTrue((this.removedChangeHandlerRegistration == null ? 1 : 0) != 0);
        this.presenter.shutdown();
        Assert.assertTrue((this.changeHandlerRegistration == this.removedChangeHandlerRegistration ? 1 : 0) != 0);
    }

    @Test
    public void removeIfExistsTest() {
        Mockito.when((Object)this.view.confirmDeleteRepository(this.r1)).thenReturn((Object)true);
        Mockito.when((Object)this.view.confirmDeleteRepository(this.r3)).thenReturn((Object)false);
        this.presenter.onStartup();
        this.presenter.removeRepository(this.r1);
        this.presenter.removeRepository(this.r3);
        ((RepositoryService)Mockito.verify((Object)this.repositoryService)).removeRepository("r1");
        ((RepositoryService)Mockito.verify((Object)this.repositoryService, (VerificationMode)Mockito.never())).removeRepository("r2");
        ((RepositoryService)Mockito.verify((Object)this.repositoryService, (VerificationMode)Mockito.never())).removeRepository("r3");
    }

    @Test
    public void addAndRemoveTest() {
        Mockito.when((Object)this.view.confirmDeleteRepository(this.r4)).thenReturn((Object)true);
        this.presenter.onStartup();
        this.presenter.onNewRepositoryAdded(this.r4);
        this.presenter.removeRepository(this.r4);
        this.presenter.onRepositoryDeleted(this.r4);
        ((RepositoryService)Mockito.verify((Object)this.repositoryService)).removeRepository("r4");
    }

    @Test
    public void testNewBranchTest() {
        this.presenter.onStartup();
        Mockito.when((Object)this.itemView1.getSelectedBranch()).thenReturn((Object)"master");
        this.guvnorStructureContext.onNewBranch(new NewBranchEvent("r1", "theNewBranch", this.branchPath, Long.valueOf(System.currentTimeMillis())));
        ((RepositoryItemView)Mockito.verify((Object)this.itemView1, (VerificationMode)Mockito.times((int)2))).addBranch("master");
        ((RepositoryItemView)Mockito.verify((Object)this.itemView1)).addBranch("theNewBranch");
        ((RepositoryItemView)Mockito.verify((Object)this.itemView1, (VerificationMode)Mockito.times((int)2))).setSelectedBranch("master");
        Assert.assertTrue((boolean)this.r1.getBranches().contains("theNewBranch"));
    }

    private RepositoryItemPresenter createItemPresenter(RepositoryItemView itemView, GuvnorStructureContext guvnorStructureContext, Repository repository, String branch) {
        RepositoryItemPresenter itemPresenter = new RepositoryItemPresenter(itemView, guvnorStructureContext, this.repositoryController, this.notification);
        itemPresenter.setRepository(repository, branch);
        return itemPresenter;
    }

    private Repository createRepository(String alias) {
        GitRepository repository = new GitRepository(alias);
        repository.addBranch("master", this.branchPath);
        return repository;
    }
}

