/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.test;

import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import org.guvnor.test.TempFiles;
import org.jboss.weld.environment.se.StartMain;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.fs.file.SimpleFileSystemProvider;

public class TestFileSystem {
    private final SimpleFileSystemProvider fileSystemProvider;
    private final Paths paths;
    private final TempFiles tempFiles;
    private final HashMap<org.uberfire.backend.vfs.Path, File> pathToFile = new HashMap();

    public TestFileSystem() {
        this.tempFiles = new TempFiles();
        this.fileSystemProvider = new SimpleFileSystemProvider();
        StartMain startMain = new StartMain(new String[0]);
        BeanManager beanManager = startMain.go().getBeanManager();
        Bean pathsBean = (Bean)beanManager.getBeans(Paths.class, new Annotation[0]).iterator().next();
        CreationalContext cc = beanManager.createCreationalContext((Contextual)pathsBean);
        this.paths = (Paths)beanManager.getReference(pathsBean, Paths.class, cc);
        this.fileSystemProvider.forceAsDefault();
    }

    public org.uberfire.backend.vfs.Path createTempFile(String fullFileName) throws IOException {
        File file = this.tempFiles.createTempFile(fullFileName);
        org.uberfire.backend.vfs.Path path = Paths.convert((Path)this.fileSystemProvider.getPath(file.toURI()));
        this.pathToFile.put(path, file);
        return path;
    }

    public void deleteFile(org.uberfire.backend.vfs.Path path) {
        this.getFile(path).delete();
    }

    public File getFile(org.uberfire.backend.vfs.Path path) {
        return this.pathToFile.get(path);
    }

    public void tearDown() {
        this.tempFiles.deleteFiles();
    }
}

