/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.test;

import javax.annotation.PostConstruct;
import javax.enterprise.inject.Alternative;
import javax.enterprise.inject.Produces;
import javax.inject.Singleton;
import org.jboss.errai.security.shared.api.identity.User;
import org.jboss.errai.security.shared.api.identity.UserImpl;
import org.jboss.errai.security.shared.service.AuthenticationService;

@Singleton
@Alternative
public class TestIdentityFactory {
    private User identity;

    @PostConstruct
    public void onStartup() {
        this.identity = new UserImpl("testUser");
    }

    @Produces
    @Alternative
    public User getIdentity() {
        return this.identity;
    }

    @Produces
    @Alternative
    public AuthenticationService authenticationService() {
        return new AuthenticationService(){
            boolean isLoggedIn = false;
            User user;

            public User login(String username, String password) {
                this.isLoggedIn = true;
                this.user = new UserImpl(username);
                return this.user;
            }

            public boolean isLoggedIn() {
                return false;
            }

            public void logout() {
                this.user = null;
                this.isLoggedIn = false;
            }

            public User getUser() {
                return this.user;
            }
        };
    }
}

