/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.server;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.organizationalunit.OrganizationalUnitService;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryService;
import org.guvnor.structure.server.config.ConfigGroup;
import org.guvnor.structure.server.config.ConfigType;
import org.guvnor.structure.server.config.ConfigurationFactory;
import org.guvnor.structure.server.config.ConfigurationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.commons.services.cdi.Startup;
import org.uberfire.commons.services.cdi.StartupType;

@Startup(value=StartupType.BOOTSTRAP)
@ApplicationScoped
public class AppSetup {
    private static final Logger logger = LoggerFactory.getLogger(AppSetup.class);
    private static final String DROOLS_WB_ORGANIZATIONAL_UNIT1 = "demo";
    private static final String DROOLS_WB_ORGANIZATIONAL_UNIT1_OWNER = "demo@drools.org";
    private static final String DROOLS_WB_PLAYGROUND_SCHEME = "git";
    private static final String DROOLS_WB_PLAYGROUND_ALIAS = "uf-playground";
    private static final String DROOLS_WB_PLAYGROUND_ORIGIN = "https://github.com/guvnorngtestuser1/guvnorng-playground.git";
    private static final String DROOLS_WB_PLAYGROUND_UID = "guvnorngtestuser1";
    private static final String DROOLS_WB_PLAYGROUND_PWD = "test1234";
    private static final String GLOBAL_SETTINGS = "settings";
    @Inject
    private RepositoryService repositoryService;
    @Inject
    private OrganizationalUnitService organizationalUnitService;
    @Inject
    private ConfigurationService configurationService;
    @Inject
    private ConfigurationFactory configurationFactory;

    @PostConstruct
    public void assertPlayground() {
        if ("true".equalsIgnoreCase(System.getProperty("org.kie.demo"))) {
            try {
                Repository repository = this.createRepository(DROOLS_WB_PLAYGROUND_ALIAS, DROOLS_WB_PLAYGROUND_SCHEME, DROOLS_WB_PLAYGROUND_ORIGIN, DROOLS_WB_PLAYGROUND_UID, DROOLS_WB_PLAYGROUND_PWD);
                this.createOU(repository, DROOLS_WB_ORGANIZATIONAL_UNIT1, DROOLS_WB_ORGANIZATIONAL_UNIT1_OWNER);
            }
            catch (Exception e) {
                logger.error("Failed to setup Repository 'uf-playground'", (Throwable)e);
            }
        }
        this.defineGlobalProperties();
    }

    private Repository createRepository(String alias, String scheme, String origin, String user, String password) {
        Repository repository = this.repositoryService.getRepository(alias);
        if (repository == null) {
            repository = this.repositoryService.createRepository(scheme, alias, (Map)new /* Unavailable Anonymous Inner Class!! */);
        }
        return repository;
    }

    private OrganizationalUnit createOU(Repository repository, String ouName, String ouOwner) {
        OrganizationalUnit ou = this.organizationalUnitService.getOrganizationalUnit(ouName);
        if (ou == null) {
            ArrayList<Repository> repositories = new ArrayList<Repository>();
            repositories.add(repository);
            this.organizationalUnitService.createOrganizationalUnit(ouName, ouOwner, null, repositories);
        }
        return ou;
    }

    private void defineGlobalProperties() {
        List globalConfigGroups = this.configurationService.getConfiguration(ConfigType.GLOBAL);
        boolean globalSettingsDefined = false;
        for (ConfigGroup globalConfigGroup : globalConfigGroups) {
            if (!GLOBAL_SETTINGS.equals(globalConfigGroup.getName())) continue;
            globalSettingsDefined = true;
            break;
        }
        if (!globalSettingsDefined) {
            this.configurationService.addConfiguration(this.getGlobalConfiguration());
        }
    }

    private ConfigGroup getGlobalConfiguration() {
        ConfigGroup group = this.configurationFactory.newConfigGroup(ConfigType.GLOBAL, GLOBAL_SETTINGS, "");
        group.addConfigItem(this.configurationFactory.newConfigItem("drools.dateformat", "dd-MMM-yyyy"));
        group.addConfigItem(this.configurationFactory.newConfigItem("drools.datetimeformat", "dd-MMM-yyyy hh:mm:ss"));
        group.addConfigItem(this.configurationFactory.newConfigItem("drools.defaultlanguage", "en"));
        group.addConfigItem(this.configurationFactory.newConfigItem("drools.defaultcountry", "US"));
        group.addConfigItem(this.configurationFactory.newConfigItem("build.enable-incremental", "true"));
        group.addConfigItem(this.configurationFactory.newConfigItem("rule-modeller-onlyShowDSLStatements", "false"));
        return group;
    }
}

