/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.server;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.guvnor.common.services.backend.exceptions.ExceptionUtilities;
import org.guvnor.common.services.project.backend.server.AbstractProjectService;
import org.guvnor.common.services.project.backend.server.ProjectConfigurationContentHandler;
import org.guvnor.common.services.project.backend.server.utils.IdentifierUtils;
import org.guvnor.common.services.project.builder.events.InvalidateDMOProjectCacheEvent;
import org.guvnor.common.services.project.events.DeleteProjectEvent;
import org.guvnor.common.services.project.events.NewPackageEvent;
import org.guvnor.common.services.project.events.NewProjectEvent;
import org.guvnor.common.services.project.events.RenameProjectEvent;
import org.guvnor.common.services.project.model.POM;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.common.services.project.service.POMService;
import org.guvnor.common.services.project.service.ProjectService;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.server.config.ConfigurationFactory;
import org.guvnor.structure.server.config.ConfigurationService;
import org.jboss.errai.bus.server.annotations.Service;
import org.jboss.errai.security.shared.api.identity.User;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.Option;
import org.uberfire.java.nio.file.Path;
import org.uberfire.rpc.SessionInfo;

@Service
@ApplicationScoped
public class ProjectServiceImpl
extends AbstractProjectService<Project>
implements ProjectService<Project> {
    public ProjectServiceImpl() {
    }

    @Inject
    public ProjectServiceImpl(@Named(value="ioStrategy") IOService ioService, POMService pomService, ProjectConfigurationContentHandler projectConfigurationContentHandler, ConfigurationService configurationService, ConfigurationFactory configurationFactory, Event<NewProjectEvent> newProjectEvent, Event<NewPackageEvent> newPackageEvent, Event<RenameProjectEvent> renameProjectEvent, Event<DeleteProjectEvent> deleteProjectEvent, Event<InvalidateDMOProjectCacheEvent> invalidateDMOCache, User identity, SessionInfo sessionInfo) {
        super(ioService, pomService, projectConfigurationContentHandler, configurationService, configurationFactory, newProjectEvent, newPackageEvent, renameProjectEvent, deleteProjectEvent, invalidateDMOCache, identity, sessionInfo);
    }

    public Project resolveProject(org.uberfire.backend.vfs.Path resource) {
        try {
            if (resource == null) {
                return null;
            }
            Path path = Paths.convert((org.uberfire.backend.vfs.Path)resource).normalize();
            if (Files.isRegularFile((Path)path, (LinkOption[])new LinkOption[0])) {
                path = path.getParent();
            }
            if (this.hasPom(path)) {
                return this.makeProject(path);
            }
            while (path.getNameCount() > 0 && !path.getFileName().toString().equals("src")) {
                path = path.getParent();
            }
            if (path.getNameCount() == 0) {
                return null;
            }
            if ((path = path.getParent()).getNameCount() == 0 || path == null) {
                return null;
            }
            if (!this.hasPom(path)) {
                return null;
            }
            return this.makeProject(path);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public Project newProject(Repository repository, POM pom, String baseUrl) {
        FileSystem fs = Paths.convert((org.uberfire.backend.vfs.Path)repository.getRoot()).getFileSystem();
        try {
            org.uberfire.backend.vfs.Path fsRoot = repository.getRoot();
            org.uberfire.backend.vfs.Path projectRootPath = Paths.convert((Path)Paths.convert((org.uberfire.backend.vfs.Path)fsRoot).resolve(pom.getName()));
            this.ioService.startBatch(new FileSystem[]{fs}, new Option[]{this.makeCommentedOption("New project [" + pom.getName() + "]")});
            this.pomService.create(projectRootPath, baseUrl, pom);
            Project project = this.resolveProject(projectRootPath);
            this.newProjectEvent.fire((Object)new NewProjectEvent(project, this.getSessionId(), this.getIdentityName()));
            Object[] legalJavaGroupId = IdentifierUtils.convertMavenIdentifierToJavaIdentifier((String[])pom.getGav().getGroupId().split("\\.", -1));
            Object[] legalJavaArtifactId = IdentifierUtils.convertMavenIdentifierToJavaIdentifier((String[])pom.getGav().getArtifactId().split("\\.", -1));
            String defaultWorkspacePath = StringUtils.join((Object[])legalJavaGroupId, (String)"/") + "/" + StringUtils.join((Object[])legalJavaArtifactId, (String)"/");
            org.uberfire.backend.vfs.Path defaultPackagePath = Paths.convert((Path)Paths.convert((org.uberfire.backend.vfs.Path)projectRootPath).resolve("src/main/resources"));
            Package defaultPackage = this.resolvePackage(defaultPackagePath);
            Package defaultWorkspacePackage = this.doNewPackage(defaultPackage, defaultWorkspacePath, false);
            this.newPackageEvent.fire((Object)new NewPackageEvent(defaultWorkspacePackage));
            Project project2 = project;
            return project2;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
        finally {
            this.ioService.endBatch();
        }
    }

    public Project simpleProjectInstance(Path nioProjectRootPath) {
        org.uberfire.backend.vfs.Path projectRootPath = Paths.convert((Path)nioProjectRootPath);
        return new Project(projectRootPath, Paths.convert((Path)nioProjectRootPath.resolve("pom.xml")), projectRootPath.getFileName());
    }

    public Project resolveParentProject(org.uberfire.backend.vfs.Path resource) {
        return null;
    }

    public Project resolveToParentProject(org.uberfire.backend.vfs.Path resource) {
        return null;
    }
}

