/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.commandcli;

import java.io.BufferedInputStream;
import java.io.Console;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import okhttp3.Credentials;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.ws.WebSocket;
import okhttp3.ws.WebSocketCall;
import okhttp3.ws.WebSocketListener;
import okio.Buffer;
import okio.BufferedSink;
import org.hawkular.bus.common.BasicMessageWithExtraData;
import org.hawkular.bus.common.BinaryData;
import org.hawkular.cmdgw.api.ApiDeserializer;
import org.jboss.aesh.cl.CommandLine;
import org.jboss.aesh.cl.internal.OptionType;
import org.jboss.aesh.cl.internal.ProcessedCommand;
import org.jboss.aesh.cl.internal.ProcessedCommandBuilder;
import org.jboss.aesh.cl.internal.ProcessedOptionBuilder;
import org.jboss.aesh.cl.parser.CommandLineParser;
import org.jboss.aesh.cl.parser.CommandLineParserBuilder;
import org.jboss.aesh.cl.parser.CommandLineParserException;
import org.jboss.aesh.console.command.Command;

public class CommandCli {
    private static final org.jboss.logging.Logger log;
    private static final String COMMAND_NAME = "hawkular-command";
    private static final String OPT_OUTPUT_DIR = "output-dir";
    private static final String OPT_SERVER_WEB_SOCKET_URL = "server-url";
    private static final String OPT_USERNAME = "username";
    private static final String OPT_PASSWORD = "password";
    private static final String OPT_COMMAND = "command";
    private static final String OPT_EXPECTED_RESPONSE = "expected-response";
    private static final String OPT_REQUEST_FILE = "request-file";
    private static final String OPT_BINARY_DATA_FILE = "binary-data-file";
    private static final char OPT_PROPERTY = 'P';
    private static final char OPT_MAP = 'M';

    public static void main(String[] args) throws Exception {
        ProcessedCommand<?> options = CommandCli.buildCommandLineOptions();
        try {
            Config config = CommandCli.parseCommandLine(options, args);
            CliWebSocketListener listener = CommandCli.sendCommand(config);
            if (config.willRespond()) {
                listener.waitForResponse();
            } else {
                while (listener.httpClient.dispatcher().runningCallsCount() == 0) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
                listener.shutdown(null);
            }
        }
        catch (CommandLineParserException pe) {
            log.errorf((Throwable)pe, "Failed to parse command line.", new Object[0]);
            CommandCli.printHelp(options);
        }
        catch (Exception ex) {
            log.errorf((Throwable)ex, "Unexpected error", new Object[0]);
        }
    }

    private static CliWebSocketListener sendCommand(Config config) throws Exception {
        OkHttpClient httpClient = new OkHttpClient.Builder().connectTimeout(10L, TimeUnit.SECONDS).readTimeout(5L, TimeUnit.MINUTES).build();
        Request request = new Request.Builder().url(config.serverUrl).addHeader("Authorization", Credentials.basic(config.username, config.password)).addHeader("Accept", "application/json").build();
        WebSocketCall wsc = WebSocketCall.create(httpClient, request);
        CliWebSocketListener listener = new CliWebSocketListener(httpClient, wsc, config);
        return listener;
    }

    private static Config parseCommandLine(ProcessedCommand<?> options, String[] args) throws Exception {
        StringBuilder argLine = new StringBuilder(COMMAND_NAME);
        for (String str : args) {
            argLine.append(' ').append('\'').append(str).append('\'');
        }
        log.debugf("Command line: %s", (Object)argLine);
        CommandLineParser parser = new CommandLineParserBuilder().processedCommand(options).create();
        CommandLine<Command> commandLine = parser.parse(argLine.toString());
        if (commandLine.getParserException() != null) {
            throw commandLine.getParserException();
        }
        File outputDir = new File(commandLine.getOptionValue(OPT_OUTPUT_DIR, "."));
        String urlStr = commandLine.getOptionValue(OPT_SERVER_WEB_SOCKET_URL, "ws://127.0.0.1:8080/hawkular/command-gateway/ui/ws");
        String username = commandLine.getOptionValue(OPT_USERNAME);
        String password = commandLine.getOptionValue(OPT_PASSWORD);
        String command = commandLine.getOptionValue(OPT_COMMAND);
        String expectedResponse = commandLine.getOptionValue(OPT_EXPECTED_RESPONSE);
        String jsonRequestFileStr = commandLine.getOptionValue(OPT_REQUEST_FILE);
        String binaryDataFileStr = commandLine.getOptionValue(OPT_BINARY_DATA_FILE);
        Map<String, String> jsonProperties = commandLine.getOptionProperties(String.valueOf('P'));
        Map<String, String> jsonMaps = commandLine.getOptionProperties(String.valueOf('M'));
        if (!Pattern.matches(".*[^/]/[^/].*", urlStr)) {
            log.debugf("URL [%s] did not specify a path - using '/hawkular/command-gateway/ui/ws'", (Object)urlStr);
            urlStr = urlStr + (urlStr.endsWith("/") ? "" : "/") + "hawkular/command-gateway/ui/ws";
        }
        if ((password == null || password.isEmpty()) && ((password = CommandCli.readSecretFromStdin("Password:")) == null || password.isEmpty())) {
            throw new Exception("Password was not provided");
        }
        if (!outputDir.isDirectory()) {
            outputDir.mkdirs();
            if (!outputDir.isDirectory()) {
                throw new Exception("Cannot create response directory: " + outputDir);
            }
        }
        if (binaryDataFileStr != null) {
            File file = new File(binaryDataFileStr);
            if (!file.isFile()) {
                throw new Exception("Binary data file does not exist or is not a regular file: " + binaryDataFileStr);
            }
            if (!file.canRead()) {
                throw new Exception("Cannot read binary data file: " + binaryDataFileStr);
            }
        }
        StringBuilder jsonRequest = new StringBuilder().append(command).append("=");
        if (jsonRequestFileStr != null) {
            String requestString = new String(Files.readAllBytes(new File(jsonRequestFileStr).toPath()));
            int endOfJson = requestString.lastIndexOf(125);
            if (endOfJson == -1) {
                log.warnf("The request file [%s] does not appear to be valid JSON", (Object)jsonRequestFileStr);
                jsonRequest.append(requestString);
            } else if (endOfJson == requestString.length() - 1) {
                jsonRequest.append(requestString);
            } else {
                int ignoring = requestString.length() - endOfJson - 1;
                log.debugf("Ignoring [%d] non-JSON characters found at the end of the request file [%s]", ignoring, (Object)jsonRequestFileStr);
                jsonRequest.append(requestString.substring(0, endOfJson + 1));
            }
        } else {
            jsonRequest.append("{");
            Iterator<Map.Entry<String, String>> iter = jsonProperties.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<String, String> jsonProperty = iter.next();
                jsonRequest.append('\"').append(jsonProperty.getKey()).append('\"');
                jsonRequest.append(':');
                jsonRequest.append('\"').append(jsonProperty.getValue()).append('\"');
                if (!iter.hasNext()) continue;
                jsonRequest.append(",");
            }
            if (!jsonProperties.isEmpty() && !jsonMaps.isEmpty()) {
                jsonRequest.append(",");
            }
            HashMap<String, HashMap<String, String>> maps = new HashMap<String, HashMap<String, String>>();
            for (Map.Entry<String, String> mapNameKeyValue : jsonMaps.entrySet()) {
                String[] mapNameKey = mapNameKeyValue.getKey().split(":", 2);
                if (mapNameKey.length != 2) {
                    throw new Exception("Invalid -M argument: " + mapNameKeyValue.getKey());
                }
                String mapName = mapNameKey[0];
                String mapKey = mapNameKey[1];
                String mapValue = mapNameKeyValue.getValue();
                HashMap<String, String> parameterMap = (HashMap<String, String>)maps.get(mapName);
                if (parameterMap == null) {
                    parameterMap = new HashMap<String, String>();
                    maps.put(mapName, parameterMap);
                }
                parameterMap.put(mapKey, mapValue);
            }
            Iterator iterMap = maps.entrySet().iterator();
            while (iterMap.hasNext()) {
                Map.Entry jsonMapEntry = iterMap.next();
                jsonRequest.append('\"').append((String)jsonMapEntry.getKey()).append('\"');
                jsonRequest.append(':');
                jsonRequest.append('{');
                Iterator iterMapProperty = ((Map)jsonMapEntry.getValue()).entrySet().iterator();
                while (iterMapProperty.hasNext()) {
                    Map.Entry jsonMapPropertyEntry = iterMapProperty.next();
                    jsonRequest.append('\"').append((String)jsonMapPropertyEntry.getKey()).append('\"');
                    jsonRequest.append(':');
                    jsonRequest.append('\"').append((String)jsonMapPropertyEntry.getValue()).append('\"');
                    if (!iterMapProperty.hasNext()) continue;
                    jsonRequest.append(",");
                }
                jsonRequest.append('}');
                if (!iterMap.hasNext()) continue;
                jsonRequest.append(",");
            }
            jsonRequest.append("}");
        }
        Config config = new Config();
        config.outputDir = outputDir;
        config.serverUrl = urlStr;
        config.username = username;
        config.password = password;
        config.command = command;
        config.expectedResponse = expectedResponse;
        config.jsonRequest = jsonRequest.toString();
        config.binaryDataFile = binaryDataFileStr == null ? null : new File(binaryDataFileStr);
        log.debug(config);
        return config;
    }

    private static void printHelp(ProcessedCommand<?> options) {
        if (options == null) {
            throw new RuntimeException("Cannot print help - options is null");
        }
        System.out.println(options.printHelp());
        System.out.println("NOTE: Set the 'debug' system property to 'true' for debug logging");
    }

    private static String readSecretFromStdin(String message) {
        Console console = System.console();
        if (console == null) {
            return null;
        }
        console.writer().write(message);
        console.writer().flush();
        return String.valueOf(console.readPassword());
    }

    private static ProcessedCommand<?> buildCommandLineOptions() throws Exception {
        ProcessedCommandBuilder cmd = new ProcessedCommandBuilder();
        cmd.name(COMMAND_NAME);
        cmd.description("Sends commands to Hawkular Server");
        cmd.addOption(new ProcessedOptionBuilder().name(OPT_OUTPUT_DIR).optionType(OptionType.NORMAL).type(String.class).description("Directory to store the response. Default is the current directory.").create());
        cmd.addOption(new ProcessedOptionBuilder().name(OPT_SERVER_WEB_SOCKET_URL).optionType(OptionType.NORMAL).type(String.class).description("The URL to connect to the Hawkular Server web socket. Default is ws://127.0.0.1:8080/hawkular/command-gateway/ui/ws").create());
        cmd.addOption(new ProcessedOptionBuilder().name(OPT_USERNAME).optionType(OptionType.NORMAL).type(String.class).description("User the CLI will use when connecting to Hawkular Server.").required(true).create());
        cmd.addOption(new ProcessedOptionBuilder().name(OPT_PASSWORD).optionType(OptionType.NORMAL).type(String.class).description("Credentials the CLI will use when connecting to Hawkular Server.").required(false).create());
        cmd.addOption(new ProcessedOptionBuilder().name(OPT_COMMAND).optionType(OptionType.NORMAL).type(String.class).description("The name of the JSON command request to send.").required(true).create());
        cmd.addOption(new ProcessedOptionBuilder().name(OPT_EXPECTED_RESPONSE).optionType(OptionType.NORMAL).type(String.class).description("The expected name of the JSON response. If not specified, a guess will be made based on the name of the command request.").create());
        cmd.addOption(new ProcessedOptionBuilder().name(OPT_BINARY_DATA_FILE).optionType(OptionType.NORMAL).type(String.class).description("File containing binary data to send along with the commmand (optional).").create());
        cmd.addOption(new ProcessedOptionBuilder().name(OPT_REQUEST_FILE).optionType(OptionType.NORMAL).type(String.class).description("File containing the JSON request (optional).").create());
        cmd.addOption(new ProcessedOptionBuilder().name(String.valueOf('P')).shortName('P').optionType(OptionType.GROUP).type(String.class).valueSeparator('=').description("<name>=<value> properties that make up the JSON request. Ignored if --request-file is specified.").create());
        cmd.addOption(new ProcessedOptionBuilder().name(String.valueOf('M')).shortName('M').optionType(OptionType.GROUP).type(String.class).valueSeparator('=').description("<name>:<key>=<value> map properties that make up the JSON request. This lets you build up command parameters that are maps of key/value pairs. <name> is the name of the map parameter and <key> is an entry in that map. Ignored if --request-file is specified.").create());
        return cmd.create();
    }

    static {
        if (System.getProperty("java.util.logging.config.file") == null) {
            String filename = Boolean.getBoolean("debug") ? "/logging-debug.properties" : "/logging.properties";
            InputStream inputStream = CommandCli.class.getResourceAsStream(filename);
            try {
                LogManager.getLogManager().readConfiguration(inputStream);
            }
            catch (IOException e) {
                Logger.getAnonymousLogger().severe("Could not load " + filename);
                Logger.getAnonymousLogger().severe(e.getMessage());
            }
        }
        log = org.jboss.logging.Logger.getLogger(CommandCli.class);
    }

    private static class CliWebSocketListener
    implements WebSocketListener {
        private final Config config;
        private final OkHttpClient httpClient;
        private final CountDownLatch latch = new CountDownLatch(1);
        private WebSocket webSocket;

        public CliWebSocketListener(OkHttpClient httpClient, WebSocketCall wsc, Config config) {
            this.httpClient = httpClient;
            this.config = config;
            wsc.enqueue(this);
        }

        public void waitForResponse() throws InterruptedException {
            this.latch.await();
        }

        @Override
        public void onOpen(WebSocket ws, Response response) {
            this.webSocket = ws;
            log.debugf("Web socket opened to [%s]", (Object)this.config.serverUrl);
            try {
                this.sendCommandNow();
            }
            catch (Exception e) {
                log.errorf((Throwable)e, "Failed to send command", new Object[0]);
                this.shutdown(e);
            }
        }

        @Override
        public void onClose(int code, String reason) {
            log.debugf("Web socket closed. code=[%d], reason=[%s]", code, (Object)reason);
            this.shutdown(null);
        }

        @Override
        public void onFailure(IOException error, Response response) {
            log.errorf((Throwable)error, "Command failed: %s", (Object)response);
            this.shutdown(error);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onMessage(ResponseBody responseBody) throws IOException {
            boolean finished = true;
            try {
                BasicMessageWithExtraData msgWithData;
                if (responseBody.contentType().equals(WebSocket.TEXT)) {
                    String nameAndJsonStr = responseBody.string();
                    msgWithData = new ApiDeserializer().deserialize(nameAndJsonStr);
                } else if (responseBody.contentType().equals(WebSocket.BINARY)) {
                    InputStream input = responseBody.byteStream();
                    msgWithData = new ApiDeserializer().deserialize(input);
                } else {
                    throw new IllegalArgumentException("Unknown mediatype type, please report this bug: " + responseBody.contentType());
                }
                Object msg = msgWithData.getBasicMessage();
                BinaryData binary = msgWithData.getBinaryData();
                String messageName = msg.getClass().getSimpleName();
                log.debugf("JSON response: %s=%s", (Object)messageName, (Object)msg.toJSON());
                long now = System.currentTimeMillis();
                File jsonMessageFile = new File(this.config.outputDir, messageName + now + ".json");
                Files.write(jsonMessageFile.toPath(), msg.toJSON().getBytes(), StandardOpenOption.CREATE_NEW);
                log.infof("JSON response stored in file: %s", (Object)jsonMessageFile);
                if (binary != null) {
                    File binaryFile = new File(this.config.outputDir, messageName + now + ".binary");
                    Files.copy(binary, binaryFile.toPath(), new CopyOption[0]);
                    log.infof("Binary data was in response and has been stored in file: %s", (Object)binaryFile);
                }
                if (msg.getClass().getName().contains("GenericErrorResponse")) {
                    finished = true;
                } else {
                    String expectedResponse = this.config.expectedResponse;
                    if (expectedResponse == null || expectedResponse.isEmpty()) {
                        expectedResponse = this.config.command.replace("Request", "Response");
                    }
                    finished = Arrays.asList(msg.getClass().getSimpleName(), msg.getClass().getName()).contains(expectedResponse);
                }
            }
            finally {
                responseBody.close();
                if (finished) {
                    this.shutdown(null);
                }
            }
        }

        @Override
        public void onPong(Buffer buf) {
        }

        private void sendCommandNow() throws Exception {
            if (this.config.binaryDataFile == null) {
                Buffer buffer = new Buffer();
                buffer.writeUtf8(this.config.jsonRequest);
                RequestBody requestBody = RequestBody.create(WebSocket.TEXT, buffer.readByteArray());
                this.webSocket.sendMessage(requestBody);
            } else {
                RequestBody requestBody = new RequestBody(){

                    @Override
                    public MediaType contentType() {
                        return WebSocket.BINARY;
                    }

                    @Override
                    public void writeTo(BufferedSink bufferedSink) throws IOException {
                        bufferedSink.write(((CliWebSocketListener)this).config.jsonRequest.getBytes());
                        int bufferSize = 32768;
                        try (BufferedInputStream input = new BufferedInputStream(new FileInputStream(((CliWebSocketListener)this).config.binaryDataFile), bufferSize);){
                            byte[] buffer = new byte[bufferSize];
                            int bytesRead = ((InputStream)input).read(buffer);
                            while (bytesRead != -1) {
                                bufferedSink.write(buffer, 0, bytesRead);
                                bufferedSink.flush();
                                bytesRead = ((InputStream)input).read(buffer);
                            }
                        }
                        catch (IOException ioe) {
                            throw new RuntimeException("Failed to emit to sink", ioe);
                        }
                    }
                };
                this.webSocket.sendMessage(requestBody);
            }
        }

        private void shutdown(Exception e) {
            if (this.latch.getCount() == 0L) {
                return;
            }
            try {
                block11: {
                    if (this.webSocket != null) {
                        try {
                            if (e != null) {
                                this.webSocket.close(1011, e.getMessage());
                            } else {
                                this.webSocket.close(1000, CommandCli.class.getSimpleName() + " Done");
                            }
                        }
                        catch (Exception closeException) {
                            if (closeException instanceof IllegalStateException || closeException.getMessage().contains("Socket closed")) break block11;
                            throw closeException;
                        }
                    }
                }
                this.httpClient.dispatcher().executorService().shutdown();
            }
            catch (Exception e2) {
                log.errorf((Throwable)e2, "Cannot fully close websocket", new Object[0]);
            }
            finally {
                this.latch.countDown();
            }
        }
    }

    private static class Config {
        File outputDir;
        String serverUrl;
        String username;
        String password;
        String command;
        String expectedResponse;
        String jsonRequest;
        File binaryDataFile;

        private Config() {
        }

        public String toString() {
            StringBuilder str = new StringBuilder("CLI Configuration:\n");
            str.append("Server URL:        ").append(this.serverUrl).append("\n");
            str.append("Username:          ").append(this.username).append("\n");
            str.append("Password:          ").append("***").append("\n");
            str.append("Output Directory:  ").append(this.outputDir).append("\n");
            str.append("Command:           ").append(this.command).append("\n");
            str.append("Expected Response: ").append(this.expectedResponse).append("\n");
            str.append("Binary Data File:  ").append(this.binaryDataFile).append("\n");
            str.append("JSON Request:      ").append(this.jsonRequest).append("\n");
            return str.toString();
        }

        public boolean willRespond() {
            boolean willRespond = !this.jsonRequest.toLowerCase().contains(":\"stop\"");
            return willRespond;
        }
    }
}

