/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.bus.common;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.introspect.VisibilityChecker;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.hawkular.bus.common.BasicMessage;
import org.hawkular.bus.common.BasicMessageWithExtraData;
import org.hawkular.bus.common.BinaryData;
import org.hawkular.bus.common.MessageId;
import org.hawkular.bus.common.msg.features.FailOnUnknownProperties;

public abstract class AbstractMessage
implements BasicMessage {
    @JsonIgnore
    private MessageId _messageId;
    @JsonIgnore
    private MessageId _correlationId;
    @JsonIgnore
    private Map<String, String> _headers;

    public static <T extends BasicMessage> T fromJSON(String json, Class<T> clazz) {
        try {
            Method buildObjectMapperForDeserializationMethod = AbstractMessage.findBuildObjectMapperForDeserializationMethod(clazz);
            ObjectMapper mapper = (ObjectMapper)buildObjectMapperForDeserializationMethod.invoke(null, new Object[0]);
            if (FailOnUnknownProperties.class.isAssignableFrom(clazz)) {
                mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, true);
            }
            return (T)((BasicMessage)mapper.readValue(json, clazz));
        }
        catch (Exception e) {
            throw new IllegalStateException("JSON message cannot be converted to object of type [" + clazz + "]", e);
        }
    }

    public static <T extends BasicMessage> BasicMessageWithExtraData<T> fromJSON(InputStream in, Class<T> clazz) {
        byte[] remainder;
        BasicMessage obj;
        try (JsonParser parser = new JsonFactory().configure(JsonParser.Feature.AUTO_CLOSE_SOURCE, false).createParser(in);){
            Method buildObjectMapperForDeserializationMethod = AbstractMessage.findBuildObjectMapperForDeserializationMethod(clazz);
            ObjectMapper mapper = (ObjectMapper)buildObjectMapperForDeserializationMethod.invoke(null, new Object[0]);
            if (FailOnUnknownProperties.class.isAssignableFrom(clazz)) {
                mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, true);
            }
            obj = (BasicMessage)mapper.readValue(parser, clazz);
            ByteArrayOutputStream remainderStream = new ByteArrayOutputStream();
            int released = parser.releaseBuffered(remainderStream);
            remainder = released > 0 ? remainderStream.toByteArray() : new byte[]{};
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Stream cannot be converted to JSON object of type [" + clazz + "]", e);
        }
        return new BasicMessageWithExtraData<BasicMessage>(obj, new BinaryData(remainder, in));
    }

    private static Method findBuildObjectMapperForDeserializationMethod(Class<? extends BasicMessage> clazz) {
        try {
            Method m = clazz.getDeclaredMethod("buildObjectMapperForDeserialization", new Class[0]);
            return m;
        }
        catch (NoSuchMethodException e) {
            return AbstractMessage.findBuildObjectMapperForDeserializationMethod(clazz.getSuperclass());
        }
    }

    protected static ObjectMapper buildObjectMapperForDeserialization() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return mapper;
    }

    @Override
    public String toJSON() {
        ObjectMapper mapper = this.buildObjectMapperForSerialization();
        try {
            return mapper.writeValueAsString(this);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Object cannot be parsed as JSON.", e);
        }
    }

    protected ObjectMapper buildObjectMapperForSerialization() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setVisibilityChecker((VisibilityChecker<?>)mapper.getSerializationConfig().getDefaultVisibilityChecker().withFieldVisibility(JsonAutoDetect.Visibility.ANY).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withSetterVisibility(JsonAutoDetect.Visibility.NONE).withCreatorVisibility(JsonAutoDetect.Visibility.NONE));
        return mapper;
    }

    protected AbstractMessage() {
    }

    @Override
    public MessageId getMessageId() {
        return this._messageId;
    }

    @Override
    public void setMessageId(MessageId messageId) {
        this._messageId = messageId;
    }

    @Override
    public MessageId getCorrelationId() {
        return this._correlationId;
    }

    @Override
    public void setCorrelationId(MessageId correlationId) {
        this._correlationId = correlationId;
    }

    @Override
    public Map<String, String> getHeaders() {
        if (this._headers == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this._headers);
    }

    @Override
    public void setHeaders(Map<String, String> headers) {
        if (headers == null || headers.isEmpty()) {
            this._headers = null;
        } else if (this._headers == null) {
            this._headers = new HashMap<String, String>(headers);
        } else {
            this._headers.clear();
            this._headers.putAll(headers);
        }
    }

    public String toString() {
        StringBuilder str = new StringBuilder(this.getClass().getSimpleName() + ": [");
        str.append("message-id=");
        str.append(this.getMessageId());
        str.append(", correlation-id=");
        str.append(this.getCorrelationId());
        str.append(", headers=");
        str.append(this.getHeaders());
        str.append(", json-body=[");
        str.append(this.toJSON());
        str.append("]]");
        return str.toString();
    }
}

