/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.javaagent.itest.util;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.management.ObjectName;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.RealmCallback;
import okhttp3.Credentials;
import org.hawkular.agent.itest.util.ITestHelper;
import org.hawkular.agent.javaagent.JavaAgentEngine;
import org.hawkular.agent.javaagent.config.ConfigManager;
import org.hawkular.agent.javaagent.config.Configuration;
import org.hawkular.agent.monitor.service.ServiceStatus;
import org.hawkular.dmr.api.OperationBuilder;
import org.hawkular.dmrclient.Address;
import org.hawkular.dmrclient.JBossASClient;
import org.hawkular.inventory.paths.CanonicalPath;
import org.hawkular.javaagent.itest.util.WildFlyClientConfig;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.helpers.Operations;
import org.jboss.dmr.ModelNode;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;

public abstract class AbstractITest {
    private static final Logger log = Logger.getLogger(AbstractITest.class.getName());
    private static volatile boolean hawkularServerIsReady = false;
    protected static final String hawkularHost;
    protected static final int hawkularHttpPort;
    protected static final int hawkularManagementPort;
    protected static final String hawkularAuthHeader;
    protected static final String authentication;
    protected static final String baseMetricsUri;
    protected static final String baseGwUri;
    protected static final String baseInvUri;
    protected static final String agentJolokiaUri;
    protected static final String managementUser;
    protected static final String managementPasword;
    protected static final String hawkularTestUser;
    protected static final String hawkularTestPasword;
    private static final String tenantId;
    protected static final String hawkularFeedId;
    protected static final File agentConfigFile;
    protected static final Object waitForAccountsLock;
    protected static final Object waitForAgentLock;
    protected static final ObjectName AGENT_MBEAN_OBJECT_NAME;
    protected static final File plainWildFlyHome;
    protected ITestHelper testHelper;

    public static String readNode(Class<?> caller, String nodeFileName) throws IOException {
        URL url = caller.getResource(caller.getSimpleName() + "." + nodeFileName);
        if (url != null) {
            StringBuilder result = new StringBuilder();
            try (InputStreamReader r = new InputStreamReader(url.openStream(), "utf-8");){
                char[] buff = new char[1024];
                int len = 0;
                while ((len = ((Reader)r).read(buff, 0, buff.length)) != -1) {
                    result.append(buff, 0, len);
                }
            }
            return result.toString();
        }
        return null;
    }

    public static void writeNode(Class<?> caller, ModelNode node, String nodeFileName) throws UnsupportedEncodingException, FileNotFoundException {
        URL callerUrl = caller.getResource(caller.getSimpleName() + ".class");
        if (!callerUrl.getProtocol().equals("file")) {
            throw new IllegalStateException(AbstractITest.class.getName() + ".store() works only if the caller's class file is loaded using a file:// URL.");
        }
        String callerUrlPath = callerUrl.getPath();
        String nodePath = callerUrlPath.replaceAll("\\.class$", "." + nodeFileName);
        nodePath = nodePath.replace("/target/test-classes/", "/src/test/resources/");
        System.out.println("Storing a node to [" + nodePath + "]");
        File outputFile = new File(nodePath);
        if (!outputFile.getParentFile().exists()) {
            outputFile.getParentFile().mkdirs();
        }
        try (PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), "utf-8"));){
            node.writeString(out, false);
        }
    }

    @BeforeMethod
    public void before() {
        this.testHelper = new ITestHelper(tenantId, hawkularAuthHeader, baseInvUri);
    }

    @AfterMethod
    public void after() {
        this.testHelper.client().dispatcher().executorService().shutdown();
    }

    protected String getNodeAttribute(ModelControllerClient mcc, ModelNode addressActual, String attributeName) {
        return ((OperationBuilder.ReadAttributeOperationBuilder)OperationBuilder.readAttribute().address(addressActual)).name(attributeName).includeDefaults().execute(mcc).assertSuccess().getResultNode().asString();
    }

    protected void writeNodeAttribute(ModelControllerClient mcc, ModelNode address, String attribute, String value) {
        ((OperationBuilder.WriteAttributeOperationBuilder)OperationBuilder.writeAttribute().address(address)).attribute(attribute, value).execute(mcc).assertSuccess();
    }

    protected void writeNodeAttribute(ModelControllerClient mcc, ModelNode address, String attribute, Integer value) {
        ((OperationBuilder.WriteAttributeOperationBuilder)OperationBuilder.writeAttribute().address(address)).attribute(attribute, value).execute(mcc).assertSuccess();
    }

    protected void assertNodeAttributeEquals(ModelControllerClient mcc, ModelNode address, String attribute, String expectedValue) {
        String actualAttributeValue = this.getNodeAttribute(mcc, address, attribute);
        Assert.assertEquals((String)actualAttributeValue, (String)expectedValue);
    }

    protected void assertNodeEquals(ModelControllerClient mcc, ModelNode addressl, Class<?> caller, String expectedNodeFileName) {
        this.assertNodeEquals(mcc, addressl, caller, expectedNodeFileName, false);
    }

    protected void assertNodeEquals(ModelControllerClient mcc, ModelNode address, Class<?> caller, String expectedNodeFileName, boolean saveActual) {
        try {
            ModelNode actual = ((OperationBuilder.ReadResourceOperationBuilder)OperationBuilder.readResource().address(address)).includeRuntime().includeDefaults().recursive().execute(mcc).assertSuccess().getResultNode();
            String expected = AbstractITest.readNode(caller, expectedNodeFileName);
            String actualString = actual.toString();
            if (saveActual) {
                AbstractITest.writeNode(caller, actual, expectedNodeFileName + ".actual.txt");
            }
            Assert.assertEquals((String)actualString, (String)expected);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void assertNodeRegex(ModelControllerClient mcc, ModelNode address, Class<?> caller, String expectedNodeFileName, boolean saveActual) {
        try {
            ModelNode actual = ((OperationBuilder.ReadResourceOperationBuilder)OperationBuilder.readResource().address(address)).includeRuntime().includeDefaults().recursive().execute(mcc).assertSuccess().getResultNode();
            String expected = AbstractITest.readNode(caller, expectedNodeFileName);
            Pattern pattern = Pattern.compile(expected);
            String actualString = actual.toString();
            if (saveActual) {
                AbstractITest.writeNode(caller, actual, expectedNodeFileName + ".actual.txt");
            }
            Assert.assertTrue((boolean)pattern.matcher(actualString).matches());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void assertResourceCount(ModelControllerClient mcc, ModelNode address, String childType, int expectedCount) throws IOException {
        ModelNode request = new ModelNode();
        request.get("address").set(address);
        request.get("operation").set("read-children-resources");
        request.get("child-type").set(childType);
        request.get("include-runtime").set(true);
        ModelNode response = mcc.execute(request);
        if (response.hasDefined("outcome") && response.get("outcome").asString().equals("success")) {
            ModelNode result = response.get("result");
            List nodes = result.asPropertyList();
            AssertJUnit.assertEquals((String)("Number of child nodes of [" + address + "] " + response), (int)expectedCount, (int)nodes.size());
        } else if (expectedCount != 0) {
            AssertJUnit.fail((String)("Path [" + address + "] has no child nodes, expected [" + expectedCount + "]: " + response));
        }
    }

    protected void assertResourceExists(ModelControllerClient mcc, ModelNode address, boolean expectedExists) throws IOException {
        ModelNode request = new ModelNode();
        request.get("address").set(address);
        request.get("operation").set("read-resource");
        request.get("include-runtime").set(true);
        ModelNode result = mcc.execute(request);
        String message = String.format("Model node [%s] %s unexpectedly", address.toString(), expectedExists ? "does not exist" : "exists");
        AssertJUnit.assertTrue((String)String.format(message, result), (Operations.isSuccessfulOutcome((ModelNode)result) == expectedExists ? 1 : 0) != 0);
    }

    protected static WildFlyClientConfig getPlainWildFlyClientConfig() {
        return new WildFlyClientConfig();
    }

    protected static ModelControllerClient newPlainWildFlyModelControllerClient(WildFlyClientConfig config) {
        return AbstractITest.newModelControllerClient(config.getHost(), config.getManagementPort());
    }

    protected static ModelControllerClient newHawkularModelControllerClient() {
        return AbstractITest.newModelControllerClient(hawkularHost, hawkularManagementPort);
    }

    protected static ModelControllerClient newModelControllerClient(String host, int managementPort) {
        CallbackHandler callbackHandler = new CallbackHandler(){

            @Override
            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                for (Callback current : callbacks) {
                    if (current instanceof NameCallback) {
                        NameCallback ncb = (NameCallback)current;
                        log.fine("ModelControllerClient is sending a username [" + managementUser + "]");
                        ncb.setName(managementUser);
                        continue;
                    }
                    if (current instanceof PasswordCallback) {
                        PasswordCallback pcb = (PasswordCallback)current;
                        log.fine("ModelControllerClient is sending a password [" + managementPasword + "]");
                        pcb.setPassword(managementPasword.toCharArray());
                        continue;
                    }
                    if (current instanceof RealmCallback) {
                        RealmCallback rcb = (RealmCallback)current;
                        log.fine("ModelControllerClient is sending a realm [" + rcb.getDefaultText() + "]");
                        rcb.setText(rcb.getDefaultText());
                        continue;
                    }
                    throw new UnsupportedCallbackException(current);
                }
            }
        };
        try {
            InetAddress inetAddr = InetAddress.getByName(host);
            log.fine("Connecting a ModelControllerClient to [" + host + ":" + managementPort + "]");
            return ModelControllerClient.Factory.create((InetAddress)inetAddr, (int)managementPort, (CallbackHandler)callbackHandler);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create management client", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Collection<String> getDMRChildrenNames(WildFlyClientConfig wfConfig, String childTypeName, PathAddress parentAddress) {
        try (ModelControllerClient mcc = wfConfig == null ? AbstractITest.newHawkularModelControllerClient() : AbstractITest.newPlainWildFlyModelControllerClient(wfConfig);){
            ModelNode result = ((OperationBuilder.StringListOperationResult)((OperationBuilder.ReadChildrenNamesOperationBuilder)OperationBuilder.readChildrenNames().address(parentAddress)).childType(childTypeName).execute(mcc)).getResultNode();
            Collection collection = result.asList().stream().map(n -> n.asString()).collect(Collectors.toList());
            return collection;
        }
        catch (IOException e) {
            throw new RuntimeException("Could not get [" + childTypeName + "] children of parent [" + parentAddress + "]", e);
        }
    }

    protected Collection<String> getDMRChildrenNames(String childTypeName, PathAddress parentAddress) {
        return this.getDMRChildrenNames(null, childTypeName, parentAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForHawkularServerToBeReady() throws Throwable {
        Object object = waitForAccountsLock;
        synchronized (object) {
            if (!hawkularServerIsReady) {
                Thread.sleep(8000L);
                String response = "";
                while (!response.contains("STARTED")) {
                    Thread.sleep(2000L);
                    response = this.testHelper.getWithRetries(baseMetricsUri + "/status");
                }
                hawkularServerIsReady = true;
            }
        }
    }

    protected boolean waitForAgentViaJMX() throws Throwable {
        Object object = waitForAgentLock;
        synchronized (object) {
            try {
                String status = "";
                int count = 0;
                while (!ServiceStatus.RUNNING.name().equals(status) && count++ < 12) {
                    Thread.sleep(5000L);
                    String url = agentJolokiaUri + "/exec/" + AGENT_MBEAN_OBJECT_NAME.toString() + "/status";
                    String json = this.testHelper.getWithRetries(url);
                    JsonNode results = this.testHelper.mapper().readTree(json);
                    if (!results.has("value")) continue;
                    status = results.get("value").asText("");
                }
                return ServiceStatus.RUNNING.name().equals(status);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not get agent status", e);
            }
        }
    }

    protected boolean waitForAgent(ModelControllerClient mcc) throws Throwable {
        Address agentAddress = Address.parse((String)"/subsystem=hawkular-wildfly-agent");
        return this.waitForAgent(mcc, agentAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean waitForAgent(ModelControllerClient mcc, Address agentAddress) throws Throwable {
        Object object = waitForAgentLock;
        synchronized (object) {
            String agentPath = agentAddress.toAddressPathString();
            log.info("Checking [" + agentPath + "] status...");
            int count = 0;
            while (++count <= 12) {
                Thread.sleep(5000L);
                ModelNode op = JBossASClient.createRequest((String)"status", (Address)agentAddress);
                ModelNode result = new JBossASClient(mcc).execute(op);
                if (!JBossASClient.isSuccess((ModelNode)result)) continue;
                String status = JBossASClient.getResults((ModelNode)result).asString().toUpperCase();
                if (ServiceStatus.RUNNING.name().equals(status)) {
                    log.info("Agent [" + agentPath + "] status=" + status + ", continuing...");
                    return true;
                }
                log.info("Agent [" + agentPath + "] status=" + status + ", waiting...");
            }
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ModelNode getDMRAgentInventoryReport(String host, int managementPort) {
        try (ModelControllerClient mcc = AbstractITest.newModelControllerClient(host, managementPort);){
            Address agentAddress = Address.parse((String)"/subsystem=hawkular-wildfly-agent");
            ModelNode op = JBossASClient.createRequest((String)"inventoryReport", (Address)agentAddress);
            ModelNode inventoryReport = new JBossASClient(mcc).execute(op);
            if (JBossASClient.isSuccess((ModelNode)inventoryReport)) {
                ModelNode modelNode = JBossASClient.getResults((ModelNode)inventoryReport);
                return modelNode;
            }
            throw new Exception(JBossASClient.getFailureDescription((ModelNode)inventoryReport));
        }
        catch (Exception e) {
            throw new RuntimeException("Could not get inventory report", e);
        }
    }

    protected JsonNode getJMXAgentInventoryReport() {
        try {
            String url = agentJolokiaUri + "/exec/" + AGENT_MBEAN_OBJECT_NAME.toString() + "/inventoryReport";
            String json = this.testHelper.getWithRetries(url);
            JsonNode results = this.testHelper.mapper().readTree(json);
            if (results.has("value")) {
                String inventoryJson = results.get("value").asText();
                return this.testHelper.mapper().readTree(inventoryJson);
            }
            throw new Exception("No inventory report");
        }
        catch (Throwable e) {
            throw new RuntimeException("Could not get inventory report", e);
        }
    }

    protected void restartJMXAgent() {
        try {
            String url = agentJolokiaUri + "/exec/" + AGENT_MBEAN_OBJECT_NAME.toString() + "/";
            this.testHelper.getWithRetries(url + "stop");
            this.testHelper.getWithRetries(url + "start");
            if (!this.waitForAgentViaJMX()) {
                throw new Exception("Agent is not coming back up");
            }
        }
        catch (Throwable e) {
            throw new RuntimeException("Could not restart JMX agent", e);
        }
    }

    protected CanonicalPath getHawkularWildFlyServerResourcePath() throws Throwable {
        Map wildflyServers = this.testHelper.getBlueprintsByType(hawkularFeedId, "WildFly Server", 1);
        AssertJUnit.assertEquals((int)1, (int)wildflyServers.size());
        return (CanonicalPath)wildflyServers.keySet().iterator().next();
    }

    protected CanonicalPath getHostController() throws Throwable {
        Map hcs = this.testHelper.getBlueprintsByType(hawkularFeedId, "Host Controller", 1);
        AssertJUnit.assertEquals((int)1, (int)hcs.size());
        return (CanonicalPath)hcs.keySet().iterator().next();
    }

    protected File getTestApplicationFile() {
        String dir = System.getProperty("hawkular.agent.itest.staging.dir");
        File app = new File(dir, "hawkular-javaagent-helloworld-war.war");
        Assert.assertTrue((boolean)app.isFile(), (String)("Missing test application - build is bad: " + app.getAbsolutePath()));
        return app;
    }

    protected Configuration getAgentConfigurationFromFile() throws Exception {
        Configuration config = new ConfigManager(agentConfigFile).getConfiguration(true);
        config.validate();
        return config;
    }

    @Deprecated
    private JavaAgentEngine runAgent() throws Exception {
        log.info("Test is asking to start its own agent using config: " + agentConfigFile);
        JavaAgentEngine agent = new JavaAgentEngine(agentConfigFile);
        agent.startHawkularAgent();
        for (int attempt = 0; attempt < 60; ++attempt) {
            if (agent.getStatus() == ServiceStatus.RUNNING) {
                return agent;
            }
            Thread.sleep(1000L);
        }
        throw new Exception("Agent failed to enter the RUNNING state");
    }

    static {
        managementUser = System.getProperty("hawkular.agent.itest.mgmt.user");
        managementPasword = System.getProperty("hawkular.agent.itest.mgmt.password");
        hawkularTestUser = System.getProperty("hawkular.itest.rest.user");
        hawkularTestPasword = System.getProperty("hawkular.itest.rest.password");
        tenantId = System.getProperty("hawkular.agent.itest.rest.tenantId");
        hawkularFeedId = System.getProperty("hawkular.agent.itest.rest.feedId");
        agentConfigFile = new File(System.getProperty("hawkular.agent.itest.javaagent.configfile"));
        waitForAccountsLock = new Object();
        waitForAgentLock = new Object();
        String h = System.getProperty("hawkular.bind.address", "localhost");
        if ("0.0.0.0".equals(h)) {
            h = "localhost";
        }
        hawkularHost = h;
        int hawkularPortOffset = Integer.parseInt(System.getProperty("hawkular.port.offset", "0"));
        hawkularHttpPort = hawkularPortOffset + 8080;
        hawkularManagementPort = hawkularPortOffset + 9990;
        hawkularAuthHeader = Credentials.basic((String)hawkularTestUser, (String)hawkularTestPasword);
        System.out.println("using REST user [" + hawkularTestUser + "] with password [" + hawkularTestPasword + "]");
        authentication = "{\"username\":\"" + hawkularTestUser + "\",\"password\":\"" + hawkularTestPasword + "\"}";
        baseMetricsUri = "http://" + hawkularHost + ":" + hawkularHttpPort + "/hawkular/metrics";
        baseInvUri = baseMetricsUri + "/strings";
        baseGwUri = "ws://" + hawkularHost + ":" + hawkularHttpPort + "/hawkular/command-gateway";
        agentJolokiaUri = "http://" + hawkularHost + ":" + hawkularHttpPort + "/jolokia-war";
        try {
            AGENT_MBEAN_OBJECT_NAME = new ObjectName("org.hawkular:type=hawkular-javaagent");
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot build agent mbean object name", e);
        }
        String sysPropName = "hawkular.agent.itest.plain-wildfly.dir";
        String sysPropValue = System.getProperty(sysPropName);
        if (sysPropValue != null) {
            plainWildFlyHome = new File(sysPropValue);
            Assert.assertTrue((boolean)plainWildFlyHome.exists(), (String)(sysPropName + " [" + plainWildFlyHome.getAbsolutePath() + "] does not exist"));
        } else {
            plainWildFlyHome = null;
        }
    }
}

