/*
 * Copyright 2015 Red Hat, Inc. and/or its affiliates
 * and other contributors as indicated by the @author tags.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.hawkular.agent.monitor.inventory;

public abstract class ResourceConfigurationPropertyInstance<T extends ResourceConfigurationPropertyType<?>>
        extends NamedObject {

    private final T configurationPropertyType;
    private String value;

    public ResourceConfigurationPropertyInstance(ID id, Name name, T configurationPropertyType) {
        super(id, name);
        this.configurationPropertyType = configurationPropertyType;
    }

    public T getResourceConfigurationPropertyType() {
        return configurationPropertyType;
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.format("%s[value=%s]", super.toString(), getValue());
    }
}
