/*
 * Copyright 2015 Red Hat, Inc. and/or its affiliates
 * and other contributors as indicated by the @author tags.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.hawkular.agent.monitor.scheduler.polling.dmr;

import org.hawkular.agent.monitor.inventory.dmr.DMRMetricInstance;
import org.hawkular.agent.monitor.scheduler.config.DMREndpoint;
import org.hawkular.agent.monitor.scheduler.config.Interval;
import org.hawkular.agent.monitor.scheduler.polling.KeyGenerator;
import org.hawkular.dmrclient.Address;

/**
 * Represents a DMR task that is to be used to collect a metric.
 */
public class MetricDMRTask extends DMRTask {

    private final DMRMetricInstance metricInstance;

    public MetricDMRTask(
            Interval interval,
            DMREndpoint endpoint,
            Address address,
            String attribute,
            String subref,
            DMRMetricInstance metricInstance) {

        super(Type.METRIC, interval, endpoint, address, attribute, subref);
        this.metricInstance = metricInstance;
    }

    /**
     * If this task is collecting a metric from an inventoried resource,
     * this will be the metric instance of that resource.
     * If there is no inventoried resource behind this collected metric, this will be null.
     *
     * @return the metric instance or null if no inventoried resource backs this metric
     */
    public DMRMetricInstance getMetricInstance() {
        return metricInstance;
    }

    @Override
    public KeyGenerator getKeyGenerator() {
        return new MetricDMRTaskKeyGenerator();
    }

    @Override
    public String toString() {
        StringBuilder str = new StringBuilder("MetricDMRTask: ");
        str.append(super.toString());
        return str.toString();
    }
}
