/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.aegis.type;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import org.apache.cxf.aegis.AegisContext;
import org.apache.cxf.aegis.type.AegisType;
import org.apache.cxf.aegis.type.TypeMapping;
import org.apache.cxf.aegis.util.NamespaceHelper;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.xmlschema.XmlSchemaUtils;
import org.apache.ws.commons.schema.XmlSchema;

public final class TypeUtil {
    public static final Logger LOG = LogUtils.getL7dLogger(TypeUtil.class);

    private TypeUtil() {
    }

    public static AegisType getReadType(XMLStreamReader xsr, AegisContext context, AegisType baseType) {
        if (!context.isReadXsiTypes()) {
            if (baseType == null) {
                LOG.warning("xsi:type reading disabled, and no type available for " + xsr.getName());
            }
            return baseType;
        }
        String overrideType = xsr.getAttributeValue("http://www.w3.org/2001/XMLSchema-instance", "type");
        if (overrideType != null) {
            QName overrideName = NamespaceHelper.createQName(xsr.getNamespaceContext(), overrideType);
            if (baseType == null || !overrideName.equals(baseType.getSchemaType())) {
                AegisType improvedType = null;
                if (baseType != null) {
                    TypeMapping tm = baseType.getTypeMapping();
                    improvedType = tm.getType(overrideName);
                }
                if (improvedType == null) {
                    improvedType = context.getRootType(overrideName);
                }
                if (improvedType != null) {
                    return improvedType;
                }
            }
            if (baseType != null) {
                LOG.finest("xsi:type=\"" + overrideName + "\" was specified, but no corresponding AegisType was registered; defaulting to " + baseType.getSchemaType());
                return baseType;
            }
            LOG.warning("xsi:type=\"" + overrideName + "\" was specified, but no corresponding AegisType was registered; no default.");
            return null;
        }
        if (baseType == null) {
            LOG.warning("xsi:type absent, and no type available for " + xsr.getName());
        }
        return baseType;
    }

    public static AegisType getReadTypeStandalone(XMLStreamReader xsr, AegisContext context, AegisType baseType) {
        if (baseType != null) {
            return TypeUtil.getReadType(xsr, context, baseType);
        }
        if (!context.isReadXsiTypes()) {
            LOG.warning("xsi:type reading disabled, and no type available for " + xsr.getName());
            return null;
        }
        String typeNameString = xsr.getAttributeValue("http://www.w3.org/2001/XMLSchema-instance", "type");
        if (typeNameString != null) {
            QName schemaTypeName = NamespaceHelper.createQName(xsr.getNamespaceContext(), typeNameString);
            TypeMapping tm = context.getTypeMapping();
            AegisType type = tm.getType(schemaTypeName);
            if (type == null) {
                type = context.getRootType(schemaTypeName);
            }
            if (type != null) {
                return type;
            }
            LOG.warning("xsi:type=\"" + schemaTypeName + "\" was specified, but no corresponding AegisType was registered; no default.");
            return null;
        }
        LOG.warning("xsi:type was not specified for top-level element " + xsr.getName());
        return null;
    }

    public static AegisType getWriteType(AegisContext globalContext, Object value, AegisType type) {
        AegisType overrideType;
        if (value != null && type != null && type.getTypeClass() != value.getClass() && (overrideType = globalContext.getRootType(value.getClass())) != null) {
            return overrideType;
        }
        return type;
    }

    public static AegisType getWriteTypeStandalone(AegisContext globalContext, Object value, AegisType type) {
        if (type != null) {
            return TypeUtil.getWriteType(globalContext, value, type);
        }
        TypeMapping tm = globalContext.getTypeMapping();
        type = tm.getType(value.getClass());
        return type;
    }

    public static AegisType getWriteTypeStandalone(AegisContext globalContext, Object value, Type reflectType) {
        if (reflectType == null) {
            return TypeUtil.getWriteTypeStandalone(globalContext, value, (AegisType)null);
        }
        return globalContext.getTypeMapping().getTypeCreator().createType(reflectType);
    }

    public static void setAttributeAttributes(QName name, AegisType type, XmlSchema root) {
        String ns = type.getSchemaType().getNamespaceURI();
        XmlSchemaUtils.addImportIfNeeded((XmlSchema)root, (String)ns);
    }

    public static Class<?> getTypeClass(Type type, boolean throwForNonClass) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (throwForNonClass) {
            throw new RuntimeException("Attempt to derive Class from reflection Type " + type);
        }
        return null;
    }

    public static Type getSingleTypeParameter(Type type) {
        return TypeUtil.getSingleTypeParameter(type, 0);
    }

    public static Type getSingleTypeParameter(Type type, int index) {
        ParameterizedType pType;
        Type[] params;
        if (type instanceof ParameterizedType && (params = (pType = (ParameterizedType)type).getActualTypeArguments()).length > index) {
            return params[index];
        }
        return null;
    }

    public static Class<?> getTypeRelatedClass(Type type) {
        Class<?> directClass = TypeUtil.getTypeClass(type, false);
        if (directClass != null) {
            return directClass;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)type;
            return TypeUtil.getTypeRelatedClass(pType.getRawType());
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType gat = (GenericArrayType)type;
            Type compType = gat.getGenericComponentType();
            Class<?> arrayBaseType = TypeUtil.getTypeRelatedClass(compType);
            Object instance = Array.newInstance(arrayBaseType, 0);
            return instance.getClass();
        }
        return null;
    }
}

