/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.totalorder;

import java.util.Set;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commands.tx.AbstractTransactionBoundaryCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.tx.totalorder.TotalOrderPrepareCommand;
import org.infinispan.commons.CacheException;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;
import org.infinispan.transaction.impl.RemoteTransaction;
import org.infinispan.transaction.impl.TotalOrderRemoteTransactionState;
import org.infinispan.transaction.impl.TransactionTable;
import org.infinispan.transaction.totalorder.TotalOrderManager;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.concurrent.BlockingTaskAwareExecutorService;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class TotalOrderInterceptor
extends CommandInterceptor {
    private static final Log log = LogFactory.getLog(TotalOrderInterceptor.class);
    private static final boolean trace = log.isTraceEnabled();
    private TransactionTable transactionTable;
    private TotalOrderManager totalOrderManager;
    private ClusteringDependentLogic clusteringDependentLogic;
    private BlockingTaskAwareExecutorService executorService;

    @Inject
    public void inject(TransactionTable transactionTable, TotalOrderManager totalOrderManager, ClusteringDependentLogic clusteringDependentLogic, @ComponentName(value="org.infinispan.executors.remote") BlockingTaskAwareExecutorService executorService) {
        this.transactionTable = transactionTable;
        this.totalOrderManager = totalOrderManager;
        this.clusteringDependentLogic = clusteringDependentLogic;
        this.executorService = executorService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        if (log.isDebugEnabled()) {
            log.debugf("Prepare received. Transaction=%s, Affected keys=%s, Local=%s", command.getGlobalTransaction().globalId(), command.getAffectedKeys(), ctx.isOriginLocal());
        }
        if (!(command instanceof TotalOrderPrepareCommand)) {
            throw new IllegalStateException("TotalOrderInterceptor can only handle TotalOrderPrepareCommand");
        }
        this.simulateLocking(ctx, command, this.clusteringDependentLogic);
        if (ctx.isOriginLocal()) {
            return this.invokeNextInterceptor(ctx, command);
        }
        TotalOrderRemoteTransactionState state = this.getTransactionState(ctx);
        try {
            state.preparing();
            if (state.isRollbackReceived()) {
                this.transactionTable.removeRemoteTransaction(command.getGlobalTransaction());
                throw new CacheException("Cannot prepare transaction" + command.getGlobalTransaction().globalId() + ". it was already marked as rollback");
            }
            if (state.isCommitReceived()) {
                log.tracef("Transaction %s marked for commit, skipping the write skew check and forcing 1PC", command.getGlobalTransaction().globalId());
                ((TotalOrderPrepareCommand)((Object)command)).markSkipWriteSkewCheck();
                ((TotalOrderPrepareCommand)((Object)command)).markAsOnePhaseCommit();
            }
            if (trace) {
                log.tracef("Validating transaction %s ", command.getGlobalTransaction().globalId());
            }
            Object result = this.invokeNextInterceptor(ctx, command);
            if (command.isOnePhaseCommit()) {
                this.totalOrderManager.release(state);
            }
            Object object = result;
            state.prepared();
            return object;
        }
        catch (Throwable throwable) {
            try {
                state.prepared();
                throw throwable;
            }
            catch (Throwable exception) {
                if (log.isDebugEnabled()) {
                    log.debugf(exception, "Exception while preparing for transaction %s. Local=%s", command.getGlobalTransaction().globalId(), ctx.isOriginLocal());
                }
                if (command.isOnePhaseCommit()) {
                    this.transactionTable.remoteTransactionRollback(command.getGlobalTransaction());
                }
                throw exception;
            }
        }
    }

    @Override
    public Object visitRollbackCommand(TxInvocationContext ctx, RollbackCommand command) throws Throwable {
        return this.visitSecondPhaseCommand(ctx, command, false);
    }

    @Override
    public Object visitCommitCommand(TxInvocationContext ctx, CommitCommand command) throws Throwable {
        return this.visitSecondPhaseCommand(ctx, command, true);
    }

    @Override
    public final Object visitLockControlCommand(TxInvocationContext ctx, LockControlCommand command) throws Throwable {
        throw new UnsupportedOperationException("Lock interface not supported with total order protocol");
    }

    private Object visitSecondPhaseCommand(TxInvocationContext context, AbstractTransactionBoundaryCommand command, boolean commit) throws Throwable {
        GlobalTransaction gtx = command.getGlobalTransaction();
        if (trace) {
            log.tracef("Second phase command received. Commit?=%s Transaction=%s, Local=%s", commit, gtx.globalId(), context.isOriginLocal());
        }
        TotalOrderRemoteTransactionState state = this.getTransactionState(context);
        try {
            if (!this.processSecondCommand(state, commit) && !context.isOriginLocal()) {
                Object var6_6 = null;
                return var6_6;
            }
            Object object = this.invokeNextInterceptor(context, command);
            return object;
        }
        catch (Throwable exception) {
            if (log.isDebugEnabled()) {
                log.debugf(exception, "Exception while rollback transaction %s", gtx.globalId());
            }
            throw exception;
        }
        finally {
            if (state != null && state.isFinished()) {
                this.totalOrderManager.release(state);
                if (commit) {
                    this.transactionTable.remoteTransactionCommitted(command.getGlobalTransaction(), false);
                } else {
                    this.transactionTable.remoteTransactionRollback(command.getGlobalTransaction());
                }
                if (context.isOriginLocal()) {
                    this.executorService.checkForReadyTasks();
                }
            }
        }
    }

    private TotalOrderRemoteTransactionState getTransactionState(TxInvocationContext context) {
        if (!context.isOriginLocal()) {
            return ((RemoteTransaction)context.getCacheTransaction()).getTransactionState();
        }
        RemoteTransaction remoteTransaction = this.transactionTable.getRemoteTransaction(context.getGlobalTransaction());
        return remoteTransaction == null ? null : remoteTransaction.getTransactionState();
    }

    private boolean processSecondCommand(TotalOrderRemoteTransactionState state, boolean commit) {
        if (state == null) {
            return true;
        }
        try {
            return state.waitUntilPrepared(commit);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.timeoutWaitingUntilTransactionPrepared(state.getGlobalTransaction().globalId());
            return false;
        }
    }

    private void simulateLocking(TxInvocationContext context, PrepareCommand command, ClusteringDependentLogic clusteringDependentLogic) {
        Set<Object> affectedKeys = command.getAffectedKeys();
        context.addAllAffectedKeys(command.getAffectedKeys());
        context.clearLockedKeys();
        for (Object e : affectedKeys) {
            if (!clusteringDependentLogic.localNodeIsPrimaryOwner(e)) continue;
            context.addLockedKey(e);
        }
    }
}

