/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.extension;

import org.hawkular.agent.monitor.config.AgentCoreEngineConfiguration;
import org.hawkular.agent.monitor.extension.MonitorServiceConfigurationBuilder;
import org.hawkular.agent.monitor.extension.SubsystemAttributes;
import org.hawkular.agent.monitor.extension.SubsystemExtension;
import org.hawkular.agent.monitor.service.MonitorService;
import org.hawkular.agent.wildfly.log.AgentLoggers;
import org.hawkular.agent.wildfly.log.MsgLogger;
import org.hawkular.agent.wildfly.util.WildflyCompatibilityUtils;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;

public class SubsystemAdd
extends WildflyCompatibilityUtils.AbstractAddStepHandler {
    private static final MsgLogger log = AgentLoggers.getLogger(SubsystemAdd.class);
    static final SubsystemAdd INSTANCE = new SubsystemAdd();

    private SubsystemAdd() {
        super(SubsystemAttributes.ATTRIBUTES);
    }

    @Override
    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        if (context.getRunningMode() == RunningMode.ADMIN_ONLY) {
            log.infoSubsystemDisabled();
            return;
        }
        PathAddress agentSubsystemAddress = null;
        PathAddress currentAddress = WildflyCompatibilityUtils.getCurrentAddress(context, operation);
        while (currentAddress.size() > 0 && agentSubsystemAddress == null) {
            if ("subsystem".equals(currentAddress.getLastElement().getKey()) && "hawkular-wildfly-agent".equals(currentAddress.getLastElement().getValue())) {
                agentSubsystemAddress = currentAddress;
                continue;
            }
            currentAddress = currentAddress.getParent();
        }
        if (agentSubsystemAddress == null) {
            throw new OperationFailedException("Cannot get agent subsystem address from: " + WildflyCompatibilityUtils.getCurrentAddress(context, operation));
        }
        ModelNode subsystemConfig = Resource.Tools.readModel((Resource)context.readResourceFromRoot(agentSubsystemAddress));
        AgentCoreEngineConfiguration config = new MonitorServiceConfigurationBuilder(subsystemConfig, context).build();
        if (!config.getGlobalConfiguration().isSubsystemEnabled()) {
            log.infoSubsystemDisabled();
            return;
        }
        this.createService(context.getServiceTarget(), config, context.getProcessType());
    }

    private void createService(ServiceTarget target, AgentCoreEngineConfiguration configuration, ProcessType processType) {
        MonitorService service = new MonitorService(configuration, processType);
        ServiceBuilder svcBuilder = target.addService(SubsystemExtension.SERVICE_NAME, (Service)service);
        svcBuilder.setInitialMode(ServiceController.Mode.ACTIVE);
        service.addDependencies(target, (ServiceBuilder<MonitorService>)svcBuilder);
        svcBuilder.install();
    }
}

