/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.protocol.platform;

import java.util.List;
import org.hawkular.agent.monitor.protocol.LocationResolver;
import org.hawkular.agent.monitor.protocol.ProtocolException;
import org.hawkular.agent.monitor.protocol.platform.PlatformNodeLocation;
import org.hawkular.agent.monitor.protocol.platform.PlatformPath;

public class PlatformLocationResolver
implements LocationResolver<PlatformNodeLocation> {
    @Override
    public String findWildcardMatch(PlatformNodeLocation multiTargetLocation, PlatformNodeLocation singleLocation) throws ProtocolException {
        List<PlatformPath.PathSegment> multiTargetPaths = multiTargetLocation.getPlatformPath().getSegments();
        for (int i = 0; i < multiTargetPaths.size(); ++i) {
            PlatformPath.PathSegment singleLocationPathElement;
            PlatformPath.PathSegment multiTargetPathElement = multiTargetPaths.get(i);
            if (!"*".equals(multiTargetPathElement.getName())) continue;
            try {
                singleLocationPathElement = singleLocation.getPlatformPath().getSegments().get(i);
            }
            catch (Exception e) {
                throw new ProtocolException(String.format("[%s] doesn't have the same path size as [%s]", singleLocation, multiTargetLocation));
            }
            if (singleLocationPathElement.getType().equals((Object)multiTargetPathElement.getType())) {
                return singleLocationPathElement.getName();
            }
            throw new ProtocolException(String.format("[%s] doesn't match the multi-target key in [%s]", singleLocation, multiTargetLocation));
        }
        throw new ProtocolException(String.format("[%s] doesn't match the wildcard from [%s]", singleLocation, multiTargetLocation));
    }

    @Override
    public boolean isMultiTarget(PlatformNodeLocation location) {
        for (PlatformPath.PathSegment segment : location.getPlatformPath().getSegments()) {
            if (!"*".equals(segment.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public PlatformNodeLocation absolutize(PlatformNodeLocation base, PlatformNodeLocation location) {
        if (base == null || base.getPlatformPath().equals(PlatformPath.empty())) {
            return location;
        }
        PlatformPath path = location.getPlatformPath();
        if (path.equals(PlatformPath.empty())) {
            return base;
        }
        PlatformPath absPath = PlatformPath.builder().segments(base.getPlatformPath()).segments(path).build();
        return new PlatformNodeLocation(absPath);
    }

    @Override
    public boolean isParent(PlatformNodeLocation parent, PlatformNodeLocation child) {
        return parent.getPlatformPath().isParentOf(child.getPlatformPath());
    }

    @Override
    public boolean matches(PlatformNodeLocation query, PlatformNodeLocation location) {
        return query.getPlatformPath().apply(query.getPlatformPath());
    }

    @Override
    public String applyTemplate(String nameTemplate, PlatformNodeLocation location, String endpointName) {
        String name = location.getPlatformPath().getLastSegment().getName();
        return String.format(nameTemplate, name);
    }
}

