/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.scheduler;

import java.util.Set;
import org.hawkular.agent.monitor.api.SamplingService;
import org.hawkular.agent.monitor.inventory.AvailType;
import org.hawkular.agent.monitor.log.AgentLoggers;
import org.hawkular.agent.monitor.log.MsgLogger;
import org.hawkular.agent.monitor.scheduler.MeasurementCollector;
import org.hawkular.agent.monitor.scheduler.ScheduledCollectionsQueue;
import org.hawkular.agent.monitor.storage.AvailDataPoint;
import org.hawkular.agent.monitor.util.Consumer;

class AvailsCollector<L>
extends MeasurementCollector<L, AvailType<L>, AvailDataPoint>
implements Runnable {
    static final MsgLogger LOG = AgentLoggers.getLogger(AvailsCollector.class);

    public AvailsCollector(SamplingService<L> endpointService, ScheduledCollectionsQueue<L, AvailType<L>> priorityQueue, Consumer<AvailDataPoint> completionHandler) {
        super(endpointService, priorityQueue, completionHandler);
    }

    @Override
    public void run() {
        while (!Thread.interrupted()) {
            try {
                ScheduledCollectionsQueue queue = this.getScheduledCollectionsQueue();
                long next = queue.getNextExpectedCollectionTime();
                if (next == Long.MIN_VALUE) {
                    Thread.sleep(10000L);
                    continue;
                }
                long delay = next - System.currentTimeMillis();
                if (delay <= 0L) {
                    Set instances = queue.popNextScheduledSet();
                    this.getEndpointService().measureAvails(instances, new Consumer<AvailDataPoint>(){

                        @Override
                        public void accept(AvailDataPoint dataPoint) {
                            AvailsCollector.this.getCompletionHandler().accept(dataPoint);
                        }

                        @Override
                        public void report(Throwable e) {
                            LOG.errorFailedToStoreAvails(AvailsCollector.this.getEndpointService().toString(), e);
                            AvailsCollector.this.getCompletionHandler().report(e);
                        }
                    });
                    continue;
                }
                Thread.sleep(delay);
            }
            catch (InterruptedException ie) {
                return;
            }
            catch (IllegalStateException ise) {
                LOG.debugf("Cannot check avails for endpoint [%s] - not ready yet: %s", this.getEndpointService(), ise);
            }
            catch (Throwable t) {
                LOG.warnf(t, "Unexpected error caught in AvailsCollector for endpoint [%s]", this.getEndpointService());
            }
        }
    }
}

