/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.ServiceLoader;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ClusteringConfigurationBuilder;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.GroupsConfigurationBuilder;
import org.infinispan.configuration.cache.HashConfiguration;
import org.infinispan.configuration.cache.L1Configuration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.distribution.group.Grouper;
import org.jboss.as.clustering.dmr.ModelNodes;
import org.jboss.as.clustering.infinispan.subsystem.ConsistentHashStrategy;
import org.jboss.as.clustering.infinispan.subsystem.DistributedCacheResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.SharedStateCacheBuilder;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.clustering.infinispan.spi.service.CacheContainerServiceName;
import org.wildfly.clustering.service.Builder;

public class DistributedCacheBuilder
extends SharedStateCacheBuilder {
    private final InjectedValue<GlobalConfiguration> container = new InjectedValue();
    private final String containerName;
    private volatile HashConfiguration hash;
    private volatile L1Configuration l1;
    private volatile ConsistentHashStrategy consistentHashStrategy;

    DistributedCacheBuilder(String containerName, String cacheName) {
        super(containerName, cacheName, CacheMode.DIST_SYNC);
        this.containerName = containerName;
    }

    @Override
    public ServiceBuilder<Configuration> build(ServiceTarget target) {
        return super.build(target).addDependency(CacheContainerServiceName.CONFIGURATION.getServiceName(this.containerName), GlobalConfiguration.class, this.container);
    }

    @Override
    public Builder<Configuration> configure(OperationContext context, ModelNode model) throws OperationFailedException {
        this.consistentHashStrategy = (ConsistentHashStrategy)ModelNodes.asEnum((ModelNode)DistributedCacheResourceDefinition.Attribute.CONSISTENT_HASH_STRATEGY.getDefinition().resolveModelAttribute(context, model), ConsistentHashStrategy.class);
        ClusteringConfigurationBuilder builder = new ConfigurationBuilder().clustering();
        this.hash = builder.hash().capacityFactor((float)DistributedCacheResourceDefinition.Attribute.CAPACITY_FACTOR.getDefinition().resolveModelAttribute(context, model).asInt()).numOwners(DistributedCacheResourceDefinition.Attribute.OWNERS.getDefinition().resolveModelAttribute(context, model).asInt()).numSegments(DistributedCacheResourceDefinition.Attribute.SEGMENTS.getDefinition().resolveModelAttribute(context, model).asInt()).create();
        long l1Lifespan = DistributedCacheResourceDefinition.Attribute.L1_LIFESPAN.getDefinition().resolveModelAttribute(context, model).asLong();
        this.l1 = builder.l1().enabled(l1Lifespan > 0L).lifespan(l1Lifespan).create();
        return super.configure(context, model);
    }

    @Override
    public ConfigurationBuilder createConfigurationBuilder() {
        ConfigurationBuilder builder = super.createConfigurationBuilder();
        GroupsConfigurationBuilder groupsBuilder = builder.clustering().l1().read(this.l1).hash().read(this.hash).consistentHashFactory(this.consistentHashStrategy.createConsistentHashFactory(((GlobalConfiguration)this.container.getValue()).transport().hasTopologyInfo())).groups().enabled();
        for (Grouper grouper : ServiceLoader.load(Grouper.class, this.getClassLoader())) {
            groupsBuilder.addGrouper(grouper);
        }
        return builder;
    }
}

