/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.remoting.impl.invm.InVMAcceptorFactory;
import org.apache.activemq.artemis.core.remoting.impl.invm.InVMConnectorFactory;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyAcceptorFactory;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyConnectorFactory;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.wildfly.extension.messaging.activemq.CommonAttributes;
import org.wildfly.extension.messaging.activemq.GenericTransportDefinition;
import org.wildfly.extension.messaging.activemq.HTTPConnectorDefinition;
import org.wildfly.extension.messaging.activemq.InVMTransportDefinition;
import org.wildfly.extension.messaging.activemq.RemoteTransportDefinition;

public class TransportConfigOperationHandlers {
    private static final Map<String, String> CONNECTORS_KEYS_MAP = new HashMap<String, String>();
    private static final Map<String, String> ACCEPTOR_KEYS_MAP = new HashMap<String, String>();
    private static final String BATCH_DELAY = "batch-delay";
    private static final String HTTP_UPGRADE_ENABLED = "http-upgrade-enabled";
    private static final String KEY_STORE_PASSWORD = "key-store-password";
    private static final String KEY_STORE_PATH = "key-store-path";
    private static final String KEY_STORE_PROVIDER = "key-store-provider";
    private static final String TCP_RECEIVE_BUFFER_SIZE = "tcp-receive-buffer-size";
    private static final String TCP_SEND_BUFFER_SIZE = "tcp-send-buffer-size";
    private static final String TRUST_STORE_PASSWORD = "trust-store-password";
    private static final String TRUST_STORE_PATH = "trust-store-path";
    private static final String TRUST_STORE_PROVIDER = "trust-store-provider";
    private static final String ENABLED_PROTOCOLS = "enabled-protocols";
    private static final String ENABLED_CIPHER_SUITES = "enabled-cipher-suites";
    private static final String HOST = "host";
    private static final String PORT = "port";
    public static final String SSL_ENABLED = "ssl-enabled";
    public static final String USE_NIO = "use-nio";
    public static final String TCP_NO_DELAY = "tcp-no-delay";

    static void processAcceptors(OperationContext context, Configuration configuration, ModelNode params, Set<String> bindings) throws OperationFailedException {
        Map<String, Object> parameters;
        ModelNode config;
        String acceptorName;
        HashMap<String, TransportConfiguration> acceptors = new HashMap<String, TransportConfiguration>();
        if (params.hasDefined("acceptor")) {
            for (Property property : params.get("acceptor").asPropertyList()) {
                acceptorName = property.getName();
                config = property.getValue();
                parameters = TransportConfigOperationHandlers.getParameters(context, config, ACCEPTOR_KEYS_MAP);
                String clazz = config.get(CommonAttributes.FACTORY_CLASS.getName()).asString();
                ModelNode socketBinding = GenericTransportDefinition.SOCKET_BINDING.resolveModelAttribute(context, config);
                if (socketBinding.isDefined()) {
                    bindings.add(socketBinding.asString());
                    parameters.put(GenericTransportDefinition.SOCKET_BINDING.getName(), socketBinding.asString());
                }
                acceptors.put(acceptorName, new TransportConfiguration(clazz, parameters, acceptorName));
            }
        }
        if (params.hasDefined("remote-acceptor")) {
            for (Property property : params.get("remote-acceptor").asPropertyList()) {
                acceptorName = property.getName();
                config = property.getValue();
                parameters = TransportConfigOperationHandlers.getParameters(context, config, ACCEPTOR_KEYS_MAP);
                String binding = config.get(RemoteTransportDefinition.SOCKET_BINDING.getName()).asString();
                bindings.add(binding);
                parameters.put(RemoteTransportDefinition.SOCKET_BINDING.getName(), binding);
                acceptors.put(acceptorName, new TransportConfiguration(NettyAcceptorFactory.class.getName(), parameters, acceptorName));
            }
        }
        if (params.hasDefined("in-vm-acceptor")) {
            for (Property property : params.get("in-vm-acceptor").asPropertyList()) {
                acceptorName = property.getName();
                config = property.getValue();
                parameters = TransportConfigOperationHandlers.getParameters(context, config, ACCEPTOR_KEYS_MAP);
                parameters.put("serverId", InVMTransportDefinition.SERVER_ID.resolveModelAttribute(context, config).asInt());
                acceptors.put(acceptorName, new TransportConfiguration(InVMAcceptorFactory.class.getName(), parameters, acceptorName));
            }
        }
        if (params.hasDefined("http-acceptor")) {
            for (Property property : params.get("http-acceptor").asPropertyList()) {
                acceptorName = property.getName();
                config = property.getValue();
                parameters = TransportConfigOperationHandlers.getParameters(context, config, ACCEPTOR_KEYS_MAP);
                parameters.put("httpUpgradeEnabled", true);
                acceptors.put(acceptorName, new TransportConfiguration(NettyAcceptorFactory.class.getName(), parameters, acceptorName));
            }
        }
        configuration.setAcceptorConfigurations(new HashSet(acceptors.values()));
    }

    public static Map<String, Object> getParameters(OperationContext context, ModelNode config, Map<String, String> mapping) throws OperationFailedException {
        Map fromModel = CommonAttributes.PARAMS.unwrap((ExpressionResolver)context, config);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        for (Map.Entry entry : fromModel.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            parameters.put(mapping.getOrDefault(key, key), value);
        }
        return parameters;
    }

    static void processConnectors(OperationContext context, Configuration configuration, ModelNode params, Set<String> bindings) throws OperationFailedException {
        String binding;
        Map<String, Object> parameters;
        ModelNode config;
        String connectorName;
        HashMap<String, TransportConfiguration> connectors = new HashMap<String, TransportConfiguration>();
        if (params.hasDefined("connector")) {
            for (Property property : params.get("connector").asPropertyList()) {
                connectorName = property.getName();
                config = property.getValue();
                parameters = TransportConfigOperationHandlers.getParameters(context, config, CONNECTORS_KEYS_MAP);
                ModelNode socketBinding = GenericTransportDefinition.SOCKET_BINDING.resolveModelAttribute(context, config);
                if (socketBinding.isDefined()) {
                    bindings.add(socketBinding.asString());
                    parameters.put(GenericTransportDefinition.SOCKET_BINDING.getName(), socketBinding.asString());
                }
                String clazz = CommonAttributes.FACTORY_CLASS.resolveModelAttribute(context, config).asString();
                connectors.put(connectorName, new TransportConfiguration(clazz, parameters, connectorName));
            }
        }
        if (params.hasDefined("remote-connector")) {
            for (Property property : params.get("remote-connector").asPropertyList()) {
                connectorName = property.getName();
                config = property.getValue();
                parameters = TransportConfigOperationHandlers.getParameters(context, config, CONNECTORS_KEYS_MAP);
                binding = config.get(RemoteTransportDefinition.SOCKET_BINDING.getName()).asString();
                bindings.add(binding);
                parameters.put(RemoteTransportDefinition.SOCKET_BINDING.getName(), binding);
                connectors.put(connectorName, new TransportConfiguration(NettyConnectorFactory.class.getName(), parameters, connectorName));
            }
        }
        if (params.hasDefined("in-vm-connector")) {
            for (Property property : params.get("in-vm-connector").asPropertyList()) {
                connectorName = property.getName();
                config = property.getValue();
                parameters = TransportConfigOperationHandlers.getParameters(context, config, CONNECTORS_KEYS_MAP);
                parameters.put(CONNECTORS_KEYS_MAP.get(InVMTransportDefinition.SERVER_ID.getName()), InVMTransportDefinition.SERVER_ID.resolveModelAttribute(context, config).asInt());
                connectors.put(connectorName, new TransportConfiguration(InVMConnectorFactory.class.getName(), parameters, connectorName));
            }
        }
        if (params.hasDefined("http-connector")) {
            for (Property property : params.get("http-connector").asPropertyList()) {
                connectorName = property.getName();
                config = property.getValue();
                parameters = TransportConfigOperationHandlers.getParameters(context, config, CONNECTORS_KEYS_MAP);
                binding = HTTPConnectorDefinition.SOCKET_BINDING.resolveModelAttribute(context, config).asString();
                bindings.add(binding);
                parameters.put("httpUpgradeEnabled", true);
                parameters.put("httpPpgradeEndpoint", HTTPConnectorDefinition.ENDPOINT.resolveModelAttribute(context, config).asString());
                parameters.put(HTTPConnectorDefinition.SOCKET_BINDING.getName(), binding);
                connectors.put(connectorName, new TransportConfiguration(NettyConnectorFactory.class.getName(), parameters, connectorName));
            }
        }
        configuration.setConnectorConfigurations(connectors);
    }

    static {
        CONNECTORS_KEYS_MAP.put(InVMTransportDefinition.SERVER_ID.getName(), "serverId");
        CONNECTORS_KEYS_MAP.put(SSL_ENABLED, "sslEnabled");
        CONNECTORS_KEYS_MAP.put("http-enabled", "httpEnabled");
        CONNECTORS_KEYS_MAP.put("http-client-idle-time", "httpClientIdleTime");
        CONNECTORS_KEYS_MAP.put("http-client-idle-scan-period", "httpClientIdleScanPeriod");
        CONNECTORS_KEYS_MAP.put("http-requires-session-id", "httpRequiresSessionId");
        CONNECTORS_KEYS_MAP.put(HTTP_UPGRADE_ENABLED, "httpUpgradeEnabled");
        CONNECTORS_KEYS_MAP.put("http-upgrade-endpoint", "httpPpgradeEndpoint");
        CONNECTORS_KEYS_MAP.put("use-servlet", "useServlet");
        CONNECTORS_KEYS_MAP.put("servlet-path", "servletPath");
        CONNECTORS_KEYS_MAP.put(USE_NIO, "useNio");
        CONNECTORS_KEYS_MAP.put("use-nio-global-worker-pool", "useNioGlobalWorkerPool");
        CONNECTORS_KEYS_MAP.put(HOST, HOST);
        CONNECTORS_KEYS_MAP.put(PORT, PORT);
        CONNECTORS_KEYS_MAP.put("local-address", "localAddress");
        CONNECTORS_KEYS_MAP.put("local-port", "localPort");
        CONNECTORS_KEYS_MAP.put(KEY_STORE_PROVIDER, "keyStoreProvider");
        CONNECTORS_KEYS_MAP.put(KEY_STORE_PATH, "keyStorePath");
        CONNECTORS_KEYS_MAP.put(KEY_STORE_PASSWORD, "keyStorePassword");
        CONNECTORS_KEYS_MAP.put(TRUST_STORE_PROVIDER, "trustStoreProvider");
        CONNECTORS_KEYS_MAP.put(TRUST_STORE_PATH, "trustStorePath");
        CONNECTORS_KEYS_MAP.put(TRUST_STORE_PASSWORD, "trustStorePassword");
        CONNECTORS_KEYS_MAP.put(ENABLED_CIPHER_SUITES, "enabledCipherSuites");
        CONNECTORS_KEYS_MAP.put(ENABLED_PROTOCOLS, "enabledProtocols");
        CONNECTORS_KEYS_MAP.put(TCP_NO_DELAY, "tcpNoDelay");
        CONNECTORS_KEYS_MAP.put(TCP_SEND_BUFFER_SIZE, "tcpSendBufferSize");
        CONNECTORS_KEYS_MAP.put(TCP_RECEIVE_BUFFER_SIZE, "tcpReceiveBufferSize");
        CONNECTORS_KEYS_MAP.put("nio-remoting-threads", "nioRemotingThreads");
        CONNECTORS_KEYS_MAP.put(BATCH_DELAY, "batchDelay");
        CONNECTORS_KEYS_MAP.put("connect-timeout-millis", "connect-timeout-millis");
        ACCEPTOR_KEYS_MAP.put(InVMTransportDefinition.SERVER_ID.getName(), "serverId");
        ACCEPTOR_KEYS_MAP.put(BATCH_DELAY, "batchDelay");
        ACCEPTOR_KEYS_MAP.put("cluster-connection", "clusterConnection");
        ACCEPTOR_KEYS_MAP.put("connection-ttl", "connectionTtl");
        ACCEPTOR_KEYS_MAP.put("connections-allowed", "connectionsAllowed");
        ACCEPTOR_KEYS_MAP.put("direct-deliver", "directDeliver");
        ACCEPTOR_KEYS_MAP.put(ENABLED_CIPHER_SUITES, "enabledCipherSuites");
        ACCEPTOR_KEYS_MAP.put(ENABLED_PROTOCOLS, "enabledProtocols");
        ACCEPTOR_KEYS_MAP.put(HOST, HOST);
        ACCEPTOR_KEYS_MAP.put("http-response-time", "httpResponseTime");
        ACCEPTOR_KEYS_MAP.put("http-server-scan-period", "httpServerScanPeriod");
        ACCEPTOR_KEYS_MAP.put(HTTP_UPGRADE_ENABLED, "httpUpgradeEnabled");
        ACCEPTOR_KEYS_MAP.put(KEY_STORE_PASSWORD, "keyStorePassword");
        ACCEPTOR_KEYS_MAP.put(KEY_STORE_PATH, "keyStorePath");
        ACCEPTOR_KEYS_MAP.put(KEY_STORE_PROVIDER, "keyStoreProvider");
        ACCEPTOR_KEYS_MAP.put("needs-client-auth", "needClientAuth");
        ACCEPTOR_KEYS_MAP.put("nio-remoting-threads", "nioRemotingThreads");
        ACCEPTOR_KEYS_MAP.put(PORT, PORT);
        ACCEPTOR_KEYS_MAP.put("protocols", "protocols");
        ACCEPTOR_KEYS_MAP.put(SSL_ENABLED, "sslEnabled");
        ACCEPTOR_KEYS_MAP.put("stomp-enable-message-id", "stomp-enable-message-id");
        ACCEPTOR_KEYS_MAP.put("stomp-min-large-message-size", "stomp-min-large-message-size");
        ACCEPTOR_KEYS_MAP.put("stomp-consumer-credits", "stompConsumerCredits");
        ACCEPTOR_KEYS_MAP.put(TCP_NO_DELAY, "tcpNoDelay");
        ACCEPTOR_KEYS_MAP.put(TCP_RECEIVE_BUFFER_SIZE, "tcpReceiveBufferSize");
        ACCEPTOR_KEYS_MAP.put(TCP_SEND_BUFFER_SIZE, "tcpSendBufferSize");
        ACCEPTOR_KEYS_MAP.put(TRUST_STORE_PASSWORD, "trustStorePassword");
        ACCEPTOR_KEYS_MAP.put(TRUST_STORE_PATH, "trustStorePath");
        ACCEPTOR_KEYS_MAP.put(TRUST_STORE_PROVIDER, "trustStoreProvider");
        ACCEPTOR_KEYS_MAP.put("use-invm", "useInvm");
        ACCEPTOR_KEYS_MAP.put(USE_NIO, "useNio");
    }
}

