/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cache.impl;

import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.infinispan.AdvancedCache;
import org.infinispan.CacheCollection;
import org.infinispan.CacheSet;
import org.infinispan.cache.impl.AbstractDelegatingAdvancedCache;
import org.infinispan.cache.impl.CacheImpl;
import org.infinispan.commons.util.concurrent.NotifyingFuture;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.filter.KeyFilter;
import org.infinispan.filter.KeyValueFilter;
import org.infinispan.iteration.EntryIterable;
import org.infinispan.iteration.impl.EntryIterableFromStreamImpl;
import org.infinispan.metadata.EmbeddedMetadata;
import org.infinispan.metadata.Metadata;
import org.infinispan.stream.StreamMarshalling;
import org.infinispan.stream.impl.local.ValueCacheCollection;

public class DecoratedCache<K, V>
extends AbstractDelegatingAdvancedCache<K, V> {
    private final EnumSet<Flag> flags;
    private final WeakReference<ClassLoader> classLoader;
    private final CacheImpl<K, V> cacheImplementation;

    public DecoratedCache(AdvancedCache<K, V> delegate, ClassLoader classLoader) {
        this(delegate, classLoader, null);
    }

    public DecoratedCache(AdvancedCache<K, V> delegate, Flag ... flags) {
        this(delegate, (ClassLoader)null, flags);
    }

    public DecoratedCache(AdvancedCache<K, V> delegate, ClassLoader classLoader, Flag ... flags) {
        super(delegate);
        if (flags == null || flags.length == 0) {
            this.flags = null;
        } else {
            this.flags = EnumSet.noneOf(Flag.class);
            for (Flag flag : flags) {
                this.flags.add(flag);
            }
        }
        this.classLoader = new WeakReference<ClassLoader>(classLoader);
        if (flags == null && classLoader == null) {
            throw new IllegalArgumentException("There is no point in using a DecoratedCache if neither a ClassLoader nor any Flags are set.");
        }
        this.cacheImplementation = (CacheImpl)delegate;
    }

    private DecoratedCache(CacheImpl<K, V> delegate, ClassLoader classLoader, EnumSet<Flag> newFlags) {
        super(delegate);
        this.flags = newFlags;
        this.classLoader = new WeakReference<ClassLoader>(classLoader);
        this.cacheImplementation = delegate;
    }

    @Override
    public AdvancedCache<K, V> with(ClassLoader classLoader) {
        if (classLoader == null) {
            throw new IllegalArgumentException("ClassLoader cannot be null!");
        }
        return new DecoratedCache<K, V>(this.cacheImplementation, classLoader, this.flags);
    }

    @Override
    public AdvancedCache<K, V> withFlags(Flag ... flags) {
        boolean containsAll;
        if (flags == null || flags.length == 0) {
            return this;
        }
        if (this.flags != null) {
            containsAll = true;
            for (Flag flag : flags) {
                if (this.flags.contains((Object)flag)) continue;
                containsAll = false;
            }
        } else {
            containsAll = false;
        }
        if (containsAll) {
            return this;
        }
        EnumSet<Flag> newFlags = this.flags != null ? EnumSet.copyOf(this.flags) : EnumSet.noneOf(Flag.class);
        Collections.addAll(newFlags, flags);
        return new DecoratedCache<K, V>(this.cacheImplementation, (ClassLoader)this.classLoader.get(), newFlags);
    }

    @Override
    public ClassLoader getClassLoader() {
        if (this.classLoader == null) {
            return this.cacheImplementation.getClassLoader();
        }
        return (ClassLoader)this.classLoader.get();
    }

    @Override
    public void stop() {
        this.cacheImplementation.stop((ClassLoader)this.classLoader.get());
    }

    @Override
    public boolean lock(K ... keys) {
        return this.cacheImplementation.lock((Collection<K>)Arrays.asList(keys), this.flags, (ClassLoader)this.classLoader.get());
    }

    @Override
    public boolean lock(Collection<? extends K> keys) {
        return this.cacheImplementation.lock(keys, this.flags, (ClassLoader)this.classLoader.get());
    }

    @Override
    public void putForExternalRead(K key, V value) {
        this.cacheImplementation.putForExternalRead(key, value, this.flags, (ClassLoader)this.classLoader.get());
    }

    @Override
    public void putForExternalRead(K key, V value, Metadata metadata) {
        this.cacheImplementation.putForExternalRead(key, value, this.flags, (ClassLoader)this.classLoader.get());
    }

    @Override
    public void putForExternalRead(K key, V value, long lifespan, TimeUnit unit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, unit).maxIdle(this.cacheImplementation.defaultMetadata.maxIdle(), TimeUnit.MILLISECONDS).build();
        this.cacheImplementation.putForExternalRead(key, value, metadata, this.flags, (ClassLoader)this.classLoader.get());
    }

    @Override
    public void putForExternalRead(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdle, maxIdleUnit).build();
        this.cacheImplementation.putForExternalRead(key, value, metadata, this.flags, (ClassLoader)this.classLoader.get());
    }

    @Override
    public void evict(K key) {
        this.cacheImplementation.evict(key, this.flags, (ClassLoader)this.classLoader.get());
    }

    @Override
    public V put(K key, V value, long lifespan, TimeUnit unit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, unit).maxIdle(this.cacheImplementation.defaultMetadata.maxIdle(), TimeUnit.MILLISECONDS).build();
        return this.cacheImplementation.put(key, value, metadata, this.flags, (ClassLoader)this.classLoader.get());
    }

    @Override
    public V putIfAbsent(K key, V value, long lifespan, TimeUnit unit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, unit).maxIdle(this.cacheImplementation.defaultMetadata.maxIdle(), TimeUnit.MILLISECONDS).build();
        return this.cacheImplementation.putIfAbsent(key, value, metadata, this.flags, (ClassLoader)this.classLoader.get());
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map, long lifespan, TimeUnit unit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, unit).maxIdle(this.cacheImplementation.defaultMetadata.maxIdle(), TimeUnit.MILLISECONDS).build();
        this.cacheImplementation.putAll(map, metadata, this.flags, (ClassLoader)this.classLoader.get());
    }

    @Override
    public V replace(K key, V value, long lifespan, TimeUnit unit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, unit).maxIdle(this.cacheImplementation.defaultMetadata.maxIdle(), TimeUnit.MILLISECONDS).build();
        return this.cacheImplementation.replace(key, value, metadata, this.flags, (ClassLoader)this.classLoader.get());
    }

    @Override
    public boolean replace(K key, V oldValue, V value, long lifespan, TimeUnit unit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, unit).maxIdle(this.cacheImplementation.defaultMetadata.maxIdle(), TimeUnit.MILLISECONDS).build();
        return this.cacheImplementation.replace(key, oldValue, value, metadata, this.flags, (ClassLoader)this.classLoader.get());
    }

    @Override
    public V put(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdleTime, maxIdleTimeUnit).build();
        return this.cacheImplementation.put(key, value, metadata, this.flags, (ClassLoader)this.classLoader.get());
    }

    @Override
    public V putIfAbsent(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdleTime, maxIdleTimeUnit).build();
        return this.cacheImplementation.putIfAbsent(key, value, metadata, this.flags, (ClassLoader)this.classLoader.get());
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdleTime, maxIdleTimeUnit).build();
        this.cacheImplementation.putAll(map, metadata, this.flags, (ClassLoader)this.classLoader.get());
    }

    @Override
    public V replace(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdleTime, maxIdleTimeUnit).build();
        return this.cacheImplementation.replace(key, value, metadata, this.flags, (ClassLoader)this.classLoader.get());
    }

    @Override
    public boolean replace(K key, V oldValue, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdleTime, maxIdleTimeUnit).build();
        return this.cacheImplementation.replace(key, oldValue, value, metadata, this.flags, (ClassLoader)this.classLoader.get());
    }

    @Override
    public NotifyingFuture<V> putAsync(K key, V value) {
        return this.cacheImplementation.putAsync(key, value, this.cacheImplementation.defaultMetadata, this.flags, (ClassLoader)this.classLoader.get());
    }

    @Override
    public NotifyingFuture<V> putAsync(K key, V value, long lifespan, TimeUnit unit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, unit).maxIdle(this.cacheImplementation.defaultMetadata.maxIdle(), TimeUnit.MILLISECONDS).build();
        return this.cacheImplementation.putAsync(key, value, metadata, this.flags, (ClassLoader)this.classLoader.get());
    }

    @Override
    public NotifyingFuture<V> putAsync(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdle, maxIdleUnit).build();
        return this.cacheImplementation.putAsync(key, value, metadata, this.flags, (ClassLoader)this.classLoader.get());
    }

    @Override
    public NotifyingFuture<Void> putAllAsync(Map<? extends K, ? extends V> data) {
        return this.cacheImplementation.putAllAsync(data, this.cacheImplementation.defaultMetadata, this.flags, (ClassLoader)this.classLoader.get());
    }

    @Override
    public NotifyingFuture<Void> putAllAsync(Map<? extends K, ? extends V> data, long lifespan, TimeUnit unit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, unit).maxIdle(this.cacheImplementation.defaultMetadata.maxIdle(), TimeUnit.MILLISECONDS).build();
        return this.cacheImplementation.putAllAsync(data, metadata, this.flags, (ClassLoader)this.classLoader.get());
    }

    @Override
    public NotifyingFuture<Void> putAllAsync(Map<? extends K, ? extends V> data, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdle, maxIdleUnit).build();
        return this.cacheImplementation.putAllAsync(data, metadata, this.flags, (ClassLoader)this.classLoader.get());
    }

    @Override
    public NotifyingFuture<Void> clearAsync() {
        return this.cacheImplementation.clearAsync(this.flags, (ClassLoader)this.classLoader.get());
    }

    @Override
    public NotifyingFuture<V> putIfAbsentAsync(K key, V value) {
        return this.cacheImplementation.putIfAbsentAsync(key, value, this.cacheImplementation.defaultMetadata, this.flags, (ClassLoader)this.classLoader.get());
    }

    @Override
    public NotifyingFuture<V> putIfAbsentAsync(K key, V value, long lifespan, TimeUnit unit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, unit).maxIdle(this.cacheImplementation.defaultMetadata.maxIdle(), TimeUnit.MILLISECONDS).build();
        return this.cacheImplementation.putIfAbsentAsync(key, value, metadata, this.flags, (ClassLoader)this.classLoader.get());
    }

    @Override
    public NotifyingFuture<V> putIfAbsentAsync(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdle, maxIdleUnit).build();
        return this.cacheImplementation.putIfAbsentAsync(key, value, metadata, this.flags, (ClassLoader)this.classLoader.get());
    }

    @Override
    public NotifyingFuture<V> removeAsync(Object key) {
        return this.cacheImplementation.removeAsync(key, this.flags, (ClassLoader)this.classLoader.get());
    }

    @Override
    public NotifyingFuture<Boolean> removeAsync(Object key, Object value) {
        return this.cacheImplementation.removeAsync(key, value, this.flags, (ClassLoader)this.classLoader.get());
    }

    @Override
    public NotifyingFuture<V> replaceAsync(K key, V value) {
        return this.cacheImplementation.replaceAsync(key, value, this.cacheImplementation.defaultMetadata, this.flags, (ClassLoader)this.classLoader.get());
    }

    @Override
    public NotifyingFuture<V> replaceAsync(K key, V value, long lifespan, TimeUnit unit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, unit).maxIdle(this.cacheImplementation.defaultMetadata.maxIdle(), TimeUnit.MILLISECONDS).build();
        return this.cacheImplementation.replaceAsync(key, value, metadata, this.flags, (ClassLoader)this.classLoader.get());
    }

    @Override
    public NotifyingFuture<V> replaceAsync(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdle, maxIdleUnit).build();
        return this.cacheImplementation.replaceAsync(key, value, metadata, this.flags, (ClassLoader)this.classLoader.get());
    }

    @Override
    public NotifyingFuture<Boolean> replaceAsync(K key, V oldValue, V newValue) {
        return this.cacheImplementation.replaceAsync(key, oldValue, newValue, this.cacheImplementation.defaultMetadata, this.flags, (ClassLoader)this.classLoader.get());
    }

    @Override
    public NotifyingFuture<Boolean> replaceAsync(K key, V oldValue, V newValue, long lifespan, TimeUnit unit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, unit).maxIdle(this.cacheImplementation.defaultMetadata.maxIdle(), TimeUnit.MILLISECONDS).build();
        return this.cacheImplementation.replaceAsync(key, oldValue, newValue, metadata, this.flags, (ClassLoader)this.classLoader.get());
    }

    @Override
    public NotifyingFuture<Boolean> replaceAsync(K key, V oldValue, V newValue, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdle, maxIdleUnit).build();
        return this.cacheImplementation.replaceAsync(key, oldValue, newValue, metadata, this.flags, (ClassLoader)this.classLoader.get());
    }

    @Override
    public NotifyingFuture<V> getAsync(K key) {
        return this.cacheImplementation.getAsync(key, this.flags, (ClassLoader)this.classLoader.get());
    }

    @Override
    public int size() {
        return this.cacheImplementation.size(this.flags, (ClassLoader)this.classLoader.get());
    }

    @Override
    public boolean isEmpty() {
        return this.cacheImplementation.isEmpty(this.flags, (ClassLoader)this.classLoader.get());
    }

    @Override
    public boolean containsKey(Object key) {
        return this.cacheImplementation.containsKey(key, this.flags, (ClassLoader)this.classLoader.get());
    }

    @Override
    public boolean containsValue(Object value) {
        Objects.nonNull(value);
        return this.values().stream().anyMatch(StreamMarshalling.equalityPredicate(value));
    }

    @Override
    public V get(Object key) {
        return this.cacheImplementation.get(key, this.flags, (ClassLoader)this.classLoader.get());
    }

    @Override
    public Map<K, V> getAll(Set<?> keys) {
        return this.cacheImplementation.getAll(keys, this.flags, (ClassLoader)this.classLoader.get());
    }

    @Override
    public V put(K key, V value) {
        return this.cacheImplementation.put(key, value, this.cacheImplementation.defaultMetadata, this.flags, (ClassLoader)this.classLoader.get());
    }

    @Override
    public V remove(Object key) {
        return this.cacheImplementation.remove(key, this.flags, (ClassLoader)this.classLoader.get());
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map, Metadata metadata) {
        this.cacheImplementation.putAll(map, metadata, this.flags, (ClassLoader)this.classLoader.get());
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.cacheImplementation.putAll(m, this.cacheImplementation.defaultMetadata, this.flags, (ClassLoader)this.classLoader.get());
    }

    @Override
    public void clear() {
        this.cacheImplementation.clear(this.flags, (ClassLoader)this.classLoader.get());
    }

    @Override
    public CacheSet<K> keySet() {
        return this.cacheImplementation.keySet(this.flags, (ClassLoader)this.classLoader.get());
    }

    @Override
    public Map<K, V> getGroup(String groupName) {
        return this.cacheImplementation.getGroup(groupName, this.flags, this.getClassLoader());
    }

    @Override
    public void removeGroup(String groupName) {
        this.cacheImplementation.removeGroup(groupName, this.flags, this.getClassLoader());
    }

    @Override
    public CacheCollection<V> values() {
        return new ValueCacheCollection<K, V>(this, this.cacheEntrySet());
    }

    @Override
    public CacheSet<Map.Entry<K, V>> entrySet() {
        return this.cacheImplementation.entrySet(this.flags, (ClassLoader)this.classLoader.get());
    }

    @Override
    public CacheSet<CacheEntry<K, V>> cacheEntrySet() {
        return this.cacheImplementation.cacheEntrySet(this.flags, (ClassLoader)this.classLoader.get());
    }

    @Override
    public V putIfAbsent(K key, V value) {
        return this.cacheImplementation.putIfAbsent(key, value, this.cacheImplementation.defaultMetadata, this.flags, (ClassLoader)this.classLoader.get());
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.cacheImplementation.remove(key, value, this.flags, (ClassLoader)this.classLoader.get());
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        return this.cacheImplementation.replace(key, oldValue, newValue, this.cacheImplementation.defaultMetadata, this.flags, (ClassLoader)this.classLoader.get());
    }

    @Override
    public V replace(K key, V value) {
        return this.cacheImplementation.replace(key, value, this.cacheImplementation.defaultMetadata, this.flags, (ClassLoader)this.classLoader.get());
    }

    public EnumSet<Flag> getFlags() {
        return this.flags;
    }

    @Override
    public void addListener(Object listener) {
        this.cacheImplementation.notifier.addListener(listener, (ClassLoader)this.classLoader.get());
    }

    @Override
    public void addListener(Object listener, KeyFilter<? super K> filter) {
        this.cacheImplementation.notifier.addListener(listener, filter, (ClassLoader)this.classLoader.get());
    }

    @Override
    public V put(K key, V value, Metadata metadata) {
        return this.cacheImplementation.put(key, value, metadata, this.flags, (ClassLoader)this.classLoader.get());
    }

    @Override
    public NotifyingFuture<V> putAsync(K key, V value, Metadata metadata) {
        return this.cacheImplementation.putAsync(key, value, metadata, this.flags, (ClassLoader)this.classLoader.get());
    }

    @Override
    public V putIfAbsent(K key, V value, Metadata metadata) {
        return this.cacheImplementation.putIfAbsent(key, value, metadata, this.flags, (ClassLoader)this.classLoader.get());
    }

    @Override
    public boolean replace(K key, V oldValue, V value, Metadata metadata) {
        return this.cacheImplementation.replace(key, oldValue, value, metadata, this.flags, (ClassLoader)this.classLoader.get());
    }

    @Override
    public V replace(K key, V value, Metadata metadata) {
        return this.cacheImplementation.replace(key, value, metadata, this.flags, (ClassLoader)this.classLoader.get());
    }

    @Override
    public CacheEntry getCacheEntry(Object key) {
        return this.cacheImplementation.getCacheEntry(key, this.flags, (ClassLoader)this.classLoader.get());
    }

    @Override
    public EntryIterable<K, V> filterEntries(KeyValueFilter<? super K, ? super V> filter) {
        return new EntryIterableFromStreamImpl<K, V>(filter, this.flags, this);
    }
}

