/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.topology;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.util.CollectionFactory;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.executors.SemaphoreCompletionService;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachemanagerlistener.CacheManagerNotifier;
import org.infinispan.notifications.cachemanagerlistener.annotation.Merged;
import org.infinispan.notifications.cachemanagerlistener.annotation.ViewChanged;
import org.infinispan.notifications.cachemanagerlistener.event.ViewChangedEvent;
import org.infinispan.partitionhandling.AvailabilityMode;
import org.infinispan.partitionhandling.impl.AvailabilityStrategy;
import org.infinispan.partitionhandling.impl.PreferAvailabilityStrategy;
import org.infinispan.partitionhandling.impl.PreferConsistencyStrategy;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.responses.ExceptionResponse;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.SuccessfulResponse;
import org.infinispan.remoting.rpc.ResponseFilter;
import org.infinispan.remoting.rpc.ResponseMode;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.remoting.transport.jgroups.SuspectException;
import org.infinispan.topology.CacheJoinInfo;
import org.infinispan.topology.CacheStatusResponse;
import org.infinispan.topology.CacheTopology;
import org.infinispan.topology.CacheTopologyControlCommand;
import org.infinispan.topology.ClusterCacheStatus;
import org.infinispan.topology.ClusterTopologyManager;
import org.infinispan.topology.ManagerStatusResponse;
import org.infinispan.topology.RebalancingStatus;
import org.infinispan.util.TimeService;
import org.infinispan.util.concurrent.TimeoutException;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class ClusterTopologyManagerImpl
implements ClusterTopologyManager {
    private static final Log log = LogFactory.getLog(ClusterTopologyManagerImpl.class);
    private static final boolean trace = log.isTraceEnabled();
    private Transport transport;
    private GlobalConfiguration globalConfiguration;
    private GlobalComponentRegistry gcr;
    private CacheManagerNotifier cacheManagerNotifier;
    private EmbeddedCacheManager cacheManager;
    private TimeService timeService;
    private ExecutorService asyncTransportExecutor;
    private volatile boolean isCoordinator;
    private volatile boolean isShuttingDown;
    private boolean mustRecoverClusterStatus;
    private final Object viewHandlingLock = new Object();
    private volatile int viewId = -1;
    private final Object viewUpdateLock = new Object();
    private final ConcurrentMap<String, ClusterCacheStatus> cacheStatusMap = CollectionFactory.makeConcurrentMap();
    private ClusterViewListener viewListener;
    private volatile boolean globalRebalancingEnabled = true;

    @Inject
    public void inject(Transport transport, @ComponentName(value="org.infinispan.executors.transport") ExecutorService asyncTransportExecutor, GlobalConfiguration globalConfiguration, GlobalComponentRegistry gcr, CacheManagerNotifier cacheManagerNotifier, EmbeddedCacheManager cacheManager, TimeService timeService) {
        this.transport = transport;
        this.asyncTransportExecutor = asyncTransportExecutor;
        this.globalConfiguration = globalConfiguration;
        this.gcr = gcr;
        this.cacheManagerNotifier = cacheManagerNotifier;
        this.cacheManager = cacheManager;
        this.timeService = timeService;
    }

    @Start(priority=100)
    public void start() {
        this.isShuttingDown = false;
        this.isCoordinator = this.transport.isCoordinator();
        this.viewListener = new ClusterViewListener();
        this.cacheManagerNotifier.addListener(this.viewListener);
        this.asyncTransportExecutor.submit(new Runnable(){

            @Override
            public void run() {
                ClusterTopologyManagerImpl.this.handleClusterView(false, ClusterTopologyManagerImpl.this.transport.getViewId());
            }
        });
        this.fetchRebalancingStatusFromCoordinator();
    }

    protected void fetchRebalancingStatusFromCoordinator() {
        if (!this.transport.isCoordinator()) {
            CacheTopologyControlCommand command = new CacheTopologyControlCommand(null, CacheTopologyControlCommand.Type.POLICY_GET_STATUS, this.transport.getAddress(), this.transport.getViewId());
            Address coordinator = this.transport.getCoordinator();
            try {
                Map<Address, Response> responseMap = this.transport.invokeRemotely(Collections.singleton(coordinator), command, ResponseMode.SYNCHRONOUS, this.getGlobalTimeout(), null, DeliverOrder.NONE, false);
                Response response = responseMap.get(coordinator);
                if (response instanceof SuccessfulResponse) {
                    this.globalRebalancingEnabled = (Boolean)((SuccessfulResponse)response).getResponseValue();
                } else {
                    log.errorReadingRebalancingStatus(coordinator, null);
                }
            }
            catch (Exception e) {
                log.errorReadingRebalancingStatus(coordinator, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Stop(priority=100)
    public void stop() {
        this.isShuttingDown = true;
        this.cacheManagerNotifier.removeListener(this.viewListener);
        Object object = this.viewUpdateLock;
        synchronized (object) {
            this.viewId = Integer.MAX_VALUE;
            this.viewUpdateLock.notifyAll();
        }
    }

    @Override
    public CacheStatusResponse handleJoin(String cacheName, Address joiner, CacheJoinInfo joinInfo, int viewId) throws Exception {
        this.waitForView(viewId, joinInfo.getTimeout());
        if (this.isShuttingDown) {
            log.debugf("Ignoring join request from %s for cache %s, the local cache manager is shutting down", joiner, cacheName);
            return null;
        }
        ClusterCacheStatus cacheStatus = this.initCacheStatusIfAbsent(cacheName);
        return cacheStatus.doJoin(joiner, joinInfo);
    }

    @Override
    public void handleLeave(String cacheName, Address leaver, int viewId) throws Exception {
        if (this.isShuttingDown) {
            log.debugf("Ignoring leave request from %s for cache %s, the local cache manager is shutting down", leaver, cacheName);
            return;
        }
        ClusterCacheStatus cacheStatus = (ClusterCacheStatus)this.cacheStatusMap.get(cacheName);
        if (cacheStatus == null) {
            log.tracef("Ignoring leave request from %s for cache %s because it doesn't have a cache status entry", leaver, cacheName);
            return;
        }
        cacheStatus.doLeave(leaver);
    }

    @Override
    public void handleRebalanceCompleted(String cacheName, Address node, int topologyId, Throwable throwable, int viewId) throws Exception {
        if (throwable != null) {
            log.rebalanceError(cacheName, node, throwable);
        }
        LogFactory.CLUSTER.rebalanceCompleted(cacheName, node, topologyId);
        ClusterCacheStatus cacheStatus = (ClusterCacheStatus)this.cacheStatusMap.get(cacheName);
        if (cacheStatus == null || !cacheStatus.isRebalanceInProgress()) {
            log.debugf("Ignoring rebalance confirmation from %s for cache %s because it doesn't have a cache status entry", node, cacheName);
            return;
        }
        cacheStatus.doConfirmRebalance(node, topologyId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleClusterView(boolean mergeView, int newViewId) {
        Object object = this.viewHandlingLock;
        synchronized (object) {
            if (newViewId <= this.viewId) {
                log.tracef("Ignoring old cluster view notification: %s", newViewId);
                return;
            }
            boolean becameCoordinator = !this.isCoordinator && this.transport.isCoordinator();
            this.isCoordinator = this.transport.isCoordinator();
            if (trace) {
                log.tracef("Received new cluster view: %d, isCoordinator = %s, becameCoordinator = %s", newViewId, this.isCoordinator, becameCoordinator);
            }
            this.mustRecoverClusterStatus |= mergeView || becameCoordinator;
            if (!this.isCoordinator) {
                return;
            }
            if (this.mustRecoverClusterStatus) {
                this.cacheStatusMap.clear();
                try {
                    this.recoverClusterStatus(newViewId, mergeView, this.transport.getMembers());
                    this.mustRecoverClusterStatus = false;
                }
                catch (InterruptedException e) {
                    log.tracef("Cluster state recovery interrupted because the coordinator is shutting down", new Object[0]);
                    return;
                }
                catch (SuspectException e) {
                    return;
                }
                catch (Exception e) {
                    if (!this.isShuttingDown) {
                        log.failedToRecoverClusterState(e);
                    }
                    log.tracef("Cluster state recovery failed because the coordinator is shutting down", new Object[0]);
                }
            }
            Object object2 = this.viewUpdateLock;
            synchronized (object2) {
                this.viewId = newViewId;
                this.viewUpdateLock.notifyAll();
            }
        }
        if (!this.mustRecoverClusterStatus) {
            try {
                this.updateCacheMembers(this.transport.getMembers());
            }
            catch (Exception e) {
                log.errorUpdatingMembersList(e);
            }
        }
    }

    private ClusterCacheStatus initCacheStatusIfAbsent(String cacheName) {
        return this.cacheStatusMap.computeIfAbsent(cacheName, name -> {
            Configuration cacheConfiguration = this.cacheManager.getCacheConfiguration(cacheName);
            AvailabilityStrategy availabilityStrategy = cacheConfiguration != null && cacheConfiguration.clustering().partitionHandling().enabled() ? new PreferConsistencyStrategy() : new PreferAvailabilityStrategy();
            return new ClusterCacheStatus(cacheName, availabilityStrategy, this, this.transport);
        });
    }

    @Override
    public void broadcastRebalanceStart(String cacheName, CacheTopology cacheTopology, boolean totalOrder, boolean distributed) {
        LogFactory.CLUSTER.startRebalance(cacheName, cacheTopology);
        CacheTopologyControlCommand command = new CacheTopologyControlCommand(cacheName, CacheTopologyControlCommand.Type.REBALANCE_START, this.transport.getAddress(), cacheTopology, null, this.transport.getViewId());
        this.executeOnClusterAsync(command, this.getGlobalTimeout(), totalOrder, distributed);
    }

    private void recoverClusterStatus(int newViewId, final boolean isMergeView, final List<Address> clusterMembers) throws Exception {
        log.debugf("Recovering cluster status for view %d", newViewId);
        CacheTopologyControlCommand command = new CacheTopologyControlCommand(null, CacheTopologyControlCommand.Type.GET_STATUS, this.transport.getAddress(), newViewId);
        Map<Address, Object> statusResponses = this.executeOnClusterSync(command, this.getGlobalTimeout(), false, false, new CacheTopologyFilterReuser());
        log.debugf("Got %d status responses. members are %s", statusResponses.size(), clusterMembers);
        HashMap<String, HashMap<Object, CacheStatusResponse>> responsesByCache = new HashMap<String, HashMap<Object, CacheStatusResponse>>();
        boolean recoveredRebalancingStatus = true;
        for (Map.Entry<Address, Object> responseEntry : statusResponses.entrySet()) {
            Address sender = responseEntry.getKey();
            ManagerStatusResponse managerStatusResponse = (ManagerStatusResponse)responseEntry.getValue();
            recoveredRebalancingStatus &= managerStatusResponse.isRebalancingEnabled();
            for (Map.Entry<String, CacheStatusResponse> statusEntry : managerStatusResponse.getCaches().entrySet()) {
                String cacheName = statusEntry.getKey();
                HashMap<Object, CacheStatusResponse> cacheResponses = (HashMap<Object, CacheStatusResponse>)responsesByCache.get(cacheName);
                if (cacheResponses == null) {
                    cacheResponses = new HashMap<Object, CacheStatusResponse>();
                    responsesByCache.put(cacheName, cacheResponses);
                }
                cacheResponses.put(sender, statusEntry.getValue());
            }
        }
        this.globalRebalancingEnabled = recoveredRebalancingStatus;
        int maxThreads = Runtime.getRuntime().availableProcessors() / 2 + 1;
        SemaphoreCompletionService cs = new SemaphoreCompletionService(this.asyncTransportExecutor, maxThreads);
        for (final Map.Entry entry : responsesByCache.entrySet()) {
            final ClusterCacheStatus cacheStatus = this.initCacheStatusIfAbsent((String)entry.getKey());
            cs.submit(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    cacheStatus.doMergePartitions((Map)entry.getValue(), clusterMembers, isMergeView);
                    return null;
                }
            });
        }
        for (int i = 0; i < responsesByCache.size(); ++i) {
            cs.take();
        }
    }

    public void updateCacheMembers(List<Address> newClusterMembers) throws Exception {
        log.tracef("Updating cluster members for all the caches. New list is %s", newClusterMembers);
        try {
            this.confirmMembersAvailable();
        }
        catch (SuspectException e) {
            log.tracef("Node %s left while updating cache members", e.getSuspect());
            return;
        }
        for (ClusterCacheStatus cacheStatus : this.cacheStatusMap.values()) {
            cacheStatus.doHandleClusterView();
        }
    }

    private void confirmMembersAvailable() throws Exception {
        CacheTopologyControlCommand heartbeatCommand = new CacheTopologyControlCommand(null, CacheTopologyControlCommand.Type.POLICY_GET_STATUS, this.transport.getAddress(), -1);
        this.transport.invokeRemotely(null, heartbeatCommand, ResponseMode.SYNCHRONOUS, this.getGlobalTimeout(), null, DeliverOrder.NONE, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForView(int viewId, long timeout) throws InterruptedException {
        if (this.viewId < viewId) {
            log.tracef("Received a cache topology command with a higher view id: %s, our view id is %s", viewId, this.viewId);
        }
        long endTime = this.timeService.expectedEndTime(timeout, TimeUnit.MILLISECONDS);
        Object object = this.viewUpdateLock;
        synchronized (object) {
            while (this.viewId < viewId && !this.timeService.isTimeExpired(endTime)) {
                this.viewUpdateLock.wait(1000L);
            }
        }
        if (this.viewId < viewId) {
            throw new TimeoutException("Timed out waiting for view " + viewId);
        }
    }

    private Map<Address, Object> executeOnClusterSync(ReplicableCommand command, int timeout, boolean totalOrder, boolean distributed) throws Exception {
        return this.executeOnClusterSync(command, timeout, totalOrder, distributed, null);
    }

    private Map<Address, Object> executeOnClusterSync(ReplicableCommand command, int timeout, boolean totalOrder, boolean distributed, ResponseFilter filter) throws Exception {
        Response localResponse;
        if (totalOrder) {
            Map<Address, Response> responseMap = this.transport.invokeRemotely(this.transport.getMembers(), command, ResponseMode.SYNCHRONOUS_IGNORE_LEAVERS, timeout, filter, DeliverOrder.TOTAL, distributed);
            HashMap<Address, Object> responseValues = new HashMap<Address, Object>(this.transport.getMembers().size());
            for (Map.Entry<Address, Response> entry : responseMap.entrySet()) {
                Address address = entry.getKey();
                Response response = entry.getValue();
                if (!response.isSuccessful()) {
                    Exception cause = response instanceof ExceptionResponse ? ((ExceptionResponse)response).getException() : null;
                    throw new CacheException("Unsuccessful response received from node " + address + ": " + response, (Throwable)cause);
                }
                responseValues.put(address, ((SuccessfulResponse)response).getResponseValue());
            }
            return responseValues;
        }
        CompletableFuture<Map<Address, Response>> remoteFuture = this.transport.invokeRemotelyAsync(null, command, ResponseMode.SYNCHRONOUS, timeout, filter, DeliverOrder.NONE, false);
        this.gcr.wireDependencies(command);
        try {
            if (trace) {
                log.tracef("Attempting to execute command on self: %s", command);
            }
            localResponse = (Response)command.perform(null);
        }
        catch (Throwable throwable) {
            throw new Exception(throwable);
        }
        if (!localResponse.isSuccessful()) {
            Exception exception = null;
            if (localResponse instanceof ExceptionResponse) {
                exception = ((ExceptionResponse)localResponse).getException();
            }
            throw new CacheException("Unsuccessful local response: " + localResponse, (Throwable)exception);
        }
        Map<Address, Response> responseMap = remoteFuture.get(timeout, TimeUnit.MILLISECONDS);
        HashMap<Address, Object> responseValues = new HashMap<Address, Object>(this.transport.getMembers().size());
        for (Map.Entry<Address, Response> entry : responseMap.entrySet()) {
            Address address = entry.getKey();
            Response response = entry.getValue();
            if (!response.isSuccessful()) {
                Exception cause = response instanceof ExceptionResponse ? ((ExceptionResponse)response).getException() : null;
                throw new CacheException("Unsuccessful response received from node " + address + ": " + response, (Throwable)cause);
            }
            responseValues.put(address, ((SuccessfulResponse)response).getResponseValue());
        }
        responseValues.put(this.transport.getAddress(), ((SuccessfulResponse)localResponse).getResponseValue());
        return responseValues;
    }

    private int getGlobalTimeout() {
        return (int)this.globalConfiguration.transport().distributedSyncTimeout();
    }

    private void executeOnClusterAsync(final ReplicableCommand command, int timeout, boolean totalOrder, boolean distributed) {
        if (!totalOrder) {
            this.asyncTransportExecutor.submit(new Runnable(){

                @Override
                public void run() {
                    ClusterTopologyManagerImpl.this.gcr.wireDependencies(command);
                    try {
                        if (trace) {
                            log.tracef("Attempting to execute command on self: %s", command);
                        }
                        command.perform(null);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            });
        }
        try {
            DeliverOrder deliverOrder = totalOrder ? DeliverOrder.TOTAL : DeliverOrder.NONE;
            this.transport.invokeRemotely(null, command, ResponseMode.ASYNCHRONOUS, timeout, null, deliverOrder, distributed);
        }
        catch (Exception e) {
            throw new CacheException("Failed to broadcast asynchronous command: " + command);
        }
    }

    @Override
    public void broadcastTopologyUpdate(String cacheName, CacheTopology cacheTopology, AvailabilityMode availabilityMode, boolean totalOrder, boolean distributed) {
        log.debugf("Updating cluster-wide current topology for cache %s, topology = %s, availability mode = %s", cacheName, cacheTopology, (Object)availabilityMode);
        CacheTopologyControlCommand command = new CacheTopologyControlCommand(cacheName, CacheTopologyControlCommand.Type.CH_UPDATE, this.transport.getAddress(), cacheTopology, availabilityMode, this.transport.getViewId());
        this.executeOnClusterAsync(command, this.getGlobalTimeout(), totalOrder, distributed);
    }

    @Override
    public void broadcastStableTopologyUpdate(String cacheName, CacheTopology cacheTopology, boolean totalOrder, boolean distributed) {
        log.debugf("Updating cluster-wide stable topology for cache %s, topology = %s", cacheName, cacheTopology);
        CacheTopologyControlCommand command = new CacheTopologyControlCommand(cacheName, CacheTopologyControlCommand.Type.STABLE_TOPOLOGY_UPDATE, this.transport.getAddress(), cacheTopology, null, this.transport.getViewId());
        this.executeOnClusterAsync(command, this.getGlobalTimeout(), totalOrder, distributed);
    }

    @Override
    public boolean isRebalancingEnabled() {
        return this.globalRebalancingEnabled;
    }

    @Override
    public boolean isRebalancingEnabled(String cacheName) {
        if (cacheName == null) {
            return this.isRebalancingEnabled();
        }
        return ((ClusterCacheStatus)this.cacheStatusMap.get(cacheName)).isRebalanceEnabled();
    }

    @Override
    public void setRebalancingEnabled(String cacheName, boolean enabled) {
        if (cacheName == null) {
            this.setRebalancingEnabled(enabled);
        } else {
            ClusterCacheStatus clusterCacheStatus = (ClusterCacheStatus)this.cacheStatusMap.get(cacheName);
            if (clusterCacheStatus != null) {
                clusterCacheStatus.setRebalanceEnabled(enabled);
            }
        }
    }

    @Override
    public void setRebalancingEnabled(boolean enabled) {
        if (enabled) {
            if (!this.globalRebalancingEnabled) {
                LogFactory.CLUSTER.rebalancingEnabled();
            }
        } else if (this.globalRebalancingEnabled) {
            LogFactory.CLUSTER.rebalancingSuspended();
        }
        this.globalRebalancingEnabled = enabled;
        for (ClusterCacheStatus cacheStatus : this.cacheStatusMap.values()) {
            cacheStatus.startQueuedRebalance();
        }
    }

    @Override
    public void forceRebalance(String cacheName) {
        ClusterCacheStatus cacheStatus = (ClusterCacheStatus)this.cacheStatusMap.get(cacheName);
        if (cacheStatus != null) {
            cacheStatus.forceRebalance();
        }
    }

    @Override
    public void forceAvailabilityMode(String cacheName, AvailabilityMode availabilityMode) {
        ClusterCacheStatus cacheStatus = (ClusterCacheStatus)this.cacheStatusMap.get(cacheName);
        if (cacheStatus != null) {
            cacheStatus.forceAvailabilityMode(availabilityMode);
        }
    }

    @Override
    public RebalancingStatus getRebalancingStatus(String cacheName) {
        ClusterCacheStatus cacheStatus = (ClusterCacheStatus)this.cacheStatusMap.get(cacheName);
        if (cacheStatus != null) {
            return cacheStatus.getRebalancingStatus();
        }
        return RebalancingStatus.PENDING;
    }

    @Listener(sync=true)
    public class ClusterViewListener {
        @Merged
        @ViewChanged
        public void handleViewChange(final ViewChangedEvent e) {
            ClusterTopologyManagerImpl.this.asyncTransportExecutor.submit(new Runnable(){

                @Override
                public void run() {
                    ClusterTopologyManagerImpl.this.handleClusterView(e.isMergeView(), e.getViewId());
                }
            });
        }
    }

    private static class CacheTopologyFilterReuser
    implements ResponseFilter {
        Map<CacheTopology, CacheTopology> seenTopologies = new HashMap<CacheTopology, CacheTopology>();
        Map<CacheJoinInfo, CacheJoinInfo> seenInfos = new HashMap<CacheJoinInfo, CacheJoinInfo>();

        private CacheTopologyFilterReuser() {
        }

        @Override
        public boolean isAcceptable(Response response, Address sender) {
            if (response.isSuccessful() && response.isValid()) {
                ManagerStatusResponse value = (ManagerStatusResponse)((SuccessfulResponse)response).getResponseValue();
                for (Map.Entry<String, CacheStatusResponse> entry : value.getCaches().entrySet()) {
                    CacheJoinInfo info;
                    CacheJoinInfo replaceInfo;
                    CacheStatusResponse csr = entry.getValue();
                    CacheTopology cacheTopology = csr.getCacheTopology();
                    CacheTopology stableTopology = csr.getStableTopology();
                    CacheTopology replaceCacheTopology = this.seenTopologies.get(cacheTopology);
                    if (replaceCacheTopology == null) {
                        this.seenTopologies.put(cacheTopology, cacheTopology);
                        replaceCacheTopology = cacheTopology;
                    }
                    CacheTopology replaceStableTopology = null;
                    if (!cacheTopology.equals(stableTopology)) {
                        replaceStableTopology = this.seenTopologies.get(stableTopology);
                        if (replaceStableTopology == null) {
                            this.seenTopologies.put(stableTopology, stableTopology);
                        }
                    } else {
                        CacheTopology cacheTopology2 = replaceStableTopology = replaceCacheTopology != null ? replaceCacheTopology : cacheTopology;
                    }
                    if ((replaceInfo = this.seenInfos.get(info = csr.getCacheJoinInfo())) == null) {
                        this.seenInfos.put(info, info);
                    }
                    if (replaceCacheTopology == null && replaceStableTopology == null && replaceInfo == null) continue;
                    entry.setValue(new CacheStatusResponse(replaceInfo != null ? replaceInfo : info, replaceCacheTopology != null ? replaceCacheTopology : cacheTopology, replaceStableTopology != null ? replaceStableTopology : stableTopology, csr.getAvailabilityMode()));
                }
            }
            return true;
        }

        @Override
        public boolean needMoreResponses() {
            return true;
        }
    }
}

