/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.inventory;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.hawkular.agent.monitor.inventory.AvailType;
import org.hawkular.agent.monitor.inventory.ID;
import org.hawkular.agent.monitor.inventory.Instance;
import org.hawkular.agent.monitor.inventory.MeasurementInstance;
import org.hawkular.agent.monitor.inventory.MeasurementType;
import org.hawkular.agent.monitor.inventory.MetricType;
import org.hawkular.agent.monitor.inventory.Name;
import org.hawkular.agent.monitor.inventory.NodeLocationProvider;
import org.hawkular.agent.monitor.inventory.ResourceConfigurationPropertyInstance;
import org.hawkular.agent.monitor.inventory.ResourceType;

public final class Resource<L>
extends NodeLocationProvider<L> {
    private final ResourceType<L> resourceType;
    private final Resource<L> parent;
    private final Set<MeasurementInstance<L, MetricType<L>>> metrics;
    private final Set<MeasurementInstance<L, AvailType<L>>> avails;
    private final Set<ResourceConfigurationPropertyInstance<L>> resourceConfigurationProperties;

    public static <L> Builder<L> builder() {
        return new Builder();
    }

    public static <L> Builder<L> builder(Resource<L> template) {
        return new Builder<L>(template);
    }

    private Resource(ID id, Name name, L location, ResourceType<L> resourceType, Resource<L> parent, Set<MeasurementInstance<L, MetricType<L>>> metrics, Set<MeasurementInstance<L, AvailType<L>>> avails, Set<ResourceConfigurationPropertyInstance<L>> resourceConfigurationProperties) {
        super(id, name, location);
        this.resourceType = resourceType;
        this.parent = parent;
        this.metrics = metrics;
        this.avails = avails;
        this.resourceConfigurationProperties = resourceConfigurationProperties;
        this.assignToThisResource(this.metrics);
        this.assignToThisResource(this.avails);
        this.assignToThisResource(this.resourceConfigurationProperties);
    }

    private void assignToThisResource(Collection<? extends Instance<L, ?>> instances) {
        if (instances != null && !instances.isEmpty()) {
            for (Instance<L, ?> instance : instances) {
                instance.setResource(this);
            }
        }
    }

    public ResourceType<L> getResourceType() {
        return this.resourceType;
    }

    public Resource<L> getParent() {
        return this.parent;
    }

    public Collection<MeasurementInstance<L, MetricType<L>>> getMetrics() {
        return this.metrics;
    }

    public Collection<MeasurementInstance<L, AvailType<L>>> getAvails() {
        return this.avails;
    }

    public Collection<ResourceConfigurationPropertyInstance<L>> getResourceConfigurationProperties() {
        return this.resourceConfigurationProperties;
    }

    @Override
    public String toString() {
        return String.format("%s=[type=%s]", super.toString(), this.resourceType);
    }

    public static class Builder<L>
    extends NodeLocationProvider.Builder<Builder<L>, L> {
        private ResourceType<L> resourceType;
        private Resource<L> parent;
        private Set<MeasurementInstance<L, MetricType<L>>> metrics = new HashSet<MeasurementInstance<L, MetricType<L>>>();
        private Set<MeasurementInstance<L, AvailType<L>>> avails = new HashSet<MeasurementInstance<L, AvailType<L>>>();
        private Set<ResourceConfigurationPropertyInstance<L>> resourceConfigurationProperties = new HashSet<ResourceConfigurationPropertyInstance<L>>();

        private Builder() {
        }

        public Builder(Resource<L> template) {
            super(template);
            this.parent(template.getParent());
            this.type(template.getResourceType());
            for (MeasurementInstance<L, MetricType<L>> measurementInstance : template.getMetrics()) {
                this.metric(new MeasurementInstance<L, MetricType<L>>(measurementInstance, true));
            }
            for (MeasurementInstance<L, MeasurementType> measurementInstance : template.getAvails()) {
                this.avail(new MeasurementInstance<L, MeasurementType>(measurementInstance, true));
            }
            for (ResourceConfigurationPropertyInstance resourceConfigurationPropertyInstance : template.getResourceConfigurationProperties()) {
                this.resourceConfigurationProperty(new ResourceConfigurationPropertyInstance(resourceConfigurationPropertyInstance, true));
            }
        }

        public Builder<L> parent(Resource<L> parent) {
            this.parent = parent;
            return this;
        }

        public Builder<L> type(ResourceType<L> type) {
            this.resourceType = type;
            return this;
        }

        public Builder<L> metric(MeasurementInstance<L, MetricType<L>> metric) {
            this.metrics.add(metric);
            return this;
        }

        public Builder<L> avail(MeasurementInstance<L, AvailType<L>> avail) {
            this.avails.add(avail);
            return this;
        }

        public Builder<L> resourceConfigurationProperty(ResourceConfigurationPropertyInstance<L> resourceConfigurationProperty) {
            this.resourceConfigurationProperties.add(resourceConfigurationProperty);
            return this;
        }

        public Resource<L> build() {
            return new Resource(this.id, this.name, this.location, this.resourceType, this.parent, Collections.unmodifiableSet(this.metrics), Collections.unmodifiableSet(this.avails), Collections.unmodifiableSet(this.resourceConfigurationProperties));
        }
    }
}

