/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.threads;

import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.logging.Logger;
import org.jboss.threads.DirectExecutor;
import org.jboss.threads.InterruptHandler;
import org.jboss.threads.JBossExecutors;
import org.jboss.threads.ThreadNameInfo;

public final class JBossThread
extends Thread {
    private static final Logger log = Logger.getLogger("org.jboss.threads");
    private static final Logger ihlog = Logger.getLogger("org.jboss.threads.interrupt-handler");
    private volatile InterruptHandler interruptHandler;
    private ThreadNameInfo threadNameInfo;
    private final AtomicInteger intCnt = new AtomicInteger();

    public JBossThread(Runnable target) {
        super(target);
    }

    public JBossThread(Runnable target, String name) {
        super(target, name);
    }

    public JBossThread(ThreadGroup group, Runnable target) throws SecurityException {
        super(group, target);
    }

    public JBossThread(ThreadGroup group, Runnable target, String name) throws SecurityException {
        super(group, target, name);
    }

    public JBossThread(ThreadGroup group, Runnable target, String name, long stackSize) throws SecurityException {
        super(group, target, name, stackSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void interrupt() {
        int oldVal;
        if (Thread.currentThread() != this) {
            this.checkAccess();
        }
        if (this.isInterrupted()) {
            return;
        }
        AtomicInteger intCnt = this.intCnt;
        do {
            if (((oldVal = intCnt.get()) & Integer.MIN_VALUE) != 0) {
                ihlog.tracef("Interrupting thread \"%s\" (already deferred)", (Object)this);
                return;
            }
            if (oldVal == 0) {
                AtomicInteger atomicInteger = intCnt;
                synchronized (atomicInteger) {
                    oldVal = intCnt.get();
                    if (oldVal == 0) {
                        this.doInterrupt();
                        return;
                    }
                }
            }
            assert (oldVal != 0);
        } while (!intCnt.compareAndSet(oldVal, oldVal | Integer.MIN_VALUE));
        ihlog.tracef("Interrupting thread \"%s\" (deferred)", (Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doInterrupt() {
        assert (Thread.holdsLock(this.intCnt));
        if (this.isInterrupted()) {
            return;
        }
        ihlog.tracef("Interrupting thread \"%s\"", (Object)this);
        try {
            super.interrupt();
        }
        finally {
            InterruptHandler interruptHandler = this.interruptHandler;
            if (interruptHandler != null) {
                try {
                    interruptHandler.handleInterrupt(this);
                }
                catch (Throwable t) {
                    ihlog.errorf(t, "Interrupt handler %s threw an exception", (Object)interruptHandler);
                }
            }
        }
    }

    @Override
    public boolean isInterrupted() {
        return this == Thread.currentThread() ? super.isInterrupted() : super.isInterrupted() || (this.intCnt.get() & Integer.MIN_VALUE) != 0;
    }

    public static void executeWithInterruptDeferred(Runnable task) {
        JBossThread.executeWithInterruptDeferred(JBossExecutors.directExecutor(), task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeWithInterruptDeferred(DirectExecutor directExecutor, Runnable task) {
        JBossThread thread = JBossThread.currentThread();
        if (thread == null) {
            directExecutor.execute(task);
            return;
        }
        boolean intr = JBossThread.registerDeferral(thread);
        assert (!Thread.interrupted());
        try {
            directExecutor.execute(task);
        }
        finally {
            JBossThread.unregisterDeferral(intr, thread);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T executeWithInterruptDeferred(Callable<T> action) throws Exception {
        JBossThread thread = JBossThread.currentThread();
        if (thread == null) {
            return action.call();
        }
        boolean intr = JBossThread.registerDeferral(thread);
        assert (!Thread.interrupted());
        try {
            T t = action.call();
            return t;
        }
        finally {
            JBossThread.unregisterDeferral(intr, thread);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T executeWithInterruptDeferred(PrivilegedAction<T> action) {
        JBossThread thread = JBossThread.currentThread();
        if (thread == null) {
            return action.run();
        }
        boolean intr = JBossThread.registerDeferral(thread);
        assert (!Thread.interrupted());
        try {
            T t = action.run();
            return t;
        }
        finally {
            JBossThread.unregisterDeferral(intr, thread);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T executeWithInterruptDeferred(PrivilegedExceptionAction<T> action) throws Exception {
        JBossThread thread = JBossThread.currentThread();
        if (thread == null) {
            return action.run();
        }
        boolean intr = JBossThread.registerDeferral(thread);
        assert (!Thread.interrupted());
        try {
            T t = action.run();
            return t;
        }
        finally {
            JBossThread.unregisterDeferral(intr, thread);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unregisterDeferral(boolean intr, JBossThread thread) {
        int oldVal;
        AtomicInteger intCnt = thread.intCnt;
        do {
            if (((oldVal = intCnt.get()) & Integer.MAX_VALUE) == 1) {
                AtomicInteger atomicInteger = intCnt;
                synchronized (atomicInteger) {
                    oldVal = intCnt.get();
                    if (oldVal == 1) {
                        intCnt.set(0);
                        if (intr) {
                            thread.doInterrupt();
                        }
                        break;
                    }
                    if (oldVal == -2147483647) {
                        intCnt.set(0);
                        thread.doInterrupt();
                        break;
                    }
                }
            }
            assert ((oldVal & Integer.MAX_VALUE) > 1);
        } while (!intCnt.compareAndSet(oldVal, oldVal - 1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean registerDeferral(JBossThread thread) {
        int oldVal;
        boolean intr = false;
        AtomicInteger intCnt = thread.intCnt;
        do {
            if ((oldVal = intCnt.get()) == 0) {
                AtomicInteger atomicInteger = intCnt;
                synchronized (atomicInteger) {
                    oldVal = intCnt.get();
                    if (oldVal == 0) {
                        intCnt.set(1);
                        intr = Thread.interrupted();
                        break;
                    }
                }
            }
            if (oldVal == Integer.MAX_VALUE) {
                throw new IllegalStateException();
            }
            assert ((oldVal & Integer.MAX_VALUE) > 0);
        } while (!intCnt.compareAndSet(oldVal, oldVal + 1));
        return intr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        log.tracef("Thread \"%s\" starting execution", (Object)this);
        try {
            super.run();
        }
        finally {
            log.tracef("Thread \"%s\" exiting", (Object)this);
        }
    }

    public static JBossThread currentThread() {
        Thread thread = Thread.currentThread();
        return thread instanceof JBossThread ? (JBossThread)thread : null;
    }

    @Override
    public void start() {
        super.start();
        log.tracef("Started thread \"%s\"", (Object)this);
    }

    @Override
    public void setUncaughtExceptionHandler(Thread.UncaughtExceptionHandler eh) {
        super.setUncaughtExceptionHandler(eh);
        log.tracef("Changed uncaught exception handler for \"%s\" to %s", (Object)this, (Object)eh);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InterruptHandler getAndSetInterruptHandler(InterruptHandler newInterruptHandler) {
        JBossThread thread = JBossThread.currentThread();
        if (thread == null) {
            throw new IllegalStateException("The current thread does not support interrupt handlers");
        }
        try {
            InterruptHandler interruptHandler = thread.interruptHandler;
            return interruptHandler;
        }
        finally {
            thread.interruptHandler = newInterruptHandler;
        }
    }

    ThreadNameInfo getThreadNameInfo() {
        return this.threadNameInfo;
    }

    void setThreadNameInfo(ThreadNameInfo threadNameInfo) throws SecurityException {
        this.checkAccess();
        this.threadNameInfo = threadNameInfo;
    }
}

