/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.api.model;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import org.hawkular.inventory.api.TreeTraversal;
import org.hawkular.inventory.paths.Path;
import org.hawkular.inventory.paths.RelativePath;

public abstract class AbstractHashTree<This extends AbstractHashTree<This, H>, H extends Serializable>
implements Serializable {
    protected final RelativePath path;
    protected final H hash;
    protected final Map<Path.Segment, This> children;

    AbstractHashTree() {
        this(null, null, null);
    }

    AbstractHashTree(RelativePath path, H hash, Map<Path.Segment, This> children) {
        this.path = path;
        this.hash = hash;
        this.children = children;
    }

    public Collection<This> getChildren() {
        return this.children.values();
    }

    public This getChild(Path.Segment path) {
        return (This)((AbstractHashTree)this.children.get(path));
    }

    public H getHash() {
        return this.hash;
    }

    public RelativePath getPath() {
        return this.path;
    }

    public TreeTraversal<This> traversal() {
        return new TreeTraversal<AbstractHashTree>(t -> t.children.values().iterator());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractHashTree tree = (AbstractHashTree)o;
        return this.hash.equals(tree.hash);
    }

    public int hashCode() {
        return this.hash.hashCode();
    }

    public String toString() {
        return "Tree[path=" + this.path + ", hash='" + this.hash + '\'' + ",children=" + this.children.values() + ']';
    }

    static abstract class AbstractChildBuilder<This extends AbstractChildBuilder<This, Parent, Child, T, H>, Parent extends Builder<?, This, T, H>, Child extends AbstractChildBuilder<Child, This, ?, T, H>, T extends AbstractHashTree<T, H>, H extends Serializable>
    extends AbstractBuilder<This, Child, T, H>
    implements ChildBuilder<This, Parent, Child, T, H> {
        private final Parent parent;

        AbstractChildBuilder(TreeConstructor<T, H> tctor, Parent parent, BiFunction<TreeConstructor<T, H>, This, Child> cctor) {
            super(tctor, cctor);
            this.parent = parent;
        }

        @Override
        public Parent getParent() {
            return this.parent;
        }

        @Override
        public Parent endChild() {
            Object tree = this.build();
            this.parent.addChild(tree);
            return this.parent;
        }
    }

    static class AbstractBuilder<This extends Builder<This, Child, T, H>, Child extends ChildBuilder<Child, This, ?, T, H>, T extends AbstractHashTree<T, H>, H extends Serializable>
    implements Builder<This, Child, T, H> {
        private final TreeConstructor<T, H> tctor;
        private final BiFunction<TreeConstructor<T, H>, This, Child> cctor;
        private RelativePath path;
        private H hash;
        private Map<Path.Segment, T> children;

        AbstractBuilder(TreeConstructor<T, H> tctor, BiFunction<TreeConstructor<T, H>, This, Child> cctor) {
            this.tctor = tctor;
            this.cctor = cctor;
        }

        @Override
        public This withPath(RelativePath path) {
            this.path = path;
            return this.castThis();
        }

        @Override
        public This withHash(H hash) {
            this.hash = hash;
            return this.castThis();
        }

        @Override
        public H getHash() {
            return this.hash;
        }

        @Override
        public RelativePath getPath() {
            return this.path;
        }

        @Override
        public boolean hasChildren() {
            return this.children != null && !this.children.isEmpty();
        }

        @Override
        public void addChild(T childTree) {
            this.getChildren().put(((AbstractHashTree)childTree).getPath().getSegment(), childTree);
        }

        @Override
        public Child startChild() {
            return (Child)((ChildBuilder)this.cctor.apply(this.tctor, this.castThis()));
        }

        protected T build() {
            if (!(this.path != null && this.hash != null || this.children == null || this.children.isEmpty())) {
                throw new IllegalStateException("Cannot construct a tree hash node without a path or hash and with children. While empty tree without a hash or path is OK, having children assumes the parent to be fully established.");
            }
            if (this.path != null) {
                int myDepth = this.path.getDepth();
                for (AbstractHashTree child : this.getChildren().values()) {
                    int childDepth = child.getPath().getDepth();
                    if (this.path.isParentOf(child.getPath()) && childDepth == myDepth + 1) continue;
                    throw new IllegalStateException("When building a tree node with path " + this.path + " an attempt " + "to add a child on path " + child.getPath() + " was made. The child's path must extend the parent's path by exactly" + " one segment, which is not true in this case.");
                }
            }
            return this.tctor.construct(this.path, this.hash, Collections.unmodifiableMap(this.getChildren()));
        }

        private Map<Path.Segment, T> getChildren() {
            if (this.children == null) {
                this.children = new HashMap<Path.Segment, T>();
            }
            return this.children;
        }

        private This castThis() {
            return (This)this;
        }
    }

    public static interface ChildBuilder<This extends ChildBuilder<This, Parent, Child, Tree, Hash>, Parent extends Builder<?, This, Tree, Hash>, Child extends ChildBuilder<Child, This, ?, Tree, Hash>, Tree extends AbstractHashTree<Tree, Hash>, Hash extends Serializable>
    extends Builder<This, Child, Tree, Hash> {
        public Parent getParent();

        public Parent endChild();
    }

    public static interface TopBuilder<This extends TopBuilder<This, Child, Tree, Hash>, Child extends ChildBuilder<Child, This, ?, Tree, Hash>, Tree extends AbstractHashTree<Tree, Hash>, Hash extends Serializable>
    extends Builder<This, Child, Tree, Hash> {
        public Tree build();
    }

    public static interface Builder<This extends Builder<This, Child, Tree, Hash>, Child extends ChildBuilder<Child, This, ?, Tree, Hash>, Tree extends AbstractHashTree<Tree, Hash>, Hash extends Serializable> {
        public This withPath(RelativePath var1);

        public This withHash(Hash var1);

        public Hash getHash();

        public RelativePath getPath();

        public boolean hasChildren();

        public Child startChild();

        public void addChild(Tree var1);
    }

    static interface TreeConstructor<T extends AbstractHashTree<T, H>, H extends Serializable> {
        public T construct(RelativePath var1, H var2, Map<Path.Segment, T> var3);
    }
}

