/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jaxrs.logging;

import java.util.List;
import javax.ws.rs.core.Application;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;

@MessageLogger(projectCode="WFLYRS", length=4)
public interface JaxrsLogger
extends BasicLogger {
    public static final JaxrsLogger JAXRS_LOGGER = (JaxrsLogger)Logger.getMessageLogger(JaxrsLogger.class, (String)"org.jboss.as.jaxrs");

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1, value="%s annotation not on Class: %s")
    public void classAnnotationNotFound(String var1, AnnotationTarget var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=2, value="%s annotation not on Class or Method: %s")
    public void classOrMethodAnnotationNotFound(String var1, AnnotationTarget var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=3, value="More than one mapping found for JAX-RS servlet: %s the second mapping %s will not work")
    public void moreThanOneServletMapping(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=4, value="No Servlet mappings found for JAX-RS application: %s either annotate it with @ApplicationPath or add a servlet-mapping in web.xml")
    public void noServletMappingFound(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=5, value="%s found and ignored in web.xml. This is not necessary, as Resteasy will use the container integration in the JAX-RS 1.1 specification in section 2.3.2")
    public void resteasyScanWarning(String var1);

    @Message(id=6, value="Could not load JAX-RS Application class")
    public DeploymentUnitProcessingException cannotLoadApplicationClass(@Cause Throwable var1);

    @Message(id=7, value="More than one Application class found in deployment %s and %s")
    public DeploymentUnitProcessingException moreThanOneApplicationClassFound(Class<? extends Application> var1, Class<? extends Application> var2);

    @Message(id=8, value="Only one JAX-RS Application Class allowed. %s")
    public String onlyOneApplicationClassAllowed(StringBuilder var1);

    @Message(id=9, value="Please use either @ApplicationPath or servlet mapping for url path config.")
    public String conflictUrlMapping();

    @Message(id=10, value="JAX-RS resource %s does not correspond to a view on the EJB %s. @Path annotations can only be placed on classes or interfaces that represent a local, remote or no-interface view of an EJB.")
    public DeploymentUnitProcessingException typeNameNotAnEjbView(List<Class<?>> var1, String var2);

    @Message(id=11, value="Invalid value for parameter %s: %s")
    public DeploymentUnitProcessingException invalidParamValue(String var1, String var2);

    @Message(id=12, value="No spring integration jar found")
    public DeploymentUnitProcessingException noSpringIntegrationJar();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=13, value="The context param org.jboss.as.jaxrs.disableSpringIntegration is deprecated, and will be removed in a future release. Please use org.jboss.as.jaxrs.enableSpringIntegration instead")
    public void disablePropertyDeprecated();
}

