/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.batch.deployment;

import javax.enterprise.inject.spi.BeanManager;
import javax.transaction.TransactionManager;
import org.jberet.spi.JobXmlResolver;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.weld.WeldDeploymentMarker;
import org.jboss.as.server.Services;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.suspend.SuspendController;
import org.jboss.as.txn.service.TxnServices;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.Value;
import org.wildfly.extension.batch.BatchServiceNames;
import org.wildfly.extension.batch._private.BatchLogger;
import org.wildfly.extension.batch._private.Capabilities;
import org.wildfly.extension.batch.jberet.BatchConfiguration;
import org.wildfly.extension.batch.jberet.deployment.WildFlyJobXmlResolver;
import org.wildfly.extension.batch.jberet.impl.BatchEnvironmentService;
import org.wildfly.extension.batch.job.repository.JobRepositoryFactory;
import org.wildfly.extension.requestcontroller.RequestController;

public class BatchEnvironmentProcessor
implements DeploymentUnitProcessor {
    private final boolean rcPresent;

    public BatchEnvironmentProcessor(boolean rcPresent) {
        this.rcPresent = rcPresent;
    }

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (deploymentUnit.hasAttachment(org.jboss.as.server.deployment.Attachments.MODULE)) {
            BatchLogger.LOGGER.tracef("Processing deployment '%s' for the batch environment.", deploymentUnit.getName());
            Module module = (Module)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.MODULE);
            ModuleClassLoader moduleClassLoader = module.getClassLoader();
            ServiceTarget serviceTarget = phaseContext.getServiceTarget();
            EEModuleDescription moduleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
            CapabilityServiceSupport support = (CapabilityServiceSupport)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.CAPABILITY_SERVICE_SUPPORT);
            BatchEnvironmentService service = new BatchEnvironmentService((ClassLoader)moduleClassLoader, (JobXmlResolver)WildFlyJobXmlResolver.of((ClassLoader)moduleClassLoader, (DeploymentUnit)deploymentUnit), deploymentUnit.getName());
            service.getJobRepositoryInjector().setValue((Value)new ImmediateValue((Object)JobRepositoryFactory.getInstance().getJobRepository(moduleDescription)));
            ServiceBuilder serviceBuilder = serviceTarget.addService(BatchServiceNames.batchEnvironmentServiceName(deploymentUnit), (Service)service);
            serviceBuilder.addDependency(support.getCapabilityServiceName(Capabilities.BATCH_CONFIGURATION_CAPABILITY.getName()), BatchConfiguration.class, (Injector)service.getBatchConfigurationInjector());
            serviceBuilder.addDependency(TxnServices.JBOSS_TXN_TRANSACTION_MANAGER, TransactionManager.class, (Injector)service.getTransactionManagerInjector());
            if (WeldDeploymentMarker.isPartOfWeldDeployment((DeploymentUnit)deploymentUnit)) {
                BatchLogger.LOGGER.tracef("Adding BeanManager service dependency for deployment %s", deploymentUnit.getName());
                serviceBuilder.addDependency(BatchServiceNames.beanManagerServiceName(deploymentUnit), BeanManager.class, (Injector)service.getBeanManagerInjector());
            }
            if (this.rcPresent) {
                serviceBuilder.addDependency(RequestController.SERVICE_NAME, RequestController.class, (Injector)service.getRequestControllerInjector());
            }
            Services.addServerExecutorDependency((ServiceBuilder)serviceBuilder.addDependency(SuspendController.SERVICE_NAME, SuspendController.class, (Injector)service.getSuspendControllerInjector()), (Injector)service.getExecutorServiceInjector(), (boolean)false).install();
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

