/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.undertow.sso;

import io.undertow.security.api.AuthenticatedSessionManager;
import io.undertow.security.idm.Account;
import io.undertow.security.impl.SingleSignOn;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.ee.Batcher;
import org.wildfly.clustering.web.sso.SSO;
import org.wildfly.clustering.web.sso.SSOManager;
import org.wildfly.clustering.web.undertow.sso.DistributableSingleSignOn;
import org.wildfly.clustering.web.undertow.sso.InvalidatableSingleSignOn;
import org.wildfly.clustering.web.undertow.sso.SessionManagerRegistry;
import org.wildfly.extension.undertow.security.sso.SingleSignOnManager;

public class DistributableSingleSignOnManager
implements SingleSignOnManager {
    private final SSOManager<AuthenticatedSessionManager.AuthenticatedSession, String, Void, Batch> manager;
    private final SessionManagerRegistry registry;
    private volatile boolean started = false;

    public DistributableSingleSignOnManager(SSOManager<AuthenticatedSessionManager.AuthenticatedSession, String, Void, Batch> manager, SessionManagerRegistry registry) {
        this.manager = manager;
        this.registry = registry;
    }

    public boolean isStarted() {
        return this.started;
    }

    public void start() {
        this.manager.start();
        this.started = true;
    }

    public void stop() {
        this.started = false;
        this.manager.stop();
    }

    public SingleSignOn createSingleSignOn(Account account, String mechanism) {
        String id = (String)this.manager.createIdentifier();
        Batcher batcher = this.manager.getBatcher();
        Batch batch = batcher.createBatch();
        try {
            AuthenticatedSessionManager.AuthenticatedSession session = new AuthenticatedSessionManager.AuthenticatedSession(account, mechanism);
            SSO sso = this.manager.createSSO(id, (Object)session);
            DistributableSingleSignOn distributableSingleSignOn = new DistributableSingleSignOn((SSO<AuthenticatedSessionManager.AuthenticatedSession, String, Void>)sso, this.registry, (Batcher<Batch>)batcher, batch);
            return distributableSingleSignOn;
        }
        catch (Error | RuntimeException e) {
            batch.discard();
            throw e;
        }
        finally {
            if (batch.isActive()) {
                batcher.suspendBatch();
            }
        }
    }

    public SingleSignOn findSingleSignOn(String id) {
        Batcher batcher = this.manager.getBatcher();
        Batch batch = batcher.createBatch();
        try {
            SSO sso = this.manager.findSSO(id);
            if (sso == null) {
                batch.discard();
                SingleSignOn singleSignOn = null;
                return singleSignOn;
            }
            DistributableSingleSignOn distributableSingleSignOn = new DistributableSingleSignOn((SSO<AuthenticatedSessionManager.AuthenticatedSession, String, Void>)sso, this.registry, (Batcher<Batch>)batcher, batch);
            return distributableSingleSignOn;
        }
        catch (Error | RuntimeException e) {
            if (batch.isActive()) {
                batch.discard();
            }
            throw e;
        }
        finally {
            if (batch.isActive()) {
                batcher.suspendBatch();
            }
        }
    }

    public void removeSingleSignOn(SingleSignOn sso) {
        if (sso instanceof InvalidatableSingleSignOn) {
            ((InvalidatableSingleSignOn)sso).invalidate();
        }
    }
}

