/*
 * Decompiled with CFR 0.152.
 */
package oshi.software.os.windows;

import com.sun.jna.platform.win32.WinNT;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oshi.jna.platform.windows.Kernel32;
import oshi.software.common.AbstractFileSystem;
import oshi.software.os.OSFileStore;
import oshi.util.ParseUtil;
import oshi.util.platform.windows.WmiUtil;

public class WindowsFileSystem
extends AbstractFileSystem {
    private static final long serialVersionUID = 1L;
    private static final Pattern UUID_PATTERN = Pattern.compile(".+([0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}).+");
    private final int BUFSIZE = 255;

    public WindowsFileSystem() {
        Kernel32.INSTANCE.SetErrorMode(1);
    }

    @Override
    public OSFileStore[] getFileStores() {
        ArrayList<OSFileStore> result = this.getLocalVolumes();
        HashMap<String, OSFileStore> volumeMap = new HashMap<String, OSFileStore>();
        for (OSFileStore volume : result) {
            volumeMap.put(volume.getMount(), volume);
        }
        for (OSFileStore wmiVolume : this.getWmiVolumes()) {
            if (volumeMap.containsKey(wmiVolume.getMount())) {
                ((OSFileStore)volumeMap.get(wmiVolume.getMount())).setName(wmiVolume.getName());
                continue;
            }
            result.add(wmiVolume);
        }
        return result.toArray(new OSFileStore[result.size()]);
    }

    private ArrayList<OSFileStore> getLocalVolumes() {
        boolean retVal;
        ArrayList<OSFileStore> fs = new ArrayList<OSFileStore>();
        char[] aVolume = new char[255];
        WinNT.HANDLE hVol = Kernel32.INSTANCE.FindFirstVolume(aVolume, 255);
        if (hVol == WinNT.INVALID_HANDLE_VALUE) {
            return fs;
        }
        do {
            char[] fstype = new char[16];
            char[] name = new char[255];
            char[] mount = new char[255];
            WinNT.LARGE_INTEGER userFreeBytes = new WinNT.LARGE_INTEGER(0L);
            WinNT.LARGE_INTEGER totalBytes = new WinNT.LARGE_INTEGER(0L);
            WinNT.LARGE_INTEGER systemFreeBytes = new WinNT.LARGE_INTEGER(0L);
            String volume = new String(aVolume).trim();
            Kernel32.INSTANCE.GetVolumeInformation(volume, name, 255, null, null, null, fstype, 16);
            Kernel32.INSTANCE.GetVolumePathNamesForVolumeName(volume, mount, 255, null);
            Kernel32.INSTANCE.GetDiskFreeSpaceEx(volume, userFreeBytes, totalBytes, systemFreeBytes);
            String strMount = new String(mount).trim();
            String strName = new String(name).trim();
            String strFsType = new String(fstype).trim();
            String uuid = "";
            Matcher m = UUID_PATTERN.matcher(volume.toLowerCase());
            if (m.matches()) {
                uuid = m.group(1);
            }
            if (strMount.isEmpty()) continue;
            fs.add(new OSFileStore(String.format("%s (%s)", strName, strMount), volume, strMount, this.getDriveType(strMount), strFsType, uuid, systemFreeBytes.getValue(), totalBytes.getValue()));
        } while (retVal = Kernel32.INSTANCE.FindNextVolume(hVol, aVolume, 255));
        Kernel32.INSTANCE.FindVolumeClose(hVol);
        return fs;
    }

    private List<OSFileStore> getWmiVolumes() {
        ArrayList<OSFileStore> fs = new ArrayList<OSFileStore>();
        Map<String, List<String>> drives = WmiUtil.selectStringsFrom(null, "Win32_LogicalDisk", "Name,Description,ProviderName,FileSystem,Freespace,Size", null);
        for (int i = 0; i < drives.get("Name").size(); ++i) {
            String volume;
            long free = 0L;
            long total = 0L;
            free = ParseUtil.parseLongOrDefault(drives.get("Freespace").get(i), 0L);
            total = ParseUtil.parseLongOrDefault(drives.get("Size").get(i), 0L);
            String description = drives.get("Description").get(i);
            long type = WmiUtil.selectUint32From(null, "Win32_LogicalDisk", "DriveType", "WHERE Name = '" + drives.get("Name").get(i) + "'");
            if (type != 4L) {
                char[] chrVolume = new char[255];
                Kernel32.INSTANCE.GetVolumeNameForVolumeMountPoint(drives.get("Name").get(i) + "\\", chrVolume, 255);
                volume = new String(chrVolume).trim();
            } else {
                volume = drives.get("ProviderName").get(i);
                String[] split = volume.split("\\\\");
                if (split.length > 1 && split[split.length - 1].length() > 0) {
                    description = split[split.length - 1];
                }
            }
            fs.add(new OSFileStore(String.format("%s (%s)", description, drives.get("Name").get(i)), volume, drives.get("Name").get(i) + "\\", this.getDriveType(drives.get("Name").get(i)), drives.get("FileSystem").get(i), "", free, total));
        }
        return fs;
    }

    private String getDriveType(String drive) {
        switch (Kernel32.INSTANCE.GetDriveType(drive)) {
            case 2: {
                return "Removable drive";
            }
            case 3: {
                return "Fixed drive";
            }
            case 4: {
                return "Network drive";
            }
            case 5: {
                return "CD-ROM";
            }
            case 6: {
                return "RAM drive";
            }
        }
        return "Unknown drive type";
    }

    @Override
    public long getOpenFileDescriptors() {
        return 0L;
    }

    @Override
    public long getMaxFileDescriptors() {
        return 0L;
    }
}

