/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.extension;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hawkular.agent.monitor.config.AgentCoreEngineConfiguration;
import org.hawkular.agent.monitor.extension.SubsystemExtension;
import org.hawkular.agent.monitor.inventory.ConnectionData;
import org.hawkular.agent.monitor.inventory.MonitoredEndpoint;
import org.hawkular.agent.monitor.inventory.Resource;
import org.hawkular.agent.monitor.inventory.ResourceConfigurationPropertyInstance;
import org.hawkular.agent.monitor.inventory.ResourceManager;
import org.hawkular.agent.monitor.protocol.EndpointService;
import org.hawkular.agent.monitor.protocol.ProtocolService;
import org.hawkular.agent.monitor.service.MonitorService;
import org.hawkular.agent.monitor.service.ServiceStatus;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceNotFoundException;
import org.jboss.msc.service.ServiceRegistry;

public class OperationInventoryReport
implements OperationStepHandler {
    public void execute(OperationContext opContext, ModelNode model) throws OperationFailedException {
        block10: {
            try {
                ServiceName name = SubsystemExtension.SERVICE_NAME;
                ServiceRegistry serviceRegistry = opContext.getServiceRegistry(true);
                MonitorService service = (MonitorService)((Object)serviceRegistry.getRequiredService(name).getValue());
                ServiceStatus status = service.getStatus();
                if (status == ServiceStatus.RUNNING) {
                    ModelNode result = opContext.getResult();
                    List protocolServices = service.getProtocolServices().getServices();
                    for (ProtocolService protocolService : protocolServices) {
                        ModelNode protocolServiceNode = result.get(protocolService.getName());
                        for (EndpointService endpointService : protocolService.getEndpointServices().values()) {
                            MonitoredEndpoint endpoint = endpointService.getMonitoredEndpoint();
                            AgentCoreEngineConfiguration.EndpointConfiguration endpointConfig = (AgentCoreEngineConfiguration.EndpointConfiguration)endpoint.getEndpointConfiguration();
                            ConnectionData endpointConnectionData = endpointConfig.getConnectionData();
                            Map endpointCustomData = endpointConfig.getCustomData();
                            String tenantId = endpointConfig.getTenantId();
                            ModelNode endpointNode = protocolServiceNode.get(endpoint.getName());
                            endpointNode.get("Feed ID").set(service.getFeedId());
                            endpointNode.get("Tenant ID").set(tenantId != null ? tenantId : service.getTenantId());
                            if (endpointConnectionData != null) {
                                ModelNode connDataNode = endpointNode.get("Connection Data");
                                connDataNode.get("URL").set(String.valueOf(endpointConnectionData.getUri()));
                                connDataNode.get("Username").set(String.valueOf(endpointConnectionData.getUsername()));
                            }
                            if (endpointCustomData != null && !endpointCustomData.isEmpty()) {
                                ModelNode customDataNode = endpointNode.get("Custom Data");
                                for (Map.Entry entry : endpointCustomData.entrySet()) {
                                    customDataNode.get((String)entry.getKey()).set(String.valueOf(entry.getValue()));
                                }
                            }
                            this.buildEndpointNode(endpointNode.get("Resources"), endpointService);
                        }
                    }
                    break block10;
                }
                throw new OperationFailedException("Agent is not running - status is [" + (Object)((Object)status) + "]");
            }
            catch (OperationFailedException ofe) {
                throw ofe;
            }
            catch (ServiceNotFoundException snfe) {
                throw new OperationFailedException("Agent is not deployed: " + snfe.toString());
            }
            catch (Exception e) {
                throw new OperationFailedException(e.toString());
            }
        }
        opContext.stepCompleted();
    }

    private void buildEndpointNode(ModelNode endpointNode, EndpointService<?, ?> endpointService) {
        ResourceManager resourceManager = endpointService.getResourceManager();
        Set resources = resourceManager.getRootResources();
        for (Object resourceObj : resources) {
            ModelNode rootResourceNode = endpointNode.add();
            this.processResource(resourceManager, rootResourceNode, (Resource)resourceObj);
        }
    }

    private void processResource(ResourceManager<?> resourceManager, ModelNode resourceNode, Resource<?> resource) {
        Set children;
        resourceNode = resourceNode.get(resource.getID().getIDString());
        resourceNode.get("Name").set(resource.getName().getNameString());
        resourceNode.get("Type ID").set(resource.getResourceType().getID().getIDString());
        if (!resource.getResourceConfigurationProperties().isEmpty()) {
            ModelNode resourceConfigNode = resourceNode.get("Resource Configuration");
            for (ResourceConfigurationPropertyInstance config : resource.getResourceConfigurationProperties()) {
                resourceConfigNode.add(config.getName().getNameString(), String.valueOf(config.getValue()));
            }
        }
        if (!(children = resourceManager.getChildren(resource)).isEmpty()) {
            ModelNode childrenNode = resourceNode.get("Children");
            for (Object childObj : children) {
                this.processResource(resourceManager, childrenNode, (Resource)childObj);
            }
        }
    }
}

