/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.extension;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.hawkular.agent.monitor.config.AgentCoreEngineConfiguration;
import org.hawkular.agent.monitor.extension.MonitorPersistentResourceDefinition;
import org.hawkular.agent.monitor.extension.MonitorServiceWriteAttributeHandler;
import org.hawkular.agent.monitor.extension.RemoteJMXAdd;
import org.hawkular.agent.monitor.extension.RemoteJMXAttributes;
import org.hawkular.agent.monitor.extension.RemoteJMXRemove;
import org.hawkular.agent.monitor.extension.RemoteJMXWaitForDefinition;
import org.hawkular.agent.monitor.extension.SubsystemExtension;
import org.hawkular.agent.monitor.protocol.EndpointService;
import org.hawkular.agent.monitor.protocol.ProtocolService;
import org.hawkular.agent.monitor.protocol.ProtocolServices;
import org.hawkular.agent.monitor.scheduler.SchedulerService;
import org.hawkular.agent.monitor.service.MonitorService;
import org.hawkular.agent.monitor.service.ServiceStatus;
import org.hawkular.agent.wildfly.util.Util;
import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.dmr.ModelNode;

public class RemoteJMXDefinition
extends MonitorPersistentResourceDefinition {
    public static final RemoteJMXDefinition INSTANCE = new RemoteJMXDefinition();
    static final String REMOTE_JMX = "remote-jmx";

    private RemoteJMXDefinition() {
        super(PathElement.pathElement((String)REMOTE_JMX), (ResourceDescriptionResolver)SubsystemExtension.getResourceDescriptionResolver("managed-servers", REMOTE_JMX), (OperationStepHandler)RemoteJMXAdd.INSTANCE, (OperationStepHandler)RemoteJMXRemove.INSTANCE, OperationEntry.Flag.RESTART_NONE, OperationEntry.Flag.RESTART_NONE);
    }

    public Collection<AttributeDefinition> getAttributes() {
        return Arrays.asList(RemoteJMXAttributes.ATTRIBUTES);
    }

    protected List<? extends PersistentResourceDefinition> getChildren() {
        return Arrays.asList(RemoteJMXWaitForDefinition.INSTANCE);
    }

    @Override
    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        super.registerAttributes(resourceRegistration);
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)RemoteJMXAttributes.ENABLED, null, (OperationStepHandler)new MonitorServiceWriteAttributeHandler<Void>(new AttributeDefinition[0]){

            @Override
            protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode newValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<Void> handbackHolder) throws OperationFailedException {
                if (context.isBooting()) {
                    return false;
                }
                super.applyUpdateToRuntime(context, operation, attributeName, newValue, currentValue, handbackHolder);
                boolean currBool = RemoteJMXAttributes.ENABLED.resolveValue(context, currentValue).asBoolean();
                boolean newBool = RemoteJMXAttributes.ENABLED.resolveValue(context, newValue).asBoolean();
                if (currBool == newBool) {
                    return false;
                }
                MonitorService monitorService = this.getMonitorService(context);
                if (monitorService == null || monitorService.getStatus() == ServiceStatus.STARTING) {
                    return true;
                }
                ProtocolService jmxService = monitorService.getProtocolServices().getJmxProtocolService();
                String thisEndpointName = context.getCurrentAddressValue();
                if (newBool) {
                    AgentCoreEngineConfiguration config = Util.getMonitorServiceConfiguration(context);
                    ProtocolServices newServices = monitorService.createProtocolServicesBuilder().jmxProtocolService(config.getJmxConfiguration()).build();
                    EndpointService endpointService = (EndpointService)newServices.getJmxProtocolService().getEndpointServices().get(thisEndpointName);
                    jmxService.add(endpointService);
                } else {
                    SchedulerService schedulerService = monitorService.getSchedulerService();
                    jmxService.remove(thisEndpointName, schedulerService);
                }
                return false;
            }

            protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode originalValue, ModelNode newBadValue, Void handback) throws OperationFailedException {
            }
        });
    }
}

